/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.scan.filesystem;

import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.BatchComponent;
import org.sonar.api.config.Settings;

public class FileExclusions
implements BatchComponent {
    private final Settings settings;

    public FileExclusions(Settings settings) {
        this.settings = settings;
    }

    public String[] sourceInclusions() {
        return this.inclusions("sonar.inclusions");
    }

    public String[] testInclusions() {
        return this.inclusions("sonar.test.inclusions");
    }

    private String[] inclusions(String propertyKey) {
        String[] patterns = FileExclusions.sanitize(this.settings.getStringArray(propertyKey));
        ArrayList list = Lists.newArrayList();
        for (String pattern : patterns) {
            if ("**/*".equals(pattern) || "file:**/*".equals(pattern)) continue;
            list.add(pattern);
        }
        return list.toArray(new String[list.size()]);
    }

    public String[] sourceExclusions() {
        return this.exclusions("sonar.global.exclusions", "sonar.exclusions");
    }

    public String[] testExclusions() {
        return this.exclusions("sonar.global.test.exclusions", "sonar.test.exclusions");
    }

    private String[] exclusions(String globalExclusionsProperty, String exclusionsProperty) {
        Object[] globalExclusions = this.settings.getStringArray(globalExclusionsProperty);
        Object[] exclusions = this.settings.getStringArray(exclusionsProperty);
        return FileExclusions.sanitize((String[])ObjectArrays.concat((Object[])globalExclusions, (Object[])exclusions, String.class));
    }

    private static String[] sanitize(String[] patterns) {
        for (int i = 0; i < patterns.length; ++i) {
            patterns[i] = StringUtils.trim((String)patterns[i]);
        }
        return patterns;
    }
}

