/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Serializable;

public class RuleKey
implements Serializable {
    private final String repository;
    private final String rule;

    private RuleKey(String repository, String rule) {
        this.repository = repository;
        this.rule = rule;
    }

    public static RuleKey of(String repository, String rule) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)repository) ? 1 : 0) != 0, (Object)"Repository must be set");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)rule) ? 1 : 0) != 0, (Object)"Rule must be set");
        return new RuleKey(repository, rule);
    }

    public static RuleKey parse(String s) {
        String[] split = s.split(":");
        Preconditions.checkArgument((split.length == 2 ? 1 : 0) != 0, (Object)("Bad format of rule key: " + s));
        return RuleKey.of(split[0], split[1]);
    }

    public String repository() {
        return this.repository;
    }

    public String rule() {
        return this.rule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleKey ruleKey = (RuleKey)o;
        if (!this.repository.equals(ruleKey.repository)) {
            return false;
        }
        return this.rule.equals(ruleKey.rule);
    }

    public int hashCode() {
        int result = this.repository.hashCode();
        result = 31 * result + this.rule.hashCode();
        return result;
    }

    public String toString() {
        return String.format("%s:%s", this.repository, this.rule);
    }
}

