/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.resources.Resource;

public final class Scopes {
    public static final String PROJECT = "PRJ";
    public static final String DIRECTORY = "DIR";
    public static final String FILE = "FIL";
    public static final String PROGRAM_UNIT = "PGU";
    public static final String BLOCK_UNIT = "BLU";
    public static final String[] SORTED_SCOPES = new String[]{"PRJ", "DIR", "FIL", "PGU", "BLU"};

    private Scopes() {
    }

    public static boolean isProject(Resource resource) {
        return StringUtils.equals((String)PROJECT, (String)resource.getScope());
    }

    public static boolean isDirectory(Resource resource) {
        return StringUtils.equals((String)DIRECTORY, (String)resource.getScope());
    }

    public static boolean isFile(Resource resource) {
        return StringUtils.equals((String)FILE, (String)resource.getScope());
    }

    public static boolean isProgramUnit(Resource resource) {
        return StringUtils.equals((String)PROGRAM_UNIT, (String)resource.getScope());
    }

    public static boolean isBlockUnit(Resource resource) {
        return StringUtils.equals((String)BLOCK_UNIT, (String)resource.getScope());
    }

    public static boolean isHigherThan(Resource resource, String than) {
        return Scopes.isHigherThan(resource.getScope(), than);
    }

    public static boolean isHigherThan(String scope, String than) {
        int thanIndex;
        int index = ArrayUtils.indexOf((Object[])SORTED_SCOPES, (Object)scope);
        return index < (thanIndex = ArrayUtils.indexOf((Object[])SORTED_SCOPES, (Object)than));
    }

    public static boolean isHigherThanOrEquals(Resource resource, String than) {
        return Scopes.isHigherThanOrEquals(resource.getScope(), than);
    }

    public static boolean isHigherThanOrEquals(String scope, String than) {
        int thanIndex;
        int index = ArrayUtils.indexOf((Object[])SORTED_SCOPES, (Object)scope);
        return index <= (thanIndex = ArrayUtils.indexOf((Object[])SORTED_SCOPES, (Object)than));
    }
}

