/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.api.ServerComponent;
import org.sonar.api.resources.ResourceType;
import org.sonar.api.resources.ResourceTypeTree;
import org.sonar.api.task.TaskComponent;

@Beta
public class ResourceTypes
implements TaskComponent,
ServerComponent {
    public static final Predicate<ResourceType> AVAILABLE_FOR_FILTERS = new Predicate<ResourceType>(){

        public boolean apply(@Nullable ResourceType input) {
            return input != null && input.getBooleanProperty("supportsMeasureFilters");
        }
    };
    private final Map<String, ResourceTypeTree> treeByQualifier;
    private final Map<String, ResourceType> typeByQualifier;
    private final Collection<ResourceType> rootTypes;

    public ResourceTypes(ResourceTypeTree[] trees) {
        Preconditions.checkNotNull((Object)trees);
        HashMap treeMap = Maps.newHashMap();
        LinkedHashMap typeMap = Maps.newLinkedHashMap();
        HashSet rootsSet = Sets.newHashSet();
        for (ResourceTypeTree tree : trees) {
            rootsSet.add(tree.getRootType());
            for (ResourceType type : tree.getTypes()) {
                if (treeMap.containsKey(type.getQualifier())) {
                    throw new IllegalStateException("Qualifier " + type.getQualifier() + " is defined in several trees");
                }
                treeMap.put(type.getQualifier(), tree);
                typeMap.put(type.getQualifier(), type);
            }
        }
        this.treeByQualifier = ImmutableMap.copyOf((Map)treeMap);
        this.typeByQualifier = ImmutableMap.copyOf((Map)typeMap);
        this.rootTypes = ImmutableList.copyOf((Collection)rootsSet);
    }

    public ResourceType get(String qualifier) {
        ResourceType type = this.typeByQualifier.get(qualifier);
        return type != null ? type : ResourceType.builder(qualifier).build();
    }

    public Collection<ResourceType> getAll() {
        return this.typeByQualifier.values();
    }

    public Collection<ResourceType> getRoots() {
        return this.rootTypes;
    }

    public Collection<ResourceType> getAll(Predicate<ResourceType> predicate) {
        return Collections2.filter(this.typeByQualifier.values(), predicate);
    }

    public Collection<ResourceType> getAllWithPropertyKey(String propertyKey) {
        return Collections2.filter(this.typeByQualifier.values(), (Predicate)new PropertyKeyPredicate(propertyKey));
    }

    public Collection<ResourceType> getAllWithPropertyValue(String propertyKey, String propertyValue) {
        return Collections2.filter(this.typeByQualifier.values(), (Predicate)new StringPropertyValuePredicate(propertyValue, propertyKey));
    }

    public Collection<ResourceType> getAllWithPropertyValue(String propertyKey, boolean propertyValue) {
        return Collections2.filter(this.typeByQualifier.values(), (Predicate)new BooleanPropertyValuePredicate(propertyKey, propertyValue));
    }

    public List<String> getChildrenQualifiers(String qualifier) {
        ResourceTypeTree tree = this.getTree(qualifier);
        if (tree != null) {
            return tree.getChildren(qualifier);
        }
        return Collections.emptyList();
    }

    public List<ResourceType> getChildren(String qualifier) {
        return Lists.transform(this.getChildrenQualifiers(qualifier), (Function)new Function<String, ResourceType>(){

            public ResourceType apply(String s) {
                return (ResourceType)ResourceTypes.this.typeByQualifier.get(s);
            }
        });
    }

    public List<String> getLeavesQualifiers(String qualifier) {
        ResourceTypeTree tree = this.getTree(qualifier);
        if (tree != null) {
            return tree.getLeaves();
        }
        return Collections.emptyList();
    }

    public ResourceTypeTree getTree(String qualifier) {
        return this.treeByQualifier.get(qualifier);
    }

    public ResourceType getRoot(String qualifier) {
        return this.getTree(qualifier).getRootType();
    }

    private static class BooleanPropertyValuePredicate
    implements Predicate<ResourceType> {
        private final String propertyKey;
        private final boolean propertyValue;

        public BooleanPropertyValuePredicate(String propertyKey, boolean propertyValue) {
            this.propertyKey = propertyKey;
            this.propertyValue = propertyValue;
        }

        public boolean apply(@Nullable ResourceType input) {
            return input != null && input.getBooleanProperty(this.propertyKey) == this.propertyValue;
        }
    }

    private static class StringPropertyValuePredicate
    implements Predicate<ResourceType> {
        private final String propertyValue;
        private final String propertyKey;

        public StringPropertyValuePredicate(String propertyValue, String propertyKey) {
            this.propertyValue = propertyValue;
            this.propertyKey = propertyKey;
        }

        public boolean apply(@Nullable ResourceType input) {
            return input != null && Objects.equal((Object)this.propertyValue, (Object)input.getStringProperty(this.propertyKey));
        }
    }

    private static class PropertyKeyPredicate
    implements Predicate<ResourceType> {
        private final String propertyKey;

        public PropertyKeyPredicate(String propertyKey) {
            this.propertyKey = propertyKey;
        }

        public boolean apply(@Nullable ResourceType input) {
            return input != null && input.hasProperty(this.propertyKey);
        }
    }
}

