/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.platform;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.sonar.api.ServerExtension;

public interface NewUserHandler
extends ServerExtension {
    public void doOnNewUser(Context var1);

    public static final class Context {
        private String login;
        private String name;
        private String email;

        private Context(String login, String name, @Nullable String email) {
            Preconditions.checkNotNull((Object)login);
            Preconditions.checkNotNull((Object)name);
            this.login = login;
            this.name = name;
            this.email = email;
        }

        public String getLogin() {
            return this.login;
        }

        public String getName() {
            return this.name;
        }

        public String getEmail() {
            return this.email;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String login;
            private String name;
            private String email;

            private Builder() {
            }

            public Builder setLogin(String s) {
                this.login = s;
                return this;
            }

            public Builder setName(String s) {
                this.name = s;
                return this;
            }

            public Builder setEmail(@Nullable String s) {
                this.email = s;
                return this;
            }

            public Context build() {
                return new Context(this.login, this.name, this.email);
            }
        }
    }
}

