/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.UseLatestVersionsMojoBase;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.api.recording.DependencyChangeRecord;
import org.codehaus.mojo.versions.recording.DefaultDependencyChangeRecord;
import org.codehaus.mojo.versions.rewriting.MutableXMLStreamReader;
import org.codehaus.mojo.versions.utils.ArtifactFactory;
import org.codehaus.mojo.versions.utils.DependencyBuilder;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="update-parent", threadSafe=true)
public class UpdateParentMojo
extends UseLatestVersionsMojoBase {
    @Parameter(property="parentVersion")
    protected String parentVersion = null;
    @Parameter(property="forceUpdate", defaultValue="false")
    protected boolean forceUpdate = false;
    @Parameter(property="skipResolution", defaultValue="false")
    protected boolean skipResolution = false;
    @Parameter(property="allowDowngrade", defaultValue="false")
    protected boolean allowDowngrade;
    @Parameter(property="allowMajorUpdates", defaultValue="true")
    protected boolean allowMajorUpdates = true;
    @Parameter(property="allowMinorUpdates", defaultValue="true")
    protected boolean allowMinorUpdates = true;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    protected boolean allowIncrementalUpdates = true;
    @Parameter(property="allowSnapshots", defaultValue="false")
    protected boolean allowSnapshots;
    private VersionRange targetVersionRange;
    private VersionsHelper helper;

    @Inject
    public UpdateParentMojo(ArtifactFactory artifactFactory, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) throws MojoExecutionException {
        super(artifactFactory, repositorySystem, wagonMap, changeRecorders);
    }

    @Override
    protected boolean getAllowSnapshots() {
        return this.allowSnapshots;
    }

    @Override
    protected boolean getAllowMajorUpdates() {
        return this.allowMajorUpdates;
    }

    @Override
    protected boolean getAllowMinorUpdates() {
        return this.allowMinorUpdates;
    }

    @Override
    protected boolean getAllowIncrementalUpdates() {
        return this.allowIncrementalUpdates;
    }

    @Override
    protected boolean getAllowDowngrade() {
        return this.allowDowngrade;
    }

    @Override
    protected boolean updateFilter(Dependency dep) {
        return true;
    }

    @Override
    protected boolean artifactVersionsFilter(ArtifactVersion ver) {
        return this.targetVersionRange == null || ArtifactVersions.isVersionInRange((ArtifactVersion)ver, (VersionRange)this.targetVersionRange);
    }

    @Override
    protected Optional<ArtifactVersion> versionProducer(Stream<ArtifactVersion> stream) {
        Artifact artifact = this.artifactFactory.createArtifact(DependencyBuilder.newBuilder().withGroupId(this.getProject().getParent().getGroupId()).withArtifactId(this.getProject().getParent().getArtifactId()).withVersion(this.getProject().getParent().getVersion()).withType("pom").build());
        return stream.max(Comparator.naturalOrder()).map(candidate -> {
            if (this.shouldApplyUpdate(artifact, this.getProject().getParent().getVersion(), (ArtifactVersion)candidate, this.forceUpdate)) {
                return candidate;
            }
            this.getLog().debug((CharSequence)"Update not applied. Exiting.");
            return null;
        });
    }

    @Override
    protected boolean getProcessDependencies() {
        return false;
    }

    @Override
    protected boolean getProcessDependencyManagement() {
        return false;
    }

    @Override
    public boolean getProcessParent() {
        return true;
    }

    @Override
    protected void update(MutableXMLStreamReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException, VersionRetrievalException {
        if (this.getProject().getParent() == null) {
            this.getLog().info((CharSequence)"Project does not have a parent");
            return;
        }
        if (this.reactorProjects.contains(this.getProject().getParent())) {
            this.getLog().info((CharSequence)"Project's parent is part of the reactor");
            return;
        }
        if (!this.skipResolution) {
            this.helper = this.getHelper();
            try {
                this.targetVersionRange = this.getTargetVersionRange().orElse(null);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException("Invalid version range specification: " + this.parentVersion, (Exception)((Object)e));
            }
            super.update(pom);
        } else {
            if (StringUtils.isBlank((CharSequence)this.parentVersion)) {
                throw new MojoExecutionException("skipResolution is only valid if parentVersion is set");
            }
            this.getLog().info((CharSequence)("Updating parent from " + this.getProject().getParent().getVersion() + " to " + this.parentVersion));
            if (PomHelper.setProjectParentVersion((MutableXMLStreamReader)pom, (String)this.parentVersion)) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Made an update from " + this.getProject().getParent().getVersion() + " to " + this.parentVersion));
                }
                this.getChangeRecorder().recordChange(DefaultDependencyChangeRecord.builder().withKind(DependencyChangeRecord.ChangeKind.PARENT).withGroupId(this.getProject().getParent().getGroupId()).withArtifactId(this.getProject().getParent().getArtifactId()).withOldVersion(this.getProject().getParent().getVersion()).withNewVersion(this.parentVersion).build());
            }
        }
    }

    private Optional<VersionRange> getTargetVersionRange() throws InvalidVersionSpecificationException {
        try {
            return Optional.ofNullable(this.parentVersion).filter(v -> !StringUtils.isBlank((CharSequence)v)).map(v -> {
                try {
                    VersionRange r = VersionRange.createFromVersionSpec((String)v);
                    if (r.getRecommendedVersion() != null) {
                        return r.restrict(VersionRange.createFromVersionSpec((String)(r.getRecommendedVersion() + ",)")));
                    }
                    return r;
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new IllegalArgumentException(e);
                }
            });
        }
        catch (IllegalArgumentException e) {
            if (e.getCause() instanceof InvalidVersionSpecificationException) {
                throw (InvalidVersionSpecificationException)e.getCause();
            }
            throw e;
        }
    }
}

