/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.Property;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.rewriting.MutableXMLStreamReader;
import org.codehaus.mojo.versions.utils.ArtifactFactory;
import org.codehaus.mojo.versions.utils.PropertiesVersionsFileReader;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="set-property", threadSafe=true)
public class SetPropertyMojo
extends AbstractVersionsUpdaterMojo {
    @Parameter(property="property")
    private String property = null;
    @Parameter(property="newVersion")
    private String newVersion = null;
    @Parameter(property="autoLinkItems", defaultValue="true")
    private boolean autoLinkItems;
    @Parameter(property="propertiesVersionsFile")
    private String propertiesVersionsFile;
    @Parameter(property="profileId")
    private String profileId = null;
    @Parameter(property="allowSnapshots", defaultValue="false")
    protected boolean allowSnapshots;

    @Inject
    public SetPropertyMojo(ArtifactFactory artifactFactory, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) throws MojoExecutionException {
        super(artifactFactory, repositorySystem, wagonMap, changeRecorders);
    }

    @Override
    protected boolean getAllowSnapshots() {
        return this.allowSnapshots;
    }

    @Override
    protected void update(MutableXMLStreamReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        String properties;
        Property[] propertiesConfig;
        if (!StringUtils.isEmpty((CharSequence)this.propertiesVersionsFile)) {
            this.logWrongConfigWarning();
            this.getLog().debug((CharSequence)("Reading properties and versions to update from file: " + this.propertiesVersionsFile));
            PropertiesVersionsFileReader reader = new PropertiesVersionsFileReader(this.propertiesVersionsFile);
            try {
                reader.read();
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Unable to read property file  " + this.propertiesVersionsFile + ". re-run with -X option for more details."));
                this.getLog().debug((CharSequence)("Error while reading  property file " + this.propertiesVersionsFile), (Throwable)e);
                throw new MojoFailureException("Unable to read property file " + this.propertiesVersionsFile);
            }
            propertiesConfig = reader.getPropertiesConfig();
            properties = reader.getProperties();
        } else if (!StringUtils.isEmpty((CharSequence)this.property)) {
            this.getLog().debug((CharSequence)"Reading properties and versions to update from property and newVersion ");
            propertiesConfig = (Property[])Arrays.stream(StringUtils.split((String)this.property, (String)",")).map(prp -> {
                Property propertyConfig = new Property(prp);
                propertyConfig.setVersion(this.newVersion);
                return propertyConfig;
            }).toArray(Property[]::new);
            properties = this.property;
        } else {
            throw new MojoExecutionException("Please provide either 'property' or 'propertiesVersionsFile' parameter.");
        }
        this.update(pom, propertiesConfig, properties);
    }

    private void update(MutableXMLStreamReader pom, Property[] propertiesConfig, String properties) throws MojoExecutionException, XMLStreamException {
        Map propertyVersions = this.getHelper().getVersionPropertiesMap(VersionsHelper.VersionPropertiesMapRequest.builder().withMavenProject(this.getProject()).withPropertyDefinitions(propertiesConfig).withIncludeProperties(properties).withAutoLinkItems(this.autoLinkItems).build());
        for (Map.Entry entry : propertyVersions.entrySet()) {
            String currentVersion;
            String profileToApply;
            Property currentProperty = (Property)entry.getKey();
            PropertyVersions version = (PropertyVersions)entry.getValue();
            String newVersionGiven = currentProperty.getVersion();
            if (StringUtils.isEmpty((CharSequence)this.profileId)) {
                profileToApply = version.getProfileId();
                currentVersion = this.getProject().getProperties().getProperty(currentProperty.getName());
            } else {
                profileToApply = this.profileId;
                currentVersion = this.getProject().getModel().getProfiles().stream().filter(profile -> this.profileId.equals(profile.getId())).findFirst().map(profile -> profile.getProperties().getProperty(currentProperty.getName())).orElse(null);
            }
            if (currentVersion == null) continue;
            PomHelper.setPropertyVersion((MutableXMLStreamReader)pom, (String)profileToApply, (String)currentProperty.getName(), (String)StringUtils.defaultString((String)newVersionGiven));
        }
    }

    private void logWrongConfigWarning() {
        if (!StringUtils.isEmpty((CharSequence)this.property)) {
            this.getLog().warn((CharSequence)"-Dproperty provided but will be ignored as -DpropertiesVersionsFile is used");
        }
        if (!StringUtils.isEmpty((CharSequence)this.newVersion)) {
            this.getLog().warn((CharSequence)"-DnewVersion provided but will be ignored as -DpropertiesVersionsFile is used");
        }
    }
}

