/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.shared.filters;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.jaxb2.shared.Validate;
import org.codehaus.mojo.jaxb2.shared.filters.Filter;

public final class Filters {
    public static <T> boolean matchAtLeastOnce(T object, List<Filter<T>> filters) {
        Validate.notNull(filters, "filters");
        boolean acceptedByAtLeastOneFilter = false;
        for (Filter<T> current : filters) {
            if (!current.accept(object)) continue;
            acceptedByAtLeastOneFilter = true;
            break;
        }
        return acceptedByAtLeastOneFilter;
    }

    public static <T> boolean rejectAtLeastOnce(T object, List<Filter<T>> filters) {
        Validate.notNull(filters, "filters");
        boolean rejectedByAtLeastOneFilter = false;
        for (Filter<T> current : filters) {
            if (current.accept(object)) continue;
            rejectedByAtLeastOneFilter = true;
            break;
        }
        return rejectedByAtLeastOneFilter;
    }

    public static <T> boolean noFilterMatches(T object, List<Filter<T>> filters) {
        Validate.notNull(filters, "filters");
        boolean matchedAtLeastOnce = false;
        for (Filter<T> current : filters) {
            if (!current.accept(object)) continue;
            matchedAtLeastOnce = true;
        }
        return !matchedAtLeastOnce;
    }

    public static FileFilter adapt(final Filter<File> toAdapt) {
        Validate.notNull(toAdapt, "toAdapt");
        if (toAdapt instanceof FileFilter) {
            return (FileFilter)((Object)toAdapt);
        }
        return new FileFilter(){

            @Override
            public boolean accept(File candidate) {
                return toAdapt.accept(candidate);
            }
        };
    }

    public static List<FileFilter> adapt(List<Filter<File>> toAdapt) {
        ArrayList<FileFilter> toReturn = new ArrayList<FileFilter>();
        if (toAdapt != null) {
            for (Filter<File> current : toAdapt) {
                toReturn.add(Filters.adapt(current));
            }
        }
        return toReturn;
    }

    public static <T> void initialize(Log log, List<Filter<T>> filters) {
        Validate.notNull(log, "log");
        Validate.notNull(filters, "filters");
        for (Filter<T> current : filters) {
            current.initialize(log);
        }
    }

    public static <T> void initialize(Log log, Filter<T> ... filters) {
        Validate.notNull(log, "log");
        if (filters != null) {
            for (Filter<T> current : filters) {
                current.initialize(log);
            }
        }
    }
}

