/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.SortedMap;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.NodeProcessor;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.JavaDocData;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.JavaDocRenderer;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.SearchableDocumentation;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.location.ClassLocation;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.location.FieldLocation;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.location.MethodLocation;
import org.codehaus.mojo.jaxb2.shared.Validate;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XsdAnnotationProcessor
implements NodeProcessor {
    public static final String XSD_SCHEMA_NAMESPACE_PREFIX = "xs";
    public static final String ANNOTATION_ELEMENT_NAME = "annotation";
    public static final String DOCUMENTATION_ELEMENT_NAME = "documentation";
    private static final List<String> FIELD_METHOD_ELEMENT_NAMES = Arrays.asList("element", "attribute");
    private SortedMap<ClassLocation, JavaDocData> classJavaDocs;
    private SortedMap<FieldLocation, JavaDocData> fieldJavaDocs;
    private SortedMap<MethodLocation, JavaDocData> methodJavaDocs;
    private JavaDocRenderer renderer;

    public XsdAnnotationProcessor(SearchableDocumentation docs, JavaDocRenderer renderer) {
        Validate.notNull(docs, "docs");
        Validate.notNull(renderer, "renderer");
        this.classJavaDocs = docs.getAll(ClassLocation.class);
        this.fieldJavaDocs = docs.getAll(FieldLocation.class);
        this.methodJavaDocs = docs.getAll(MethodLocation.class);
        this.renderer = renderer;
    }

    @Override
    public boolean accept(Node aNode) {
        if (aNode.getNodeType() != 1 || XsdAnnotationProcessor.getName(aNode) == null) {
            return false;
        }
        boolean toReturn = false;
        if (XsdAnnotationProcessor.getMethodLocation(aNode, this.methodJavaDocs.keySet()) != null) {
            toReturn = true;
        } else if (XsdAnnotationProcessor.getFieldLocation(aNode, this.fieldJavaDocs.keySet()) != null) {
            toReturn = true;
        } else if (XsdAnnotationProcessor.getClassLocation(aNode, this.classJavaDocs.keySet()) != null) {
            toReturn = true;
        }
        return toReturn;
    }

    @Override
    public void process(Node aNode) {
        JavaDocData javaDocData = null;
        ClassLocation location = null;
        ClassLocation classLocation = XsdAnnotationProcessor.getClassLocation(aNode, this.classJavaDocs.keySet());
        if (classLocation != null) {
            javaDocData = (JavaDocData)this.classJavaDocs.get(classLocation);
            location = classLocation;
        } else {
            FieldLocation fieldLocation = XsdAnnotationProcessor.getFieldLocation(aNode, this.fieldJavaDocs.keySet());
            if (fieldLocation != null) {
                javaDocData = (JavaDocData)this.fieldJavaDocs.get(fieldLocation);
                location = fieldLocation;
            } else {
                MethodLocation methodLocation = XsdAnnotationProcessor.getMethodLocation(aNode, this.methodJavaDocs.keySet());
                if (methodLocation != null) {
                    javaDocData = (JavaDocData)this.methodJavaDocs.get(methodLocation);
                    location = methodLocation;
                }
            }
        }
        if (javaDocData == null) {
            throw new IllegalStateException("Could not find JavaDocData for XSD node [" + XsdAnnotationProcessor.getName(aNode) + "] with XPath [" + XsdAnnotationProcessor.getXPathFor(aNode) + "]");
        }
        String standardXsPrefix = XSD_SCHEMA_NAMESPACE_PREFIX;
        Document doc = aNode.getOwnerDocument();
        Element annotation = doc.createElementNS("http://www.w3.org/2001/XMLSchema", ANNOTATION_ELEMENT_NAME);
        Element docElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", DOCUMENTATION_ELEMENT_NAME);
        CDATASection xsdDocumentation = doc.createCDATASection(this.renderer.render(javaDocData, location).trim());
        annotation.setPrefix(XSD_SCHEMA_NAMESPACE_PREFIX);
        docElement.setPrefix(XSD_SCHEMA_NAMESPACE_PREFIX);
        annotation.appendChild(docElement);
        Node firstChildOfCurrentNode = aNode.getFirstChild();
        if (firstChildOfCurrentNode == null) {
            aNode.appendChild(annotation);
        } else {
            aNode.insertBefore(annotation, firstChildOfCurrentNode);
        }
        docElement.appendChild(xsdDocumentation);
    }

    private static MethodLocation getMethodLocation(Node aNode, Set<MethodLocation> methodLocations) {
        MethodLocation validLocation;
        MethodLocation toReturn = null;
        if (aNode != null && FIELD_METHOD_ELEMENT_NAMES.contains(aNode.getLocalName().toLowerCase()) && (validLocation = (MethodLocation)XsdAnnotationProcessor.getFieldOrMethodLocationIfValid(aNode, XsdAnnotationProcessor.getContainingClassOrNull(aNode), methodLocations)) != null && "()".equalsIgnoreCase(validLocation.getParametersAsString())) {
            toReturn = validLocation;
        }
        return toReturn;
    }

    private static FieldLocation getFieldLocation(Node aNode, Set<FieldLocation> fieldLocations) {
        FieldLocation toReturn = null;
        if (aNode != null && FIELD_METHOD_ELEMENT_NAMES.contains(aNode.getLocalName().toLowerCase())) {
            toReturn = (FieldLocation)XsdAnnotationProcessor.getFieldOrMethodLocationIfValid(aNode, XsdAnnotationProcessor.getContainingClassOrNull(aNode), fieldLocations);
        }
        return toReturn;
    }

    private static <T extends FieldLocation> T getFieldOrMethodLocationIfValid(Node aNode, Node containingClassNode, Set<? extends FieldLocation> locations) {
        FieldLocation toReturn = null;
        if (containingClassNode != null) {
            for (FieldLocation fieldLocation : locations) {
                String fieldName = fieldLocation.getMemberName();
                String className = fieldLocation.getClassName();
                try {
                    if (!fieldName.equalsIgnoreCase(XsdAnnotationProcessor.getName(aNode)) || !className.equalsIgnoreCase(XsdAnnotationProcessor.getName(containingClassNode))) continue;
                    toReturn = fieldLocation;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not acquire FieldLocation for fieldName [" + fieldName + "] and className [" + className + "]", e);
                }
            }
        }
        return (T)toReturn;
    }

    private static ClassLocation getClassLocation(Node aNode, Set<ClassLocation> classLocations) {
        if (aNode != null && "complexType".equalsIgnoreCase(aNode.getLocalName())) {
            String nodeClassName = XsdAnnotationProcessor.getName(aNode);
            for (ClassLocation current : classLocations) {
                if (!current.getClassName().equalsIgnoreCase(nodeClassName)) continue;
                return current;
            }
        }
        return null;
    }

    private static String getName(Node aNode) {
        Node nameNode;
        NamedNodeMap attributes = aNode.getAttributes();
        if (attributes != null && (nameNode = attributes.getNamedItem("name")) != null) {
            return nameNode.getNodeValue().trim();
        }
        return null;
    }

    private static Node getContainingClassOrNull(Node aNode) {
        for (Node current = aNode.getParentNode(); current != null; current = current.getParentNode()) {
            String localName = current.getLocalName();
            if (!"complexType".equalsIgnoreCase(localName)) continue;
            return current;
        }
        return null;
    }

    private static String getXPathFor(Node aNode) {
        ArrayList<String> nodeNameList = new ArrayList<String>();
        for (Node current = aNode; current != null; current = current.getParentNode()) {
            nodeNameList.add(current.getNodeName() + "[@name='" + XsdAnnotationProcessor.getName(current) + "]");
        }
        StringBuilder builder = new StringBuilder();
        ListIterator it = nodeNameList.listIterator(nodeNameList.size());
        while (it.hasPrevious()) {
            builder.append((String)it.previous());
            if (!it.hasPrevious()) continue;
            builder.append("/");
        }
        return builder.toString();
    }
}

