/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.packs;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackColor;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.installer.util.PackHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;

public class PacksModel
extends AbstractTableModel {
    private static final long serialVersionUID = 3258128076746733110L;
    private static final transient Logger logger = Logger.getLogger(PacksModel.class.getName());
    protected List<Pack> packs;
    protected final List<Pack> hiddenPacks;
    private final List<Pack> packsToInstall;
    protected final transient RulesEngine rules;
    protected final transient Variables variables;
    private final transient InstallData installData;
    private transient Messages messages;
    private final Map<String, Pack> installedPacks;
    List<CbSelectionState> checkValues;
    private final Map<String, Pack> nameToPack;
    private final Map<String, Integer> nameToRow;
    private final boolean modifyInstallation;

    public PacksModel(InstallData idata) {
        this.installData = idata;
        this.rules = idata.getRules();
        try {
            this.messages = idata.getMessages().newMessages("packsLang.xml");
        }
        catch (ResourceNotFoundException ex) {
            this.messages = idata.getMessages();
        }
        this.variables = idata.getVariables();
        this.packsToInstall = idata.getSelectedPacks();
        this.modifyInstallation = Boolean.valueOf(idata.getVariable("modify.izpack.install"));
        this.installedPacks = this.loadInstallationInformation(this.modifyInstallation);
        this.packs = this.getVisiblePacks();
        this.hiddenPacks = this.getHiddenPacks();
        this.nameToRow = this.getNametoRowMapping(this.packs);
        this.nameToPack = this.getNametoPackMapping(idata.getAvailablePacks());
        this.packs = this.setPackProperties(this.packs, this.nameToPack);
        this.checkValues = this.initCheckValues(this.packs, this.packsToInstall);
        this.updateConditions(true);
        this.updatePacksToInstall();
    }

    private List<Pack> getHiddenPacks() {
        ArrayList<Pack> hiddenPacks = new ArrayList<Pack>();
        for (Pack availablePack : this.installData.getAvailablePacks()) {
            if (!availablePack.isHidden()) continue;
            hiddenPacks.add(availablePack);
        }
        return hiddenPacks;
    }

    public List<Pack> getVisiblePacks() {
        ArrayList<Pack> visiblePacks = new ArrayList<Pack>();
        for (Pack availablePack : this.installData.getAvailablePacks()) {
            if (availablePack.isHidden()) continue;
            visiblePacks.add(availablePack);
        }
        return visiblePacks;
    }

    private Map<String, Pack> getNametoPackMapping(List<Pack> packs) {
        HashMap<String, Pack> nameToPack = new HashMap<String, Pack>();
        for (Pack pack : packs) {
            nameToPack.put(pack.getName(), pack);
        }
        return nameToPack;
    }

    private Map<String, Integer> getNametoRowMapping(List<Pack> packs) {
        HashMap<String, Integer> nameToPos = new HashMap<String, Integer>();
        for (int i = 0; i < packs.size(); ++i) {
            Pack pack = packs.get(i);
            nameToPos.put(pack.getName(), i);
        }
        return nameToPos;
    }

    private List<Pack> setPackProperties(List<Pack> packs, Map<String, Pack> nameToPack) {
        for (Pack pack : packs) {
            Pack parent;
            if (pack.hasParent()) {
                String parentName = pack.getParent();
                parent = nameToPack.get(parentName);
                parent.addChild(pack.getName());
            }
            if (!pack.hasDependencies()) continue;
            for (String name : pack.getDependencies()) {
                parent = nameToPack.get(name);
                parent.addDependant(pack.getName());
            }
        }
        return packs;
    }

    public Pack getPackAtRow(int row) {
        return this.packs.get(row);
    }

    private void updateConditions() {
        this.updateConditions(false);
    }

    private void updateConditions(boolean initial) {
        boolean changes = true;
        while (changes) {
            changes = false;
            for (Pack pack : this.packs) {
                String packName = pack.getName();
                int pos = this.getPos(packName);
                if (this.rules.canInstallPack(packName, this.variables)) continue;
                logger.fine("Conditions for pack '" + packName + "' are not complied with");
                if (this.rules.canInstallPackOptional(packName, this.variables)) {
                    logger.fine("Pack '" + packName + "' can be installed optionally.");
                    if (!initial || this.checkValues.get(pos) == CbSelectionState.DESELECTED) continue;
                    this.checkValues.set(pos, CbSelectionState.DESELECTED);
                    changes = true;
                    continue;
                }
                if (this.checkValues.get(pos) == CbSelectionState.DEPENDENT_DESELECTED) continue;
                logger.fine("Pack '" + packName + "' cannot be installed");
                this.checkValues.set(pos, CbSelectionState.DEPENDENT_DESELECTED);
                changes = true;
            }
        }
    }

    public void updateTable() {
        this.updateDeps();
        this.updateConditions();
        this.updatePacksToInstall();
        this.fireTableDataChanged();
    }

    private List<CbSelectionState> initCheckValues(List<Pack> packs, List<Pack> packsToInstall) {
        Pack pack2;
        int i;
        CbSelectionState[] checkValues = new CbSelectionState[packs.size()];
        for (i = 0; i < packs.size(); ++i) {
            pack2 = packs.get(i);
            checkValues[i] = packsToInstall.contains(pack2) ? CbSelectionState.SELECTED : CbSelectionState.DESELECTED;
        }
        for (i = 0; i < packs.size(); ++i) {
            CbSelectionState checkState;
            pack2 = packs.get(i);
            if (checkValues[i] == CbSelectionState.DESELECTED) {
                List deps = pack2.getDependants();
                for (int j = 0; deps != null && j < deps.size(); ++j) {
                    String name = (String)deps.get(j);
                    int pos = this.getPos(name);
                    checkValues[pos] = CbSelectionState.DEPENDENT_DESELECTED;
                }
            }
            if ((checkState = checkValues[i]) == null || !checkState.isFullyOrPartiallySelected() || pack2.getExcludeGroup() == null) continue;
            for (int q = 0; q < packs.size(); ++q) {
                if (q == i) continue;
                Pack otherPack = packs.get(q);
                if (!pack2.getExcludeGroup().equals(otherPack.getExcludeGroup()) || checkValues[q] != CbSelectionState.SELECTED) continue;
                checkValues[q] = CbSelectionState.DESELECTED;
            }
        }
        for (Pack pack2 : packs) {
            if (!pack2.isRequired()) continue;
            checkValues = this.propRequirement(pack2.getName(), Arrays.asList(checkValues)).toArray(new CbSelectionState[checkValues.length]);
        }
        return Arrays.asList(checkValues);
    }

    private List<CbSelectionState> propRequirement(String name, List<CbSelectionState> checkValues) {
        Iterator i$;
        int pos = this.getPos(name);
        checkValues.set(pos, CbSelectionState.REQUIRED_SELECTED);
        List deps = this.packs.get(pos).getDependencies();
        if (deps != null && (i$ = deps.iterator()).hasNext()) {
            String s = (String)i$.next();
            return this.propRequirement(s, checkValues);
        }
        return checkValues;
    }

    private int getPos(String name) {
        return this.nameToRow.get(name);
    }

    @Override
    public int getRowCount() {
        return this.packs.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Integer.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        CbSelectionState state = this.checkValues.get(rowIndex);
        return state != null && state.isSelectable() && columnIndex == 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Pack pack = this.packs.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                CbSelectionState state = this.checkValues.get(rowIndex);
                return state != null ? this.checkValues.get(rowIndex) : null;
            }
            case 1: {
                return PackHelper.getPackName((Pack)pack, (Messages)this.messages);
            }
            case 2: {
                return Pack.toByteUnitsString((long)pack.getSize());
            }
        }
        return null;
    }

    public void toggleValueAt(int rowIndex) {
        CbSelectionState state = this.checkValues.get(rowIndex);
        if (state != null && this.checkValues.get(rowIndex) == CbSelectionState.SELECTED) {
            this.setValueAt((Object)CbSelectionState.DESELECTED, rowIndex, 0);
        } else {
            this.setValueAt((Object)CbSelectionState.SELECTED, rowIndex, 0);
        }
    }

    @Override
    public void setValueAt(Object checkValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0 && checkValue instanceof CbSelectionState) {
            boolean added;
            Pack pack = this.packs.get(rowIndex);
            if ((CbSelectionState)((Object)checkValue) == CbSelectionState.SELECTED) {
                added = true;
                String name = pack.getName();
                if (this.rules.canInstallPack(name, this.variables) || this.rules.canInstallPackOptional(name, this.variables)) {
                    if (pack.isRequired()) {
                        this.checkValues.set(rowIndex, CbSelectionState.REQUIRED_SELECTED);
                    } else {
                        this.checkValues.set(rowIndex, CbSelectionState.SELECTED);
                    }
                }
            } else {
                added = false;
                this.checkValues.set(rowIndex, CbSelectionState.DESELECTED);
            }
            this.updateExcludes(rowIndex);
            this.updateDeps();
            if (added) {
                this.onSelectionUpdate(rowIndex);
                this.packsToInstall.add(pack);
                this.updateConditions();
                this.packsToInstall.remove(pack);
            } else {
                this.onDeselectionUpdate(rowIndex);
                this.packsToInstall.remove(pack);
                this.updateConditions();
                this.packsToInstall.add(pack);
            }
            this.updatePacksToInstall();
            if (pack.hasParent()) {
                this.updateParent(pack);
            } else if (pack.hasChildren()) {
                this.updateChildren(pack);
            }
            this.fireTableDataChanged();
        }
    }

    private void updateParent(Pack childPack) {
        String parentName = childPack.getParent();
        Pack parentPack = this.nameToPack.get(parentName);
        int parentPosition = this.nameToRow.get(parentName);
        int childrenSelected = 0;
        for (String childName : parentPack.getChildren()) {
            int childPosition = this.nameToRow.get(childName);
            if (!this.isChecked(childPosition)) continue;
            ++childrenSelected;
        }
        if (parentPack.getChildren().size() == childrenSelected) {
            if (!this.checkValues.get(parentPosition).isSelectable()) {
                this.checkValues.set(parentPosition, CbSelectionState.REQUIRED_SELECTED);
            } else {
                this.checkValues.set(parentPosition, CbSelectionState.SELECTED);
            }
        } else if (childrenSelected > 0) {
            if (!this.checkValues.get(parentPosition).isSelectable()) {
                this.checkValues.set(parentPosition, CbSelectionState.REQUIRED_PARTIAL_SELECTED);
            } else {
                this.checkValues.set(parentPosition, CbSelectionState.PARTIAL_SELECTED);
            }
        } else if (!this.checkValues.get(parentPosition).isSelectable()) {
            this.checkValues.set(parentPosition, CbSelectionState.REQUIRED_DESELECTED);
        } else {
            this.checkValues.set(parentPosition, CbSelectionState.DESELECTED);
        }
    }

    private void updateChildren(Pack parentPack) {
        String parentName = parentPack.getName();
        int parentPosition = this.nameToRow.get(parentName);
        CbSelectionState parentValue = this.checkValues.get(parentPosition);
        for (String childName : parentPack.getChildren()) {
            int childPosition = this.nameToRow.get(childName);
            this.checkValues.set(childPosition, parentValue);
        }
    }

    private void selectionUpdate(Map<String, String> packsData) {
        RulesEngine rules = this.installData.getRules();
        for (Map.Entry<String, String> packData : packsData.entrySet()) {
            CbSelectionState value;
            int packPos;
            Pack pack;
            String packName = packData.getKey();
            String condition = packData.getValue();
            if (condition != null && !rules.isConditionTrue(condition)) {
                return;
            }
            if (packName.startsWith("!")) {
                packName = packName.substring(1);
                pack = this.nameToPack.get(packName);
                packPos = this.getPos(packName);
                value = CbSelectionState.DESELECTED;
            } else {
                pack = this.nameToPack.get(packName);
                packPos = this.getPos(packName);
                value = CbSelectionState.SELECTED;
            }
            if (pack.isRequired() || !this.dependenciesResolved(pack)) continue;
            this.checkValues.set(packPos, value);
        }
    }

    private void onSelectionUpdate(int index) {
        Pack pack = this.packs.get(index);
        Map packsData = pack.getOnSelect();
        this.selectionUpdate(packsData);
    }

    private void onDeselectionUpdate(int index) {
        Pack pack = this.packs.get(index);
        Map packsData = pack.getOnDeselect();
        this.selectionUpdate(packsData);
    }

    public List<Pack> updatePacksToInstall() {
        this.packsToInstall.clear();
        for (int i = 0; i < this.packs.size(); ++i) {
            Pack pack = this.packs.get(i);
            if (this.isChecked(i) && !this.installedPacks.containsKey(pack.getName())) {
                this.packsToInstall.add(pack);
                continue;
            }
            if (!this.installedPacks.containsKey(pack.getName())) continue;
            this.checkValues.set(i, CbSelectionState.REQUIRED_PARTIAL_SELECTED);
        }
        for (Pack hiddenPack : this.hiddenPacks) {
            if (!this.rules.canInstallPack(hiddenPack.getName(), this.variables)) continue;
            this.packsToInstall.add(hiddenPack);
        }
        this.installData.setSelectedPacks(this.packsToInstall);
        return this.packsToInstall;
    }

    private void updateDeps() {
        int i;
        int[] statusArray = new int[this.packs.size()];
        for (i = 0; i < statusArray.length; ++i) {
            statusArray[i] = 0;
        }
        this.dfs(statusArray);
        for (i = 0; i < statusArray.length; ++i) {
            if (statusArray[i] == 0 && !this.checkValues.get(i).isSelectable()) {
                this.checkValues.set(i, CbSelectionState.PARTIAL_SELECTED);
            }
            if (statusArray[i] != 1 || !this.checkValues.get(i).isSelectable()) continue;
            this.checkValues.set(i, CbSelectionState.DEPENDENT_DESELECTED);
        }
        for (Pack pack : this.packs) {
            String name;
            if (!pack.isRequired() || !this.rules.canInstallPack(name = pack.getName(), this.variables) && this.rules.canInstallPackOptional(name, this.variables)) continue;
            this.checkValues = this.propRequirement(name, this.checkValues);
        }
    }

    private void updateExcludes(int rowindex) {
        CbSelectionState value = this.checkValues.get(rowindex);
        Pack pack = this.packs.get(rowindex);
        if (value != null && value.isFullyOrPartiallySelected() && pack.getExcludeGroup() != null) {
            for (int q = 0; q < this.packs.size(); ++q) {
                if (rowindex == q) continue;
                Pack otherPack = this.packs.get(q);
                String name1 = otherPack.getExcludeGroup();
                String name2 = pack.getExcludeGroup();
                if (!name2.equals(name1) || this.checkValues.get(q) != CbSelectionState.SELECTED) continue;
                this.checkValues.set(q, CbSelectionState.DESELECTED);
            }
        }
    }

    private void dfs(int[] status) {
        HashMap<String, PackColor> colours = new HashMap<String, PackColor>();
        for (int i = 0; i < this.packs.size(); ++i) {
            boolean wipe;
            for (Pack pack : this.packs) {
                colours.put(pack.getName(), PackColor.WHITE);
            }
            Pack pack = this.packs.get(i);
            if (this.dfsVisit(pack, status, wipe = false, colours) == 0) continue;
            return;
        }
    }

    private int dfsVisit(Pack u, int[] status, boolean wipe, Map<String, PackColor> colours) {
        List deps;
        colours.put(u.getName(), PackColor.GREY);
        CbSelectionState check = this.checkValues.get(this.getPos(u.getName()));
        if (!check.isSelectedOrRequiredSelected()) {
            wipe = true;
        }
        if ((deps = u.getDependants()) != null) {
            for (String name : deps) {
                int result;
                Pack v = this.nameToPack.get(name);
                if (wipe) {
                    status[this.getPos((String)v.getName())] = 1;
                }
                if (colours.get(v.getName()) != PackColor.WHITE || (result = this.dfsVisit(v, status, wipe, colours)) == 0) continue;
                return result;
            }
        }
        colours.put(u.getName(), PackColor.BLACK);
        return 0;
    }

    public Map<String, Pack> getInstalledPacks() {
        return this.installedPacks;
    }

    public boolean isModifyInstallation() {
        return this.modifyInstallation;
    }

    private void removeAlreadyInstalledPacks(List<Pack> selectedPacks, Map<String, Pack> installedPacks) {
        ArrayList<Pack> removePacks = new ArrayList<Pack>();
        for (Pack selectedPack : selectedPacks) {
            if (!installedPacks.containsKey(selectedPack.getName())) continue;
            removePacks.add(selectedPack);
        }
        for (Pack removePack : removePacks) {
            selectedPacks.remove(removePack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Pack> loadInstallationInformation(boolean modifyInstallation) {
        HashMap<String, Pack> readPacks = new HashMap<String, Pack>();
        if (!modifyInstallation) {
            return readPacks;
        }
        ObjectInputStream oin = null;
        File installInfo = new File(this.installData.getInstallPath(), ".installationinformation");
        try {
            if (installInfo.exists()) {
                FileInputStream fin = new FileInputStream(installInfo);
                oin = new ObjectInputStream(fin);
                List packsinstalled = (List)oin.readObject();
                for (Pack installedpack : packsinstalled) {
                    readPacks.put(installedpack.getName(), installedpack);
                }
                this.removeAlreadyInstalledPacks(this.installData.getSelectedPacks(), readPacks);
                logger.fine("Found " + packsinstalled.size() + " installed packs");
                Properties variables = (Properties)oin.readObject();
                for (Object key : variables.keySet()) {
                    this.installData.setVariable((String)key, (String)variables.get(key));
                }
            }
        }
        catch (Exception e) {
            logger.warning("Could not read installation information: " + e.getMessage());
        }
        finally {
            if (oin != null) {
                try {
                    oin.close();
                }
                catch (IOException ignored) {}
            }
        }
        return readPacks;
    }

    private boolean dependenciesResolved(Pack pack) {
        if (!pack.hasDependencies()) {
            return true;
        }
        for (String dependentPackName : pack.getDependencies()) {
            if (this.isChecked(this.nameToRow.get(dependentPackName))) continue;
            return false;
        }
        return true;
    }

    public Map<String, Pack> getNameToPack() {
        return this.nameToPack;
    }

    public Map<Pack, Integer> getPacksToRowNumbers() {
        HashMap<Pack, Integer> packsToRowNumbers = new HashMap<Pack, Integer>();
        for (Map.Entry<String, Integer> entry : this.nameToRow.entrySet()) {
            packsToRowNumbers.put(this.nameToPack.get(entry.getKey()), entry.getValue());
        }
        return packsToRowNumbers;
    }

    public Map<String, Integer> getNameToRow() {
        return this.nameToRow;
    }

    public long getTotalByteSize() {
        Map<Pack, Integer> packToRow = this.getPacksToRowNumbers();
        long bytes = 0L;
        for (Pack pack : this.packs) {
            int row = packToRow.get(pack);
            if (!this.isChecked(row)) continue;
            bytes += pack.getSize();
        }
        return bytes;
    }

    public boolean isChecked(int row) {
        CbSelectionState state = this.checkValues.get(row);
        return state != null ? state.isChecked() : false;
    }

    public boolean isPartiallyChecked(int row) {
        CbSelectionState state = this.checkValues.get(row);
        return state != null ? state.isPartiallyChecked() : false;
    }

    public boolean isCheckBoxSelectable(int row) {
        CbSelectionState state = this.checkValues.get(row);
        return state != null ? state.isSelectable() : false;
    }

    public boolean dependenciesExist() {
        for (Pack pack : this.getVisiblePacks()) {
            if (!pack.hasDependencies()) continue;
            return true;
        }
        return false;
    }

    public Pack getPack(String packName) {
        return this.nameToPack.get(packName);
    }

    public static enum CbSelectionState {
        PARTIAL_SELECTED(2),
        SELECTED(1),
        DESELECTED(0),
        REQUIRED_SELECTED(-1),
        DEPENDENT_DESELECTED(-2),
        REQUIRED_PARTIAL_SELECTED(-3),
        REQUIRED_DESELECTED(-4);

        private final int value;

        private CbSelectionState(int value) {
            this.value = value;
        }

        public boolean isFullyOrPartiallySelected() {
            return this.value > 0;
        }

        public boolean isSelectable() {
            return this.value >= 0;
        }

        public boolean isSelectedOrRequiredSelected() {
            int ordinal = this.ordinal();
            return SELECTED.ordinal() == ordinal || REQUIRED_SELECTED.ordinal() == ordinal;
        }

        public boolean isChecked() {
            int ordinal = this.ordinal();
            return SELECTED.ordinal() == ordinal || REQUIRED_SELECTED.ordinal() == ordinal || PARTIAL_SELECTED.ordinal() == ordinal || REQUIRED_PARTIAL_SELECTED.ordinal() == ordinal;
        }

        public boolean isPartiallyChecked() {
            int ordinal = this.ordinal();
            return PARTIAL_SELECTED.ordinal() == ordinal || REQUIRED_PARTIAL_SELECTED.ordinal() == ordinal;
        }
    }
}

