/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.htmlinfo;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.console.AbstractTextConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.util.Console;

public class HTMLInfoConsolePanel
extends AbstractTextConsolePanel {
    private final Resources resources;
    private final String panelId;
    private final String resourcePrefix;

    public HTMLInfoConsolePanel(PanelView<ConsolePanel> panel, Resources resources) {
        this(panel, resources, "HTMLInfoPanel");
    }

    public HTMLInfoConsolePanel(PanelView<ConsolePanel> panel, Resources resources, String resourcePrefix) {
        super(panel);
        this.panelId = panel.getPanelId();
        this.resources = resources;
        this.resourcePrefix = resourcePrefix;
    }

    public boolean run(InstallData installData, Console console) {
        super.run(installData, console);
        console.println(installData.getMessages().get("InfoPanel.info", new Object[0]));
        return true;
    }

    protected String getText() {
        String result = null;
        if (this.panelId != null) {
            result = this.resources.getString(this.resourcePrefix + "." + this.panelId, null);
        }
        if (result == null) {
            result = this.resources.getString(this.resourcePrefix + ".info", null);
        }
        if (result != null) {
            result = this.removeHTML(result);
        }
        return result;
    }
}

