// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_objdetect;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;
import org.bytedeco.opencv.opencv_features2d.*;
import static org.bytedeco.opencv.global.opencv_features2d.*;
import org.bytedeco.opencv.opencv_calib3d.*;
import static org.bytedeco.opencv.global.opencv_calib3d.*;

import static org.bytedeco.opencv.global.opencv_objdetect.*;


/**\brief Implementation of HOG (Histogram of Oriented Gradients) descriptor and object detector.
<p>
the HOG descriptor algorithm introduced by Navneet Dalal and Bill Triggs \cite Dalal2005 .
<p>
useful links:
<p>
https://hal.inria.fr/inria-00548512/document/
<p>
https://en.wikipedia.org/wiki/Histogram_of_oriented_gradients
<p>
https://software.intel.com/en-us/ipp-dev-reference-histogram-of-oriented-gradients-hog-descriptor
<p>
http://www.learnopencv.com/histogram-of-oriented-gradients
<p>
http://www.learnopencv.com/handwritten-digits-classification-an-opencv-c-python-tutorial
 <p>
 */
@Namespace("cv") @NoOffset @Properties(inherit = org.bytedeco.opencv.presets.opencv_objdetect.class)
public class HOGDescriptor extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public HOGDescriptor(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public HOGDescriptor(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public HOGDescriptor position(long position) {
        return (HOGDescriptor)super.position(position);
    }
    @Override public HOGDescriptor getPointer(long i) {
        return new HOGDescriptor((Pointer)this).offsetAddress(i);
    }

    /** enum cv::HOGDescriptor::HistogramNormType */
    public static final int /** Default histogramNormType */
 L2Hys = 0;
    /** enum cv::HOGDescriptor:: */
    public static final int /** Default nlevels value. */
 DEFAULT_NLEVELS = 64;
    /** enum cv::HOGDescriptor::DescriptorStorageFormat */
    public static final int DESCR_FORMAT_COL_BY_COL = 0, DESCR_FORMAT_ROW_BY_ROW = 1;

    /**\brief Creates the HOG descriptor and detector with default params.
    <p>
    aqual to HOGDescriptor(Size(64,128), Size(16,16), Size(8,8), Size(8,8), 9 )
    */
    public HOGDescriptor() { super((Pointer)null); allocate(); }
    private native void allocate();

    /** \overload
    @param _winSize sets winSize with given value.
    @param _blockSize sets blockSize with given value.
    @param _blockStride sets blockStride with given value.
    @param _cellSize sets cellSize with given value.
    @param _nbins sets nbins with given value.
    @param _derivAperture sets derivAperture with given value.
    @param _winSigma sets winSigma with given value.
    @param _histogramNormType sets histogramNormType with given value.
    @param _L2HysThreshold sets L2HysThreshold with given value.
    @param _gammaCorrection sets gammaCorrection with given value.
    @param _nlevels sets nlevels with given value.
    @param _signedGradient sets signedGradient with given value.
    */
    public HOGDescriptor(@ByVal Size _winSize, @ByVal Size _blockSize, @ByVal Size _blockStride,
                      @ByVal Size _cellSize, int _nbins, int _derivAperture/*=1*/, double _winSigma/*=-1*/,
                      @Cast("cv::HOGDescriptor::HistogramNormType") int _histogramNormType/*=cv::HOGDescriptor::L2Hys*/,
                      double _L2HysThreshold/*=0.2*/, @Cast("bool") boolean _gammaCorrection/*=false*/,
                      int _nlevels/*=cv::HOGDescriptor::DEFAULT_NLEVELS*/, @Cast("bool") boolean _signedGradient/*=false*/) { super((Pointer)null); allocate(_winSize, _blockSize, _blockStride, _cellSize, _nbins, _derivAperture, _winSigma, _histogramNormType, _L2HysThreshold, _gammaCorrection, _nlevels, _signedGradient); }
    private native void allocate(@ByVal Size _winSize, @ByVal Size _blockSize, @ByVal Size _blockStride,
                      @ByVal Size _cellSize, int _nbins, int _derivAperture/*=1*/, double _winSigma/*=-1*/,
                      @Cast("cv::HOGDescriptor::HistogramNormType") int _histogramNormType/*=cv::HOGDescriptor::L2Hys*/,
                      double _L2HysThreshold/*=0.2*/, @Cast("bool") boolean _gammaCorrection/*=false*/,
                      int _nlevels/*=cv::HOGDescriptor::DEFAULT_NLEVELS*/, @Cast("bool") boolean _signedGradient/*=false*/);
    public HOGDescriptor(@ByVal Size _winSize, @ByVal Size _blockSize, @ByVal Size _blockStride,
                      @ByVal Size _cellSize, int _nbins) { super((Pointer)null); allocate(_winSize, _blockSize, _blockStride, _cellSize, _nbins); }
    private native void allocate(@ByVal Size _winSize, @ByVal Size _blockSize, @ByVal Size _blockStride,
                      @ByVal Size _cellSize, int _nbins);

    /** \overload
    @param filename The file name containing HOGDescriptor properties and coefficients for the linear SVM classifier.
    */
    public HOGDescriptor(@Str BytePointer filename) { super((Pointer)null); allocate(filename); }
    private native void allocate(@Str BytePointer filename);
    public HOGDescriptor(@Str String filename) { super((Pointer)null); allocate(filename); }
    private native void allocate(@Str String filename);

    /** \overload
    @param d the HOGDescriptor which cloned to create a new one.
    */
    public HOGDescriptor(@Const @ByRef HOGDescriptor d) { super((Pointer)null); allocate(d); }
    private native void allocate(@Const @ByRef HOGDescriptor d);

    /**\brief Default destructor.
    */

    /**\brief Returns the number of coefficients required for the classification.
    */
    public native @Cast("size_t") long getDescriptorSize();

    /** \brief Checks if detector size equal to descriptor size.
    */
    public native @Cast("bool") boolean checkDetectorSize();

    /** \brief Returns winSigma value
    */
    public native double getWinSigma();

    /**\example samples/cpp/peopledetect.cpp
    */
    /**\brief Sets coefficients for the linear SVM classifier.
    @param svmdetector coefficients for the linear SVM classifier.
    */
    public native void setSVMDetector(@ByVal Mat svmdetector);
    public native void setSVMDetector(@ByVal UMat svmdetector);
    public native void setSVMDetector(@ByVal GpuMat svmdetector);

    /** \brief Reads HOGDescriptor parameters from a cv::FileNode.
    @param fn File node
    */
    public native @Cast("bool") boolean read(@ByRef FileNode fn);

    /** \brief Stores HOGDescriptor parameters in a cv::FileStorage.
    @param fs File storage
    @param objname Object name
    */
    public native void write(@ByRef FileStorage fs, @Str BytePointer objname);
    public native void write(@ByRef FileStorage fs, @Str String objname);

    /** \brief loads HOGDescriptor parameters and coefficients for the linear SVM classifier from a file.
    @param filename Path of the file to read.
    @param objname The optional name of the node to read (if empty, the first top-level node will be used).
    */
    public native @Cast("bool") boolean load(@Str BytePointer filename, @Str BytePointer objname/*=cv::String()*/);
    public native @Cast("bool") boolean load(@Str BytePointer filename);
    public native @Cast("bool") boolean load(@Str String filename, @Str String objname/*=cv::String()*/);
    public native @Cast("bool") boolean load(@Str String filename);

    /** \brief saves HOGDescriptor parameters and coefficients for the linear SVM classifier to a file
    @param filename File name
    @param objname Object name
    */
    public native void save(@Str BytePointer filename, @Str BytePointer objname/*=cv::String()*/);
    public native void save(@Str BytePointer filename);
    public native void save(@Str String filename, @Str String objname/*=cv::String()*/);
    public native void save(@Str String filename);

    /** \brief clones the HOGDescriptor
    @param c cloned HOGDescriptor
    */
    public native void copyTo(@ByRef HOGDescriptor c);

    /**\example samples/cpp/train_HOG.cpp
    */
    /** \brief Computes HOG descriptors of given image.
    @param img Matrix of the type CV_8U containing an image where HOG features will be calculated.
    @param descriptors Matrix of the type CV_32F
    @param winStride Window stride. It must be a multiple of block stride.
    @param padding Padding
    @param locations Vector of Point
    */
    public native void compute(@ByVal Mat img,
                             @StdVector FloatPointer descriptors,
                             @ByVal(nullValue = "cv::Size()") Size winStride, @ByVal(nullValue = "cv::Size()") Size padding,
                             @Const @ByRef(nullValue = "std::vector<cv::Point>()") PointVector locations);
    public native void compute(@ByVal Mat img,
                             @StdVector FloatPointer descriptors);
    public native void compute(@ByVal Mat img,
                             @StdVector FloatBuffer descriptors,
                             @ByVal(nullValue = "cv::Size()") Size winStride, @ByVal(nullValue = "cv::Size()") Size padding,
                             @Const @ByRef(nullValue = "std::vector<cv::Point>()") PointVector locations);
    public native void compute(@ByVal Mat img,
                             @StdVector FloatBuffer descriptors);
    public native void compute(@ByVal Mat img,
                             @StdVector float[] descriptors,
                             @ByVal(nullValue = "cv::Size()") Size winStride, @ByVal(nullValue = "cv::Size()") Size padding,
                             @Const @ByRef(nullValue = "std::vector<cv::Point>()") PointVector locations);
    public native void compute(@ByVal Mat img,
                             @StdVector float[] descriptors);
    public native void compute(@ByVal UMat img,
                             @StdVector FloatPointer descriptors,
                             @ByVal(nullValue = "cv::Size()") Size winStride, @ByVal(nullValue = "cv::Size()") Size padding,
                             @Const @ByRef(nullValue = "std::vector<cv::Point>()") PointVector locations);
    public native void compute(@ByVal UMat img,
                             @StdVector FloatPointer descriptors);
    public native void compute(@ByVal UMat img,
                             @StdVector FloatBuffer descriptors,
                             @ByVal(nullValue = "cv::Size()") Size winStride, @ByVal(nullValue = "cv::Size()") Size padding,
                             @Const @ByRef(nullValue = "std::vector<cv::Point>()") PointVector locations);
    public native void compute(@ByVal UMat img,
                             @StdVector FloatBuffer descriptors);
    public native void compute(@ByVal UMat img,
                             @StdVector float[] descriptors,
                             @ByVal(nullValue = "cv::Size()") Size winStride, @ByVal(nullValue = "cv::Size()") Size padding,
                             @Const @ByRef(nullValue = "std::vector<cv::Point>()") PointVector locations);
    public native void compute(@ByVal UMat img,
                             @StdVector float[] descriptors);
    public native void compute(@ByVal GpuMat img,
                             @StdVector FloatPointer descriptors,
                             @ByVal(nullValue = "cv::Size()") Size winStride, @ByVal(nullValue = "cv::Size()") Size padding,
                             @Const @ByRef(nullValue = "std::vector<cv::Point>()") PointVector locations);
    public native void compute(@ByVal GpuMat img,
                             @StdVector FloatPointer descriptors);
    public native void compute(@ByVal GpuMat img,
                             @StdVector FloatBuffer descriptors,
                             @ByVal(nullValue = "cv::Size()") Size winStride, @ByVal(nullValue = "cv::Size()") Size padding,
                             @Const @ByRef(nullValue = "std::vector<cv::Point>()") PointVector locations);
    public native void compute(@ByVal GpuMat img,
                             @StdVector FloatBuffer descriptors);
    public native void compute(@ByVal GpuMat img,
                             @StdVector float[] descriptors,
                             @ByVal(nullValue = "cv::Size()") Size winStride, @ByVal(nullValue = "cv::Size()") Size padding,
                             @Const @ByRef(nullValue = "std::vector<cv::Point>()") PointVector locations);
    public native void compute(@ByVal GpuMat img,
                             @StdVector float[] descriptors);

    /** \brief Performs object detection without a multi-scale window.
    @param img Matrix of the type CV_8U or CV_8UC3 containing an image where objects are detected.
    @param foundLocations Vector of point where each point contains left-top corner point of detected object boundaries.
    @param weights Vector that will contain confidence values for each detected object.
    @param hitThreshold Threshold for the distance between features and SVM classifying plane.
    Usually it is 0 and should be specified in the detector coefficients (as the last free coefficient).
    But if the free coefficient is omitted (which is allowed), you can specify it manually here.
    @param winStride Window stride. It must be a multiple of block stride.
    @param padding Padding
    @param searchLocations Vector of Point includes set of requested locations to be evaluated.
    */
    public native void detect(@ByVal Mat img, @ByRef PointVector foundLocations,
                            @StdVector DoublePointer weights,
                            double hitThreshold/*=0*/, @ByVal(nullValue = "cv::Size()") Size winStride,
                            @ByVal(nullValue = "cv::Size()") Size padding,
                            @Const @ByRef(nullValue = "std::vector<cv::Point>()") PointVector searchLocations);
    public native void detect(@ByVal Mat img, @ByRef PointVector foundLocations,
                            @StdVector DoublePointer weights);
    public native void detect(@ByVal Mat img, @ByRef PointVector foundLocations,
                            @StdVector DoubleBuffer weights,
                            double hitThreshold/*=0*/, @ByVal(nullValue = "cv::Size()") Size winStride,
                            @ByVal(nullValue = "cv::Size()") Size padding,
                            @Const @ByRef(nullValue = "std::vector<cv::Point>()") PointVector searchLocations);
    public native void detect(@ByVal Mat img, @ByRef PointVector foundLocations,
                            @StdVector DoubleBuffer weights);
    public native void detect(@ByVal Mat img, @ByRef PointVector foundLocations,
                            @StdVector double[] weights,
                            double hitThreshold/*=0*/, @ByVal(nullValue = "cv::Size()") Size winStride,
                            @ByVal(nullValue = "cv::Size()") Size padding,
                            @Const @ByRef(nullValue = "std::vector<cv::Point>()") PointVector searchLocations);
    public native void detect(@ByVal Mat img, @ByRef PointVector foundLocations,
                            @StdVector double[] weights);
    public native void detect(@ByVal UMat img, @ByRef PointVector foundLocations,
                            @StdVector DoublePointer weights,
                            double hitThreshold/*=0*/, @ByVal(nullValue = "cv::Size()") Size winStride,
                            @ByVal(nullValue = "cv::Size()") Size padding,
                            @Const @ByRef(nullValue = "std::vector<cv::Point>()") PointVector searchLocations);
    public native void detect(@ByVal UMat img, @ByRef PointVector foundLocations,
                            @StdVector DoublePointer weights);
    public native void detect(@ByVal UMat img, @ByRef PointVector foundLocations,
                            @StdVector DoubleBuffer weights,
                            double hitThreshold/*=0*/, @ByVal(nullValue = "cv::Size()") Size winStride,
                            @ByVal(nullValue = "cv::Size()") Size padding,
                            @Const @ByRef(nullValue = "std::vector<cv::Point>()") PointVector searchLocations);
    public native void detect(@ByVal UMat img, @ByRef PointVector foundLocations,
                            @StdVector DoubleBuffer weights);
    public native void detect(@ByVal UMat img, @ByRef PointVector foundLocations,
                            @StdVector double[] weights,
                            double hitThreshold/*=0*/, @ByVal(nullValue = "cv::Size()") Size winStride,
                            @ByVal(nullValue = "cv::Size()") Size padding,
                            @Const @ByRef(nullValue = "std::vector<cv::Point>()") PointVector searchLocations);
    public native void detect(@ByVal UMat img, @ByRef PointVector foundLocations,
                            @StdVector double[] weights);
    public native void detect(@ByVal GpuMat img, @ByRef PointVector foundLocations,
                            @StdVector DoublePointer weights,
                            double hitThreshold/*=0*/, @ByVal(nullValue = "cv::Size()") Size winStride,
                            @ByVal(nullValue = "cv::Size()") Size padding,
                            @Const @ByRef(nullValue = "std::vector<cv::Point>()") PointVector searchLocations);
    public native void detect(@ByVal GpuMat img, @ByRef PointVector foundLocations,
                            @StdVector DoublePointer weights);
    public native void detect(@ByVal GpuMat img, @ByRef PointVector foundLocations,
                            @StdVector DoubleBuffer weights,
                            double hitThreshold/*=0*/, @ByVal(nullValue = "cv::Size()") Size winStride,
                            @ByVal(nullValue = "cv::Size()") Size padding,
                            @Const @ByRef(nullValue = "std::vector<cv::Point>()") PointVector searchLocations);
    public native void detect(@ByVal GpuMat img, @ByRef PointVector foundLocations,
                            @StdVector DoubleBuffer weights);
    public native void detect(@ByVal GpuMat img, @ByRef PointVector foundLocations,
                            @StdVector double[] weights,
                            double hitThreshold/*=0*/, @ByVal(nullValue = "cv::Size()") Size winStride,
                            @ByVal(nullValue = "cv::Size()") Size padding,
                            @Const @ByRef(nullValue = "std::vector<cv::Point>()") PointVector searchLocations);
    public native void detect(@ByVal GpuMat img, @ByRef PointVector foundLocations,
                            @StdVector double[] weights);

    /** \brief Performs object detection without a multi-scale window.
    @param img Matrix of the type CV_8U or CV_8UC3 containing an image where objects are detected.
    @param foundLocations Vector of point where each point contains left-top corner point of detected object boundaries.
    @param hitThreshold Threshold for the distance between features and SVM classifying plane.
    Usually it is 0 and should be specified in the detector coefficients (as the last free coefficient).
    But if the free coefficient is omitted (which is allowed), you can specify it manually here.
    @param winStride Window stride. It must be a multiple of block stride.
    @param padding Padding
    @param searchLocations Vector of Point includes locations to search.
    */
    public native void detect(@ByVal Mat img, @ByRef PointVector foundLocations,
                            double hitThreshold/*=0*/, @ByVal(nullValue = "cv::Size()") Size winStride,
                            @ByVal(nullValue = "cv::Size()") Size padding,
                            @Const @ByRef(nullValue = "std::vector<cv::Point>()") PointVector searchLocations);
    public native void detect(@ByVal Mat img, @ByRef PointVector foundLocations);
    public native void detect(@ByVal UMat img, @ByRef PointVector foundLocations,
                            double hitThreshold/*=0*/, @ByVal(nullValue = "cv::Size()") Size winStride,
                            @ByVal(nullValue = "cv::Size()") Size padding,
                            @Const @ByRef(nullValue = "std::vector<cv::Point>()") PointVector searchLocations);
    public native void detect(@ByVal UMat img, @ByRef PointVector foundLocations);
    public native void detect(@ByVal GpuMat img, @ByRef PointVector foundLocations,
                            double hitThreshold/*=0*/, @ByVal(nullValue = "cv::Size()") Size winStride,
                            @ByVal(nullValue = "cv::Size()") Size padding,
                            @Const @ByRef(nullValue = "std::vector<cv::Point>()") PointVector searchLocations);
    public native void detect(@ByVal GpuMat img, @ByRef PointVector foundLocations);

    /** \brief Detects objects of different sizes in the input image. The detected objects are returned as a list
    of rectangles.
    @param img Matrix of the type CV_8U or CV_8UC3 containing an image where objects are detected.
    @param foundLocations Vector of rectangles where each rectangle contains the detected object.
    @param foundWeights Vector that will contain confidence values for each detected object.
    @param hitThreshold Threshold for the distance between features and SVM classifying plane.
    Usually it is 0 and should be specified in the detector coefficients (as the last free coefficient).
    But if the free coefficient is omitted (which is allowed), you can specify it manually here.
    @param winStride Window stride. It must be a multiple of block stride.
    @param padding Padding
    @param scale Coefficient of the detection window increase.
    @param finalThreshold Final threshold
    @param useMeanshiftGrouping indicates grouping algorithm
    */
    public native void detectMultiScale(@ByVal Mat img, @ByRef RectVector foundLocations,
                                      @StdVector DoublePointer foundWeights, double hitThreshold/*=0*/,
                                      @ByVal(nullValue = "cv::Size()") Size winStride, @ByVal(nullValue = "cv::Size()") Size padding, double scale/*=1.05*/,
                                      double finalThreshold/*=2.0*/,@Cast("bool") boolean useMeanshiftGrouping/*=false*/);
    public native void detectMultiScale(@ByVal Mat img, @ByRef RectVector foundLocations,
                                      @StdVector DoublePointer foundWeights);
    public native void detectMultiScale(@ByVal Mat img, @ByRef RectVector foundLocations,
                                      @StdVector DoubleBuffer foundWeights, double hitThreshold/*=0*/,
                                      @ByVal(nullValue = "cv::Size()") Size winStride, @ByVal(nullValue = "cv::Size()") Size padding, double scale/*=1.05*/,
                                      double finalThreshold/*=2.0*/,@Cast("bool") boolean useMeanshiftGrouping/*=false*/);
    public native void detectMultiScale(@ByVal Mat img, @ByRef RectVector foundLocations,
                                      @StdVector DoubleBuffer foundWeights);
    public native void detectMultiScale(@ByVal Mat img, @ByRef RectVector foundLocations,
                                      @StdVector double[] foundWeights, double hitThreshold/*=0*/,
                                      @ByVal(nullValue = "cv::Size()") Size winStride, @ByVal(nullValue = "cv::Size()") Size padding, double scale/*=1.05*/,
                                      double finalThreshold/*=2.0*/,@Cast("bool") boolean useMeanshiftGrouping/*=false*/);
    public native void detectMultiScale(@ByVal Mat img, @ByRef RectVector foundLocations,
                                      @StdVector double[] foundWeights);
    public native void detectMultiScale(@ByVal UMat img, @ByRef RectVector foundLocations,
                                      @StdVector DoublePointer foundWeights, double hitThreshold/*=0*/,
                                      @ByVal(nullValue = "cv::Size()") Size winStride, @ByVal(nullValue = "cv::Size()") Size padding, double scale/*=1.05*/,
                                      double finalThreshold/*=2.0*/,@Cast("bool") boolean useMeanshiftGrouping/*=false*/);
    public native void detectMultiScale(@ByVal UMat img, @ByRef RectVector foundLocations,
                                      @StdVector DoublePointer foundWeights);
    public native void detectMultiScale(@ByVal UMat img, @ByRef RectVector foundLocations,
                                      @StdVector DoubleBuffer foundWeights, double hitThreshold/*=0*/,
                                      @ByVal(nullValue = "cv::Size()") Size winStride, @ByVal(nullValue = "cv::Size()") Size padding, double scale/*=1.05*/,
                                      double finalThreshold/*=2.0*/,@Cast("bool") boolean useMeanshiftGrouping/*=false*/);
    public native void detectMultiScale(@ByVal UMat img, @ByRef RectVector foundLocations,
                                      @StdVector DoubleBuffer foundWeights);
    public native void detectMultiScale(@ByVal UMat img, @ByRef RectVector foundLocations,
                                      @StdVector double[] foundWeights, double hitThreshold/*=0*/,
                                      @ByVal(nullValue = "cv::Size()") Size winStride, @ByVal(nullValue = "cv::Size()") Size padding, double scale/*=1.05*/,
                                      double finalThreshold/*=2.0*/,@Cast("bool") boolean useMeanshiftGrouping/*=false*/);
    public native void detectMultiScale(@ByVal UMat img, @ByRef RectVector foundLocations,
                                      @StdVector double[] foundWeights);
    public native void detectMultiScale(@ByVal GpuMat img, @ByRef RectVector foundLocations,
                                      @StdVector DoublePointer foundWeights, double hitThreshold/*=0*/,
                                      @ByVal(nullValue = "cv::Size()") Size winStride, @ByVal(nullValue = "cv::Size()") Size padding, double scale/*=1.05*/,
                                      double finalThreshold/*=2.0*/,@Cast("bool") boolean useMeanshiftGrouping/*=false*/);
    public native void detectMultiScale(@ByVal GpuMat img, @ByRef RectVector foundLocations,
                                      @StdVector DoublePointer foundWeights);
    public native void detectMultiScale(@ByVal GpuMat img, @ByRef RectVector foundLocations,
                                      @StdVector DoubleBuffer foundWeights, double hitThreshold/*=0*/,
                                      @ByVal(nullValue = "cv::Size()") Size winStride, @ByVal(nullValue = "cv::Size()") Size padding, double scale/*=1.05*/,
                                      double finalThreshold/*=2.0*/,@Cast("bool") boolean useMeanshiftGrouping/*=false*/);
    public native void detectMultiScale(@ByVal GpuMat img, @ByRef RectVector foundLocations,
                                      @StdVector DoubleBuffer foundWeights);
    public native void detectMultiScale(@ByVal GpuMat img, @ByRef RectVector foundLocations,
                                      @StdVector double[] foundWeights, double hitThreshold/*=0*/,
                                      @ByVal(nullValue = "cv::Size()") Size winStride, @ByVal(nullValue = "cv::Size()") Size padding, double scale/*=1.05*/,
                                      double finalThreshold/*=2.0*/,@Cast("bool") boolean useMeanshiftGrouping/*=false*/);
    public native void detectMultiScale(@ByVal GpuMat img, @ByRef RectVector foundLocations,
                                      @StdVector double[] foundWeights);

    /** \brief Detects objects of different sizes in the input image. The detected objects are returned as a list
    of rectangles.
    @param img Matrix of the type CV_8U or CV_8UC3 containing an image where objects are detected.
    @param foundLocations Vector of rectangles where each rectangle contains the detected object.
    @param hitThreshold Threshold for the distance between features and SVM classifying plane.
    Usually it is 0 and should be specified in the detector coefficients (as the last free coefficient).
    But if the free coefficient is omitted (which is allowed), you can specify it manually here.
    @param winStride Window stride. It must be a multiple of block stride.
    @param padding Padding
    @param scale Coefficient of the detection window increase.
    @param finalThreshold Final threshold
    @param useMeanshiftGrouping indicates grouping algorithm
    */
    public native void detectMultiScale(@ByVal Mat img, @ByRef RectVector foundLocations,
                                      double hitThreshold/*=0*/, @ByVal(nullValue = "cv::Size()") Size winStride,
                                      @ByVal(nullValue = "cv::Size()") Size padding, double scale/*=1.05*/,
                                      double finalThreshold/*=2.0*/, @Cast("bool") boolean useMeanshiftGrouping/*=false*/);
    public native void detectMultiScale(@ByVal Mat img, @ByRef RectVector foundLocations);
    public native void detectMultiScale(@ByVal UMat img, @ByRef RectVector foundLocations,
                                      double hitThreshold/*=0*/, @ByVal(nullValue = "cv::Size()") Size winStride,
                                      @ByVal(nullValue = "cv::Size()") Size padding, double scale/*=1.05*/,
                                      double finalThreshold/*=2.0*/, @Cast("bool") boolean useMeanshiftGrouping/*=false*/);
    public native void detectMultiScale(@ByVal UMat img, @ByRef RectVector foundLocations);
    public native void detectMultiScale(@ByVal GpuMat img, @ByRef RectVector foundLocations,
                                      double hitThreshold/*=0*/, @ByVal(nullValue = "cv::Size()") Size winStride,
                                      @ByVal(nullValue = "cv::Size()") Size padding, double scale/*=1.05*/,
                                      double finalThreshold/*=2.0*/, @Cast("bool") boolean useMeanshiftGrouping/*=false*/);
    public native void detectMultiScale(@ByVal GpuMat img, @ByRef RectVector foundLocations);

    /** \brief  Computes gradients and quantized gradient orientations.
    @param img Matrix contains the image to be computed
    @param grad Matrix of type CV_32FC2 contains computed gradients
    @param angleOfs Matrix of type CV_8UC2 contains quantized gradient orientations
    @param paddingTL Padding from top-left
    @param paddingBR Padding from bottom-right
    */
    public native void computeGradient(@ByVal Mat img, @ByVal Mat grad, @ByVal Mat angleOfs,
                                     @ByVal(nullValue = "cv::Size()") Size paddingTL, @ByVal(nullValue = "cv::Size()") Size paddingBR);
    public native void computeGradient(@ByVal Mat img, @ByVal Mat grad, @ByVal Mat angleOfs);
    public native void computeGradient(@ByVal UMat img, @ByVal UMat grad, @ByVal UMat angleOfs,
                                     @ByVal(nullValue = "cv::Size()") Size paddingTL, @ByVal(nullValue = "cv::Size()") Size paddingBR);
    public native void computeGradient(@ByVal UMat img, @ByVal UMat grad, @ByVal UMat angleOfs);
    public native void computeGradient(@ByVal GpuMat img, @ByVal GpuMat grad, @ByVal GpuMat angleOfs,
                                     @ByVal(nullValue = "cv::Size()") Size paddingTL, @ByVal(nullValue = "cv::Size()") Size paddingBR);
    public native void computeGradient(@ByVal GpuMat img, @ByVal GpuMat grad, @ByVal GpuMat angleOfs);

    /** \brief Returns coefficients of the classifier trained for people detection (for 64x128 windows).
    */
    public static native @StdVector FloatPointer getDefaultPeopleDetector();

    /**\example samples/tapi/hog.cpp
    */
    /** \brief Returns coefficients of the classifier trained for people detection (for 48x96 windows).
    */
    public static native @StdVector FloatPointer getDaimlerPeopleDetector();

    /** Detection window size. Align to block size and block stride. Default value is Size(64,128). */
    public native @ByRef Size winSize(); public native HOGDescriptor winSize(Size setter);

    /** Block size in pixels. Align to cell size. Default value is Size(16,16). */
    public native @ByRef Size blockSize(); public native HOGDescriptor blockSize(Size setter);

    /** Block stride. It must be a multiple of cell size. Default value is Size(8,8). */
    public native @ByRef Size blockStride(); public native HOGDescriptor blockStride(Size setter);

    /** Cell size. Default value is Size(8,8). */
    public native @ByRef Size cellSize(); public native HOGDescriptor cellSize(Size setter);

    /** Number of bins used in the calculation of histogram of gradients. Default value is 9. */
    public native int nbins(); public native HOGDescriptor nbins(int setter);

    /** not documented */
    public native int derivAperture(); public native HOGDescriptor derivAperture(int setter);

    /** Gaussian smoothing window parameter. */
    public native double winSigma(); public native HOGDescriptor winSigma(double setter);

    /** histogramNormType */
    public native @Cast("cv::HOGDescriptor::HistogramNormType") int histogramNormType(); public native HOGDescriptor histogramNormType(int setter);

    /** L2-Hys normalization method shrinkage. */
    public native double L2HysThreshold(); public native HOGDescriptor L2HysThreshold(double setter);

    /** Flag to specify whether the gamma correction preprocessing is required or not. */
    public native @Cast("bool") boolean gammaCorrection(); public native HOGDescriptor gammaCorrection(boolean setter);

    /** coefficients for the linear SVM classifier. */
    public native @StdVector FloatPointer svmDetector(); public native HOGDescriptor svmDetector(FloatPointer setter);

    /** coefficients for the linear SVM classifier used when OpenCL is enabled */
    public native @ByRef UMat oclSvmDetector(); public native HOGDescriptor oclSvmDetector(UMat setter);

    /** not documented */
    public native float free_coef(); public native HOGDescriptor free_coef(float setter);

    /** Maximum number of detection window increases. Default value is 64 */
    public native int nlevels(); public native HOGDescriptor nlevels(int setter);

    /** Indicates signed gradient will be used or not */
    public native @Cast("bool") boolean signedGradient(); public native HOGDescriptor signedGradient(boolean setter);

    /** \brief evaluate specified ROI and return confidence value for each location
    @param img Matrix of the type CV_8U or CV_8UC3 containing an image where objects are detected.
    @param locations Vector of Point
    @param foundLocations Vector of Point where each Point is detected object's top-left point.
    @param confidences confidences
    @param hitThreshold Threshold for the distance between features and SVM classifying plane. Usually
    it is 0 and should be specified in the detector coefficients (as the last free coefficient). But if
    the free coefficient is omitted (which is allowed), you can specify it manually here
    @param winStride winStride
    @param padding padding
    */
    public native void detectROI(@ByVal Mat img, @Const @ByRef PointVector locations,
                                       @ByRef PointVector foundLocations, @StdVector DoublePointer confidences,
                                       double hitThreshold/*=0*/, @ByVal(nullValue = "cv::Size()") Size winStride,
                                       @ByVal(nullValue = "cv::Size()") Size padding);
    public native void detectROI(@ByVal Mat img, @Const @ByRef PointVector locations,
                                       @ByRef PointVector foundLocations, @StdVector DoublePointer confidences);
    public native void detectROI(@ByVal Mat img, @Const @ByRef PointVector locations,
                                       @ByRef PointVector foundLocations, @StdVector DoubleBuffer confidences,
                                       double hitThreshold/*=0*/, @ByVal(nullValue = "cv::Size()") Size winStride,
                                       @ByVal(nullValue = "cv::Size()") Size padding);
    public native void detectROI(@ByVal Mat img, @Const @ByRef PointVector locations,
                                       @ByRef PointVector foundLocations, @StdVector DoubleBuffer confidences);
    public native void detectROI(@ByVal Mat img, @Const @ByRef PointVector locations,
                                       @ByRef PointVector foundLocations, @StdVector double[] confidences,
                                       double hitThreshold/*=0*/, @ByVal(nullValue = "cv::Size()") Size winStride,
                                       @ByVal(nullValue = "cv::Size()") Size padding);
    public native void detectROI(@ByVal Mat img, @Const @ByRef PointVector locations,
                                       @ByRef PointVector foundLocations, @StdVector double[] confidences);
    public native void detectROI(@ByVal UMat img, @Const @ByRef PointVector locations,
                                       @ByRef PointVector foundLocations, @StdVector DoublePointer confidences,
                                       double hitThreshold/*=0*/, @ByVal(nullValue = "cv::Size()") Size winStride,
                                       @ByVal(nullValue = "cv::Size()") Size padding);
    public native void detectROI(@ByVal UMat img, @Const @ByRef PointVector locations,
                                       @ByRef PointVector foundLocations, @StdVector DoublePointer confidences);
    public native void detectROI(@ByVal UMat img, @Const @ByRef PointVector locations,
                                       @ByRef PointVector foundLocations, @StdVector DoubleBuffer confidences,
                                       double hitThreshold/*=0*/, @ByVal(nullValue = "cv::Size()") Size winStride,
                                       @ByVal(nullValue = "cv::Size()") Size padding);
    public native void detectROI(@ByVal UMat img, @Const @ByRef PointVector locations,
                                       @ByRef PointVector foundLocations, @StdVector DoubleBuffer confidences);
    public native void detectROI(@ByVal UMat img, @Const @ByRef PointVector locations,
                                       @ByRef PointVector foundLocations, @StdVector double[] confidences,
                                       double hitThreshold/*=0*/, @ByVal(nullValue = "cv::Size()") Size winStride,
                                       @ByVal(nullValue = "cv::Size()") Size padding);
    public native void detectROI(@ByVal UMat img, @Const @ByRef PointVector locations,
                                       @ByRef PointVector foundLocations, @StdVector double[] confidences);
    public native void detectROI(@ByVal GpuMat img, @Const @ByRef PointVector locations,
                                       @ByRef PointVector foundLocations, @StdVector DoublePointer confidences,
                                       double hitThreshold/*=0*/, @ByVal(nullValue = "cv::Size()") Size winStride,
                                       @ByVal(nullValue = "cv::Size()") Size padding);
    public native void detectROI(@ByVal GpuMat img, @Const @ByRef PointVector locations,
                                       @ByRef PointVector foundLocations, @StdVector DoublePointer confidences);
    public native void detectROI(@ByVal GpuMat img, @Const @ByRef PointVector locations,
                                       @ByRef PointVector foundLocations, @StdVector DoubleBuffer confidences,
                                       double hitThreshold/*=0*/, @ByVal(nullValue = "cv::Size()") Size winStride,
                                       @ByVal(nullValue = "cv::Size()") Size padding);
    public native void detectROI(@ByVal GpuMat img, @Const @ByRef PointVector locations,
                                       @ByRef PointVector foundLocations, @StdVector DoubleBuffer confidences);
    public native void detectROI(@ByVal GpuMat img, @Const @ByRef PointVector locations,
                                       @ByRef PointVector foundLocations, @StdVector double[] confidences,
                                       double hitThreshold/*=0*/, @ByVal(nullValue = "cv::Size()") Size winStride,
                                       @ByVal(nullValue = "cv::Size()") Size padding);
    public native void detectROI(@ByVal GpuMat img, @Const @ByRef PointVector locations,
                                       @ByRef PointVector foundLocations, @StdVector double[] confidences);

    /** \brief evaluate specified ROI and return confidence value for each location in multiple scales
    @param img Matrix of the type CV_8U or CV_8UC3 containing an image where objects are detected.
    @param foundLocations Vector of rectangles where each rectangle contains the detected object.
    @param locations Vector of DetectionROI
    @param hitThreshold Threshold for the distance between features and SVM classifying plane. Usually it is 0 and should be specified
    in the detector coefficients (as the last free coefficient). But if the free coefficient is omitted (which is allowed), you can specify it manually here.
    @param groupThreshold Minimum possible number of rectangles minus 1. The threshold is used in a group of rectangles to retain it.
    */
    public native void detectMultiScaleROI(@ByVal Mat img,
                                         @ByRef RectVector foundLocations,
                                         @StdVector DetectionROI locations,
                                         double hitThreshold/*=0*/,
                                         int groupThreshold/*=0*/);
    public native void detectMultiScaleROI(@ByVal Mat img,
                                         @ByRef RectVector foundLocations,
                                         @StdVector DetectionROI locations);
    public native void detectMultiScaleROI(@ByVal UMat img,
                                         @ByRef RectVector foundLocations,
                                         @StdVector DetectionROI locations,
                                         double hitThreshold/*=0*/,
                                         int groupThreshold/*=0*/);
    public native void detectMultiScaleROI(@ByVal UMat img,
                                         @ByRef RectVector foundLocations,
                                         @StdVector DetectionROI locations);
    public native void detectMultiScaleROI(@ByVal GpuMat img,
                                         @ByRef RectVector foundLocations,
                                         @StdVector DetectionROI locations,
                                         double hitThreshold/*=0*/,
                                         int groupThreshold/*=0*/);
    public native void detectMultiScaleROI(@ByVal GpuMat img,
                                         @ByRef RectVector foundLocations,
                                         @StdVector DetectionROI locations);

    /** \brief Groups the object candidate rectangles.
    @param rectList  Input/output vector of rectangles. Output vector includes retained and grouped rectangles. (The Python list is not modified in place.)
    @param weights Input/output vector of weights of rectangles. Output vector includes weights of retained and grouped rectangles. (The Python list is not modified in place.)
    @param groupThreshold Minimum possible number of rectangles minus 1. The threshold is used in a group of rectangles to retain it.
    @param eps Relative difference between sides of the rectangles to merge them into a group.
    */
    public native void groupRectangles(@ByRef RectVector rectList, @StdVector DoublePointer weights, int groupThreshold, double eps);
    public native void groupRectangles(@ByRef RectVector rectList, @StdVector DoubleBuffer weights, int groupThreshold, double eps);
    public native void groupRectangles(@ByRef RectVector rectList, @StdVector double[] weights, int groupThreshold, double eps);
}
