// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_cudacodec;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;

import static org.bytedeco.opencv.global.opencv_cudacodec.*;


/** \brief Struct providing information about video file format. :
 */
@Namespace("cv::cudacodec") @Properties(inherit = org.bytedeco.opencv.presets.opencv_cudacodec.class)
public class FormatInfo extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public FormatInfo() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public FormatInfo(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FormatInfo(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public FormatInfo position(long position) {
        return (FormatInfo)super.position(position);
    }
    @Override public FormatInfo getPointer(long i) {
        return new FormatInfo((Pointer)this).offsetAddress(i);
    }

    public native @Cast("cv::cudacodec::Codec") int codec(); public native FormatInfo codec(int setter);
    public native @Cast("cv::cudacodec::ChromaFormat") int chromaFormat(); public native FormatInfo chromaFormat(int setter);
    public native int nBitDepthMinus8(); public native FormatInfo nBitDepthMinus8(int setter);
    /** Coded sequence width in pixels. */
    public native int ulWidth(); public native FormatInfo ulWidth(int setter);
    /** Coded sequence height in pixels. */
    public native int ulHeight(); public native FormatInfo ulHeight(int setter);
    /** Width of the decoded frame returned by nextFrame(frame). */
    public native int width(); public native FormatInfo width(int setter);
    /** Height of the decoded frame returned by nextFrame(frame). */
    public native int height(); public native FormatInfo height(int setter);
    public native int ulMaxWidth(); public native FormatInfo ulMaxWidth(int setter);
    public native int ulMaxHeight(); public native FormatInfo ulMaxHeight(int setter);
    /** ROI inside the decoded frame returned by nextFrame(frame), containing the useable video frame. */
    public native @ByRef Rect displayArea(); public native FormatInfo displayArea(Rect setter);
    public native @Cast("bool") boolean valid(); public native FormatInfo valid(boolean setter);
    public native double fps(); public native FormatInfo fps(double setter);
    /** Maximum number of internal decode surfaces. */
    public native int ulNumDecodeSurfaces(); public native FormatInfo ulNumDecodeSurfaces(int setter);
    public native @Cast("cv::cudacodec::DeinterlaceMode") int deinterlaceMode(); public native FormatInfo deinterlaceMode(int setter);
}
