/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.async;

import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.bsc.async.AsyncGenerator;

class InternalIterator<E>
implements Iterator<E>,
AsyncGenerator.HasResultValue {
    private final AsyncGenerator<E> delegate;
    final AtomicReference<AsyncGenerator.Data<E>> currentFetchedData;

    public InternalIterator(AsyncGenerator<E> delegate) {
        this.delegate = delegate;
        this.currentFetchedData = new AtomicReference<AsyncGenerator.Data<E>>(delegate.next());
    }

    @Override
    public boolean hasNext() {
        AsyncGenerator.Data<E> value = this.currentFetchedData.get();
        return value != null && !value.isDone();
    }

    @Override
    public E next() {
        AsyncGenerator.Data<E> next = this.currentFetchedData.get();
        if (next == null || next.isDone()) {
            throw new IllegalStateException("no more elements into iterator");
        }
        if (!next.isError()) {
            this.currentFetchedData.set(this.delegate.next());
        }
        return next.data.join();
    }

    @Override
    public Optional<Object> resultValue() {
        AsyncGenerator<E> asyncGenerator = this.delegate;
        if (asyncGenerator instanceof AsyncGenerator.HasResultValue) {
            AsyncGenerator.HasResultValue withResult = (AsyncGenerator.HasResultValue)((Object)asyncGenerator);
            return withResult.resultValue();
        }
        return Optional.empty();
    }
}

