/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.PacketCipherException;
import org.bouncycastle.crypto.engines.AESNativeGCMSIVPacketCipher;
import org.bouncycastle.crypto.engines.AESPacketCipher;
import org.bouncycastle.crypto.modes.AESGCMSIVModePacketCipher;
import org.bouncycastle.crypto.modes.PacketCipherChecks;
import org.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class AESGCMSIVPacketCipher
implements AESGCMSIVModePacketCipher {
    private static final int HALFBUFLEN = 8;
    private static final int MAX_DATALEN = 0x7FFFFFE7;
    private static final byte MASK = -128;
    private static final byte ADD = -31;

    public static AESGCMSIVModePacketCipher newInstance() {
        if (CryptoServicesRegistrar.hasEnabledService("AES/GCMSIV-PC")) {
            return new AESNativeGCMSIVPacketCipher();
        }
        return new AESGCMSIVPacketCipher();
    }

    @Override
    public int getOutputSize(boolean bl, CipherParameters cipherParameters, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("input len is negative");
        }
        if (bl) {
            return PacketCipherChecks.addCheckInputOverflow(n, 16);
        }
        if (n < 16) {
            throw new DataLengthException("len parameter invalid");
        }
        this.checkParameters(cipherParameters);
        return n - 16;
    }

    @Override
    public int processPacket(boolean bl, CipherParameters cipherParameters, byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws PacketCipherException {
        byte[] byArray3;
        byte[] byArray4;
        Object object;
        PacketCipherChecks.checkBoundsInput(byArray, n, n2, byArray2, n3);
        PacketCipherChecks.checkInputAndOutputAEAD(bl, byArray, n, n2, byArray2, n3, 16);
        byte[] byArray5 = new byte[16];
        byte[] byArray6 = new byte[16];
        GCMSIVHasher gCMSIVHasher = new GCMSIVHasher();
        GCMSIVHasher gCMSIVHasher2 = new GCMSIVHasher();
        byte[] byArray7 = null;
        long[][] lArray = new long[256][2];
        byte[] byArray8 = new byte[16];
        if (cipherParameters instanceof AEADParameters) {
            object = (AEADParameters)cipherParameters;
            byArray7 = ((AEADParameters)object).getAssociatedText();
            byArray4 = ((AEADParameters)object).getNonce();
            PacketCipherChecks.checkKeyLengthExclude192(((AEADParameters)object).getKey().getKeyLength());
            byArray3 = Arrays.clone(((AEADParameters)object).getKey().getKey());
        } else if (cipherParameters instanceof ParametersWithIV) {
            object = (ParametersWithIV)cipherParameters;
            byArray4 = Arrays.clone(((ParametersWithIV)object).getIV());
            PacketCipherChecks.checkKeyLengthExclude192(((KeyParameter)((ParametersWithIV)object).getParameters()).getKeyLength());
            byArray3 = Arrays.clone(((KeyParameter)((ParametersWithIV)object).getParameters()).getKey());
        } else {
            throw PacketCipherException.from(new IllegalArgumentException("invalid parameters passed to GCM-SIV"));
        }
        if (byArray4 == null || byArray4.length != 12) {
            throw PacketCipherException.from(new IllegalArgumentException("invalid nonce"));
        }
        byte[] byArray9 = AESPacketCipher.createS(true);
        int[][] nArray = AESPacketCipher.generateWorkingKey(true, byArray3);
        object = new byte[byArray3.length];
        int n4 = bl ? n2 + 16 : n2 - 16;
        try {
            System.arraycopy(byArray4, 0, byArray5, 4, 12);
            AESGCMSIVPacketCipher.deriveKey(nArray, byArray9, byArray5, byArray6, byArray8, 0);
            byArray5[0] = (byte)(byArray5[0] + 1);
            int n5 = AESGCMSIVPacketCipher.deriveKey(nArray, byArray9, byArray5, byArray6, (byte[])object, 0);
            if (((Object)object).length == 32) {
                byArray5[0] = (byte)(byArray5[0] + 1);
                AESGCMSIVPacketCipher.deriveKey(nArray, byArray9, byArray5, byArray6, (byte[])object, n5 += 8);
            }
            int n6 = ((Object)object).length;
            PacketCipherChecks.checkKeyLength(n6);
            Arrays.clear(nArray);
            Arrays.clear(byArray9);
            byArray9 = AESPacketCipher.createS(true);
            nArray = AESPacketCipher.generateWorkingKey(true, (byte[])object);
            AESGCMSIVPacketCipher.fillReverse(byArray8, 0, 16, byArray6);
            AESGCMSIVPacketCipher.mulX(byArray6);
            AESGCMSIVPacketCipher.initMultiplier(lArray, byArray6);
            Arrays.fill(byArray5, (byte)0);
            if (byArray7 != null) {
                gCMSIVHasher.updateHash(byArray7, 0, byArray7.length, byArray6, byArray5, lArray);
            }
            gCMSIVHasher.completeHash(byArray6, byArray5, lArray);
            long l = 0x7FFFFFE7L;
            if (!bl) {
                l += 16L;
            }
            if ((long)n2 + Long.MIN_VALUE > l - (long)n2 + Long.MIN_VALUE) {
                throw PacketCipherException.from(new IllegalStateException("byte count exceeded"));
            }
            if (bl) {
                gCMSIVHasher2.updateHash(byArray, n, n2, byArray6, byArray5, lArray);
                byte[] byArray10 = AESGCMSIVPacketCipher.calculateTag(gCMSIVHasher2, gCMSIVHasher, byArray6, byArray5, lArray, byArray4, nArray, byArray9);
                AESGCMSIVPacketCipher.encryptPlain(byArray, n, n2, byArray10, byArray2, n3, nArray, byArray9);
                System.arraycopy(byArray10, 0, byArray2, n3 + n2, 16);
            } else {
                AESGCMSIVPacketCipher.decryptPlain(gCMSIVHasher2, gCMSIVHasher, byArray, n, n2, byArray2, n3, byArray4, byArray6, byArray5, lArray, nArray, byArray9);
            }
        }
        catch (Throwable throwable) {
            Arrays.clear(byArray2, n3, Math.min(byArray2.length - n3, n4));
            throw PacketCipherException.from(throwable);
        }
        finally {
            Arrays.clear(nArray);
            Arrays.clear(byArray5);
            Arrays.clear(byArray6);
            Arrays.clear(byArray4);
            Arrays.clear(byArray3);
            Arrays.clear(byArray9);
        }
        return n4;
    }

    private static int deriveKey(int[][] nArray, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n) {
        AESPacketCipher.processBlock(true, nArray, byArray, byArray2, 0, byArray3, 0);
        System.arraycopy(byArray3, 0, byArray4, n, 8);
        byArray2[0] = (byte)(byArray2[0] + 1);
        AESPacketCipher.processBlock(true, nArray, byArray, byArray2, 0, byArray3, 0);
        System.arraycopy(byArray3, 0, byArray4, n += 8, 8);
        return n;
    }

    private static byte[] calculateTag(GCMSIVHasher gCMSIVHasher, GCMSIVHasher gCMSIVHasher2, byte[] byArray, byte[] byArray2, long[][] lArray, byte[] byArray3, int[][] nArray, byte[] byArray4) {
        gCMSIVHasher.completeHash(byArray, byArray2, lArray);
        byte[] byArray5 = AESGCMSIVPacketCipher.completePolyVal(gCMSIVHasher, gCMSIVHasher2, byArray2, lArray);
        byte[] byArray6 = new byte[16];
        for (int i = 0; i < 12; ++i) {
            int n = i;
            byArray5[n] = (byte)(byArray5[n] ^ byArray3[i]);
        }
        byArray5[15] = (byte)(byArray5[15] & 0xFFFFFF7F);
        AESPacketCipher.processBlock(true, nArray, byArray4, byArray5, 0, byArray6, 0);
        return byArray6;
    }

    private static byte[] completePolyVal(GCMSIVHasher gCMSIVHasher, GCMSIVHasher gCMSIVHasher2, byte[] byArray, long[][] lArray) {
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = new byte[16];
        Pack.longToBigEndian(8L * gCMSIVHasher.getBytesProcessed(), byArray3, 0);
        Pack.longToBigEndian(8L * gCMSIVHasher2.getBytesProcessed(), byArray3, 8);
        AESGCMSIVPacketCipher.gHASH(byArray3, byArray, lArray);
        AESGCMSIVPacketCipher.fillReverse(byArray, 0, 16, byArray2);
        return byArray2;
    }

    private static int encryptPlain(byte[] byArray, int n, int n2, byte[] byArray2, byte[] byArray3, int n3, int[][] nArray, byte[] byArray4) {
        byte[] byArray5 = Arrays.clone(byArray2);
        byArray5[15] = (byte)(byArray5[15] | 0xFFFFFF80);
        byte[] byArray6 = new byte[16];
        int n4 = n2;
        while (n4 > 0) {
            AESPacketCipher.processBlock(true, nArray, byArray4, byArray5, 0, byArray6, 0);
            int n5 = Math.min(16, n4);
            AESGCMSIVPacketCipher.xorBlock(byArray6, byArray, n, n5);
            System.arraycopy(byArray6, 0, byArray3, n3, n5);
            n4 -= n5;
            n += n5;
            n3 += n5;
            AESGCMSIVPacketCipher.incrementCounter(byArray5);
        }
        return n2;
    }

    private static void fillReverse(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = 0;
        int n4 = 15;
        while (n3 < n2) {
            byArray2[n4] = byArray[n + n3];
            ++n3;
            --n4;
        }
    }

    private static void gHASH(byte[] byArray, byte[] byArray2, long[][] lArray) {
        AESGCMSIVPacketCipher.xorBlock(byArray2, byArray);
        AESGCMSIVPacketCipher.mulH(byArray2, lArray);
    }

    protected static void mulH(byte[] byArray, long[][] lArray) {
        long[] lArray2 = lArray[byArray[15] & 0xFF];
        long l = lArray2[0];
        long l2 = lArray2[1];
        for (int i = 14; i >= 0; --i) {
            lArray2 = lArray[byArray[i] & 0xFF];
            long l3 = l2 << 56;
            l2 = lArray2[1] ^ (l2 >>> 8 | l << 56);
            l = lArray2[0] ^ l >>> 8 ^ l3 ^ l3 >>> 1 ^ l3 >>> 2 ^ l3 >>> 7;
        }
        Pack.longToBigEndian(l, byArray, 0);
        Pack.longToBigEndian(l2, byArray, 8);
    }

    private static void xorBlock(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < 16; ++i) {
            int n = i;
            byArray[n] = (byte)(byArray[n] ^ byArray2[i]);
        }
    }

    private static void xorBlock(byte[] byArray, byte[] byArray2, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3 = i;
            byArray[n3] = (byte)(byArray[n3] ^ byArray2[i + n]);
        }
    }

    private static void mulX(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < 16; ++i) {
            byte by = byArray[i];
            byArray[i] = (byte)(by >> 1 & 0x7F | n);
            n = (by & 1) == 0 ? 0 : -128;
        }
        if (n != 0) {
            byArray[0] = (byte)(byArray[0] ^ 0xFFFFFFE1);
        }
    }

    private static void decryptPlain(GCMSIVHasher gCMSIVHasher, GCMSIVHasher gCMSIVHasher2, byte[] byArray, int n, int n2, byte[] byArray2, int n3, byte[] byArray3, byte[] byArray4, byte[] byArray5, long[][] lArray, int[][] nArray, byte[] byArray6) throws PacketCipherException {
        int n4 = n2 - 16;
        byte[] byArray7 = Arrays.copyOfRange(byArray, n4 + n, n4 + n + 16);
        byte[] byArray8 = Arrays.clone(byArray7);
        byArray8[15] = (byte)(byArray8[15] | 0xFFFFFF80);
        byte[] byArray9 = new byte[16];
        int n5 = n;
        while (n4 > 0) {
            AESPacketCipher.processBlock(true, nArray, byArray6, byArray8, 0, byArray9, 0);
            int n6 = Math.min(16, n4);
            AESGCMSIVPacketCipher.xorBlock(byArray9, byArray, n5, n6);
            System.arraycopy(byArray9, 0, byArray2, n3, n6);
            gCMSIVHasher.updateHash(byArray9, 0, n6, byArray4, byArray5, lArray);
            n4 -= n6;
            n5 += n6;
            n3 += n6;
            AESGCMSIVPacketCipher.incrementCounter(byArray8);
        }
        byte[] byArray10 = AESGCMSIVPacketCipher.calculateTag(gCMSIVHasher, gCMSIVHasher2, byArray4, byArray5, lArray, byArray3, nArray, byArray6);
        if (!Arrays.constantTimeAreEqual(byArray10, byArray7)) {
            throw PacketCipherException.from(new InvalidCipherTextException("mac check failed"));
        }
    }

    protected static void initMultiplier(long[][] lArray, byte[] byArray) {
        GCMUtil.asLongs(byArray, lArray[1]);
        GCMUtil.multiplyP7(lArray[1], lArray[1]);
        for (int i = 2; i < 256; i += 2) {
            GCMUtil.divideP(lArray[i >> 1], lArray[i]);
            GCMUtil.xor(lArray[i], lArray[1], lArray[i + 1]);
        }
    }

    private static void incrementCounter(byte[] byArray) {
        int n = 0;
        while (n < 4) {
            int n2 = n++;
            byArray[n2] = (byte)(byArray[n2] + 1);
            if (byArray[n2] != 0) break;
        }
    }

    public String toString() {
        return "GCMSIV-PS[Java](AES[Java])";
    }

    private static class GCMSIVHasher {
        private final byte[] theBuffer = new byte[16];
        private int numActive;
        private long numHashed;

        private GCMSIVHasher() {
        }

        long getBytesProcessed() {
            return this.numHashed;
        }

        void updateHash(byte[] byArray, int n, int n2, byte[] byArray2, byte[] byArray3, long[][] lArray) {
            int n3 = 16 - this.numActive;
            int n4 = 0;
            int n5 = n2;
            if (this.numActive > 0 && n2 >= n3) {
                System.arraycopy(byArray, n, this.theBuffer, this.numActive, n3);
                AESGCMSIVPacketCipher.fillReverse(this.theBuffer, 0, 16, byArray2);
                AESGCMSIVPacketCipher.gHASH(byArray2, byArray3, lArray);
                n4 += n3;
                n5 -= n3;
                this.numActive = 0;
            }
            while (n5 >= 16) {
                AESGCMSIVPacketCipher.fillReverse(byArray, n + n4, 16, byArray2);
                AESGCMSIVPacketCipher.gHASH(byArray2, byArray3, lArray);
                n4 += 16;
                n5 -= 16;
            }
            if (n5 > 0) {
                System.arraycopy(byArray, n + n4, this.theBuffer, this.numActive, n5);
                this.numActive += n5;
            }
            this.numHashed += (long)n2;
        }

        void completeHash(byte[] byArray, byte[] byArray2, long[][] lArray) {
            if (this.numActive > 0) {
                Arrays.fill(byArray, (byte)0);
                AESGCMSIVPacketCipher.fillReverse(this.theBuffer, 0, this.numActive, byArray);
                AESGCMSIVPacketCipher.gHASH(byArray, byArray2, lArray);
            }
        }
    }
}

