/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.MultiBlockCipher;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CTRModeCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.dispose.NativeDisposer;
import org.bouncycastle.util.dispose.NativeReference;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AESNativeCTR
implements CTRModeCipher {
    private CTRRefWrapper referenceWrapper = null;
    private int keyLen;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockCipher getUnderlyingCipher() {
        AESNativeCTR aESNativeCTR = this;
        synchronized (aESNativeCTR) {
            byte[] byArray;
            MultiBlockCipher multiBlockCipher = AESEngine.newInstance();
            if (this.referenceWrapper != null && (byArray = this.referenceWrapper.getKey()) != null) {
                multiBlockCipher.init(true, new KeyParameter(this.referenceWrapper.getKey()));
            }
            return multiBlockCipher;
        }
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        AESNativeCTR aESNativeCTR = this;
        synchronized (aESNativeCTR) {
            if (this.referenceWrapper == null) {
                throw new IllegalStateException("not initialized");
            }
            return AESNativeCTR.processBytes(this.referenceWrapper.getReference(), byArray, n, this.getBlockSize(), byArray2, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMultiBlockSize() {
        AESNativeCTR aESNativeCTR = this;
        synchronized (aESNativeCTR) {
            return AESNativeCTR.getMultiBlockSize(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processBlocks(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        AESNativeCTR aESNativeCTR = this;
        synchronized (aESNativeCTR) {
            int n4 = this.getBlockSize() * n2;
            if (this.referenceWrapper == null) {
                throw new IllegalStateException("not initialized");
            }
            return AESNativeCTR.processBytes(this.referenceWrapper.getReference(), byArray, n, n4, byArray2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long l) {
        AESNativeCTR aESNativeCTR = this;
        synchronized (aESNativeCTR) {
            if (this.referenceWrapper == null) {
                throw new IllegalStateException("not initialized");
            }
            return AESNativeCTR.skip(this.referenceWrapper.getReference(), l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long seekTo(long l) {
        AESNativeCTR aESNativeCTR = this;
        synchronized (aESNativeCTR) {
            if (this.referenceWrapper == null) {
                throw new IllegalStateException("not initialized");
            }
            return AESNativeCTR.seekTo(this.referenceWrapper.getReference(), l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getPosition() {
        AESNativeCTR aESNativeCTR = this;
        synchronized (aESNativeCTR) {
            if (this.referenceWrapper == null) {
                throw new IllegalStateException("not initialized");
            }
            return AESNativeCTR.getPosition(this.referenceWrapper.getReference());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        AESNativeCTR aESNativeCTR = this;
        synchronized (aESNativeCTR) {
            if (cipherParameters instanceof ParametersWithIV) {
                int n;
                ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
                byte[] byArray = parametersWithIV.getIV();
                int n2 = this.getBlockSize();
                int n3 = n = 8 > n2 / 2 ? n2 / 2 : 8;
                if (n2 - byArray.length > n) {
                    throw new IllegalArgumentException("CTR mode requires IV of at least: " + (n2 - n) + " bytes.");
                }
                if (parametersWithIV.getParameters() == null) {
                    if (this.referenceWrapper == null) {
                        this.referenceWrapper = new CTRRefWrapper(AESNativeCTR.makeCTRInstance(), null);
                    }
                    AESNativeCTR.init(this.referenceWrapper.getReference(), this.referenceWrapper.getKey(), byArray);
                } else {
                    byte[] byArray2 = ((KeyParameter)parametersWithIV.getParameters()).getKey();
                    switch (byArray2.length) {
                        case 16: 
                        case 24: 
                        case 32: {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid key length, key must be 16,24 or 32 bytes");
                        }
                    }
                    this.keyLen = byArray2.length * 8;
                    this.referenceWrapper = new CTRRefWrapper(AESNativeCTR.makeCTRInstance(), byArray2);
                    AESNativeCTR.init(this.referenceWrapper.getReference(), this.referenceWrapper.getKey(), byArray);
                }
            } else {
                throw new IllegalArgumentException("CTR mode requires ParametersWithIV");
            }
            this.reset();
        }
    }

    static native long makeCTRInstance();

    @Override
    public String getAlgorithmName() {
        return "AES/CTR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte returnByte(byte by) {
        AESNativeCTR aESNativeCTR = this;
        synchronized (aESNativeCTR) {
            if (this.referenceWrapper == null) {
                throw new IllegalStateException("not initialized");
            }
            return AESNativeCTR.returnByte(this.referenceWrapper.getReference(), by);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
        AESNativeCTR aESNativeCTR = this;
        synchronized (aESNativeCTR) {
            if (this.referenceWrapper == null) {
                throw new IllegalStateException("not initialized");
            }
            return AESNativeCTR.processBytes(this.referenceWrapper.getReference(), byArray, n, n2, byArray2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        AESNativeCTR aESNativeCTR = this;
        synchronized (aESNativeCTR) {
            if (this.referenceWrapper == null) {
                return;
            }
            AESNativeCTR.reset(this.referenceWrapper.getReference());
        }
    }

    private static native long getPosition(long var0);

    private static native int getMultiBlockSize(long var0);

    private static native long skip(long var0, long var2);

    private static native long seekTo(long var0, long var2);

    static native void init(long var0, byte[] var2, byte[] var3);

    private static native byte returnByte(long var0, byte var2);

    private static native int processBytes(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6);

    private static native void reset(long var0);

    static native void dispose(long var0);

    public String toString() {
        if (this.keyLen > 0) {
            return "CTR[Native](AES[Native](" + this.keyLen + "))";
        }
        return "CTR[Native](AES[Native](not initialized))";
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class CTRRefWrapper
    extends NativeReference {
        private final byte[] key;

        public CTRRefWrapper(long l, byte[] byArray) {
            super(l, "CTR");
            this.key = byArray;
        }

        public byte[] getKey() {
            return this.key;
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference, this.key);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Disposer
    extends NativeDisposer {
        private final byte[] key;

        Disposer(long l, byte[] byArray) {
            super(l);
            this.key = byArray;
        }

        @Override
        protected void dispose(long l) {
            Arrays.clear(this.key);
            AESNativeCTR.dispose(l);
        }
    }
}

