/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.MalformedPacketException;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SecretSubkeyPacket;
import org.bouncycastle.bcpg.StreamUtil;
import org.bouncycastle.util.Arrays;

public class SecretKeyPacket
extends ContainedPacket
implements PublicKeyAlgorithmTags {
    public static final int MAX_S2K_ENCODING_LEN = 8192;
    public static final int USAGE_NONE = 0;
    public static final int USAGE_CHECKSUM = 255;
    public static final int USAGE_SHA1 = 254;
    public static final int USAGE_AEAD = 253;
    private PublicKeyPacket pubKeyPacket;
    private byte[] secKeyData;
    private int s2kUsage;
    private int encAlgorithm;
    private int aeadAlgorithm;
    private S2K s2k;
    private byte[] iv;

    SecretKeyPacket(BCPGInputStream in) throws IOException {
        this(5, in);
    }

    SecretKeyPacket(BCPGInputStream in, boolean newPacketFormat) throws IOException {
        this(5, in, newPacketFormat);
    }

    SecretKeyPacket(int keyTag, BCPGInputStream in) throws IOException {
        this(keyTag, in, false);
    }

    SecretKeyPacket(int keyTag, BCPGInputStream in, boolean newPacketFormat) throws IOException {
        super(keyTag, newPacketFormat);
        this.pubKeyPacket = this instanceof SecretSubkeyPacket ? new PublicSubkeyPacket(in, newPacketFormat) : new PublicKeyPacket(in, newPacketFormat);
        int version = this.pubKeyPacket.getVersion();
        this.s2kUsage = in.read();
        int conditionalParameterLength = -1;
        if (version == 5 || version == 6 && this.s2kUsage != 0) {
            conditionalParameterLength = in.read();
        }
        this.encAlgorithm = this.s2kUsage == 255 || this.s2kUsage == 254 || this.s2kUsage == 253 ? in.read() : this.s2kUsage;
        if (this.s2kUsage == 253) {
            this.aeadAlgorithm = in.read();
        }
        if (version == 6 && (this.s2kUsage == 254 || this.s2kUsage == 253)) {
            int s2KLen = SecretKeyPacket.sanitizeLength(in.read(), 8192, "S2K length octet");
            byte[] s2kBytes = new byte[s2KLen];
            in.readFully(s2kBytes);
            this.s2k = new S2K(new ByteArrayInputStream(s2kBytes));
        } else if (this.s2kUsage == 255 || this.s2kUsage == 254 || this.s2kUsage == 253) {
            this.s2k = new S2K(in);
        }
        if (this.s2kUsage == 253) {
            try {
                this.iv = new byte[AEADUtils.getIVLength(this.aeadAlgorithm)];
            }
            catch (IllegalArgumentException e) {
                throw new MalformedPacketException("Unknown AEAD algorithm", e);
            }
            in.readFully(this.iv);
        } else {
            boolean isGNUDummyNoPrivateKey;
            boolean bl = isGNUDummyNoPrivateKey = this.s2k != null && this.s2k.getType() == 101 && this.s2k.getProtectionMode() == 1;
            if (!isGNUDummyNoPrivateKey && this.s2kUsage != 0 && this.iv == null) {
                this.iv = this.encAlgorithm < 7 ? new byte[8] : new byte[16];
                in.readFully(this.iv, 0, this.iv.length);
            }
        }
        if (version == 5) {
            long keyOctetCount = (long)in.read() << 24 | (long)in.read() << 16 | (long)in.read() << 8 | (long)in.read();
            if (this.s2kUsage == 255 || this.s2kUsage == 0) {
                keyOctetCount += 2L;
            }
            int sanitizedOctetCount = SecretKeyPacket.sanitizeLength((int)keyOctetCount, 0x200000, "Key octet count");
            this.secKeyData = new byte[sanitizedOctetCount];
            in.readFully(this.secKeyData);
        } else {
            this.secKeyData = in.readAll();
        }
    }

    public SecretKeyPacket(PublicKeyPacket pubKeyPacket, int encAlgorithm, S2K s2k, byte[] iv, byte[] secKeyData) {
        this(5, pubKeyPacket, encAlgorithm, s2k, iv, secKeyData);
    }

    SecretKeyPacket(int keyTag, PublicKeyPacket pubKeyPacket, int encAlgorithm, S2K s2k, byte[] iv, byte[] secKeyData) {
        this(keyTag, pubKeyPacket, encAlgorithm, 0, encAlgorithm != 0 ? 255 : 0, s2k, iv, secKeyData);
    }

    public SecretKeyPacket(PublicKeyPacket pubKeyPacket, int encAlgorithm, int s2kUsage, S2K s2k, byte[] iv, byte[] secKeyData) {
        this(5, pubKeyPacket, encAlgorithm, 0, s2kUsage, s2k, iv, secKeyData);
    }

    public SecretKeyPacket(PublicKeyPacket pubKeyPacket, int encAlgorithm, int aeadAlgorithm, int s2kUsage, S2K s2k, byte[] iv, byte[] secKeyData) {
        this(5, pubKeyPacket, encAlgorithm, aeadAlgorithm, s2kUsage, s2k, iv, secKeyData);
    }

    SecretKeyPacket(int keyTag, PublicKeyPacket pubKeyPacket, int encAlgorithm, int aeadAlgorithm, int s2kUsage, S2K s2k, byte[] iv, byte[] secKeyData) {
        super(keyTag, pubKeyPacket.hasNewPacketFormat());
        this.pubKeyPacket = pubKeyPacket;
        this.encAlgorithm = encAlgorithm;
        this.aeadAlgorithm = aeadAlgorithm;
        this.s2kUsage = s2kUsage;
        this.s2k = s2k;
        this.iv = Arrays.clone((byte[])iv);
        this.secKeyData = secKeyData;
        if (s2k != null && s2k.getType() == 4 && s2kUsage != 253) {
            throw new IllegalArgumentException("Argon2 is only used with AEAD (S2K usage octet 253)");
        }
        if (pubKeyPacket.getVersion() == 6 && s2kUsage == 255) {
            throw new IllegalArgumentException("Version 6 keys MUST NOT use S2K usage USAGE_CHECKSUM");
        }
    }

    public int getEncAlgorithm() {
        return this.encAlgorithm;
    }

    public int getAeadAlgorithm() {
        return this.aeadAlgorithm;
    }

    public int getS2KUsage() {
        return this.s2kUsage;
    }

    public byte[] getIV() {
        return Arrays.clone((byte[])this.iv);
    }

    public S2K getS2K() {
        return this.s2k;
    }

    public PublicKeyPacket getPublicKeyPacket() {
        return this.pubKeyPacket;
    }

    public byte[] getSecretKeyData() {
        return this.secKeyData;
    }

    public byte[] getEncodedContents() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BCPGOutputStream pOut = new BCPGOutputStream(bOut);
        pOut.write(this.pubKeyPacket.getEncodedContents());
        pOut.write(this.s2kUsage);
        byte[] conditionalParameters = this.encodeConditionalParameters();
        if (this.pubKeyPacket.getVersion() == 5 || this.pubKeyPacket.getVersion() == 6 && this.s2kUsage != 0) {
            pOut.write(conditionalParameters.length);
        }
        pOut.write(conditionalParameters);
        if (this.secKeyData != null && this.secKeyData.length > 0) {
            if (this.pubKeyPacket.getVersion() == 5) {
                int keyOctetCount = this.secKeyData.length;
                if (this.s2kUsage == 255 || this.s2kUsage == 0) {
                    keyOctetCount -= 2;
                }
                StreamUtil.write4OctetLength(pOut, keyOctetCount);
            }
            pOut.write(this.secKeyData);
        }
        pOut.close();
        return bOut.toByteArray();
    }

    private byte[] encodeConditionalParameters() throws IOException {
        boolean hasS2KSpecifier;
        ByteArrayOutputStream conditionalParameters = new ByteArrayOutputStream();
        boolean bl = hasS2KSpecifier = this.s2kUsage == 255 || this.s2kUsage == 254 || this.s2kUsage == 253;
        if (hasS2KSpecifier) {
            conditionalParameters.write(this.encAlgorithm);
            if (this.s2kUsage == 253) {
                conditionalParameters.write(this.aeadAlgorithm);
            }
            byte[] encodedS2K = this.s2k.getEncoded();
            if (this.pubKeyPacket.getVersion() == 6) {
                conditionalParameters.write(encodedS2K.length);
            }
            conditionalParameters.write(encodedS2K);
        }
        if (this.iv != null) {
            conditionalParameters.write(this.iv);
        }
        return conditionalParameters.toByteArray();
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        out.writePacket(this.hasNewPacketFormat(), this.getPacketTag(), this.getEncodedContents());
    }
}

