/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ElGamalParameterSpec;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;

public class DSAElGamalKeyRingGenerator {
    private static void exportKeyPair(OutputStream outputStream, OutputStream outputStream2, KeyPair keyPair, KeyPair keyPair2, String string, char[] cArray, boolean bl) throws IOException, InvalidKeyException, NoSuchProviderException, SignatureException, PGPException {
        if (bl) {
            outputStream = new ArmoredOutputStream(outputStream);
        }
        PGPKeyPair pGPKeyPair = new PGPKeyPair(17, keyPair, new Date());
        PGPKeyPair pGPKeyPair2 = new PGPKeyPair(16, keyPair2, new Date());
        PGPDigestCalculator pGPDigestCalculator = new JcaPGPDigestCalculatorProviderBuilder().build().get(2);
        PGPKeyRingGenerator pGPKeyRingGenerator = new PGPKeyRingGenerator(19, pGPKeyPair, string, pGPDigestCalculator, null, null, new JcaPGPContentSignerBuilder(pGPKeyPair.getPublicKey().getAlgorithm(), 2), new JcePBESecretKeyEncryptorBuilder(9, pGPDigestCalculator).setProvider("BC").build(cArray));
        pGPKeyRingGenerator.addSubKey(pGPKeyPair2);
        pGPKeyRingGenerator.generateSecretKeyRing().encode(outputStream);
        outputStream.close();
        if (bl) {
            outputStream2 = new ArmoredOutputStream(outputStream2);
        }
        pGPKeyRingGenerator.generatePublicKeyRing().encode(outputStream2);
        outputStream2.close();
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (stringArray.length < 2) {
            System.out.println("DSAElGamalKeyRingGenerator [-a] identity passPhrase");
            System.exit(0);
        }
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DSA", "BC");
        keyPairGenerator.initialize(1024);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        KeyPairGenerator keyPairGenerator2 = KeyPairGenerator.getInstance("ELGAMAL", "BC");
        BigInteger bigInteger = new BigInteger("153d5d6172adb43045b68ae8e1de1070b6137005686d29d3d73a7749199681ee5b212c9b96bfdcfa5b20cd5e3fd2044895d609cf9b410b7a0f12ca1cb9a428cc", 16);
        BigInteger bigInteger2 = new BigInteger("9494fec095f3b85ee286542b3836fc81a5dd0a0349b4c239dd38744d488cf8e31db8bcb7d33b41abb9e5a33cca9144b1cef332c94bf0573bf047a3aca98cdf3b", 16);
        ElGamalParameterSpec elGamalParameterSpec = new ElGamalParameterSpec(bigInteger2, bigInteger);
        keyPairGenerator2.initialize((AlgorithmParameterSpec)elGamalParameterSpec);
        KeyPair keyPair2 = keyPairGenerator2.generateKeyPair();
        if (stringArray[0].equals("-a")) {
            if (stringArray.length < 3) {
                System.out.println("DSAElGamalKeyRingGenerator [-a] identity passPhrase");
                System.exit(0);
            }
            FileOutputStream fileOutputStream = new FileOutputStream("secret.asc");
            FileOutputStream fileOutputStream2 = new FileOutputStream("pub.asc");
            DSAElGamalKeyRingGenerator.exportKeyPair(fileOutputStream, fileOutputStream2, keyPair, keyPair2, stringArray[1], stringArray[2].toCharArray(), true);
        } else {
            FileOutputStream fileOutputStream = new FileOutputStream("secret.bpg");
            FileOutputStream fileOutputStream3 = new FileOutputStream("pub.bpg");
            DSAElGamalKeyRingGenerator.exportKeyPair(fileOutputStream, fileOutputStream3, keyPair, keyPair2, stringArray[0], stringArray[1].toCharArray(), false);
        }
    }
}

