/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.template;

import boofcv.alg.template.TemplateCorrelationFFT;
import boofcv.alg.template.TemplateIntensityImage;
import boofcv.alg.template.TemplateIntensityImage_MT;
import boofcv.alg.template.TemplateMatching;
import boofcv.alg.template.TemplateMatchingIntensity;
import boofcv.alg.template.TemplateNCC;
import boofcv.alg.template.TemplateSqDiffNormed;
import boofcv.alg.template.TemplateSumAbsoluteDifference;
import boofcv.alg.template.TemplateSumSquaredError;
import boofcv.concurrency.BoofConcurrency;
import boofcv.factory.template.TemplateScoreType;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;

public class FactoryTemplateMatching {
    public static <T extends ImageGray<T>> TemplateMatchingIntensity<T> createIntensity(TemplateScoreType type, Class<T> imageType) {
        TemplateIntensityImage.EvaluatorMethod<GrayU8> method;
        if (type == TemplateScoreType.CORRELATION) {
            if (imageType == GrayF32.class) {
                return new TemplateCorrelationFFT();
            }
            throw new IllegalArgumentException("Image type not supported. " + imageType.getSimpleName());
        }
        switch (type) {
            case SUM_ABSOLUTE_DIFFERENCE: {
                if (imageType == GrayU8.class) {
                    method = new TemplateSumAbsoluteDifference.U8();
                    break;
                }
                if (imageType == GrayF32.class) {
                    method = new TemplateSumAbsoluteDifference.F32();
                    break;
                }
                throw new IllegalArgumentException("Image type not supported. " + imageType.getSimpleName());
            }
            case SUM_SQUARE_ERROR: {
                if (imageType == GrayU8.class) {
                    method = new TemplateSumSquaredError.U8();
                    break;
                }
                if (imageType == GrayF32.class) {
                    method = new TemplateSumSquaredError.F32();
                    break;
                }
                throw new IllegalArgumentException("Image type not supported. " + imageType.getSimpleName());
            }
            case SQUARED_DIFFERENCE_NORMED: {
                if (imageType == GrayU8.class) {
                    method = new TemplateSqDiffNormed.U8();
                    break;
                }
                if (imageType == GrayF32.class) {
                    method = new TemplateSqDiffNormed.F32();
                    break;
                }
                throw new IllegalArgumentException("Image type not supported. " + imageType.getSimpleName());
            }
            case NCC: {
                if (imageType == GrayU8.class) {
                    method = new TemplateNCC.U8();
                    break;
                }
                if (imageType == GrayF32.class) {
                    method = new TemplateNCC.F32();
                    break;
                }
                throw new IllegalArgumentException("Image type not supported. " + imageType.getSimpleName());
            }
            default: {
                throw new IllegalArgumentException("Unknown");
            }
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            return new TemplateIntensityImage_MT<GrayU8>(method);
        }
        return new TemplateIntensityImage<GrayU8>(method);
    }

    public static <T extends ImageGray<T>> TemplateMatching<T> createMatcher(TemplateScoreType type, Class<T> imageType) {
        TemplateMatchingIntensity<T> intensity = FactoryTemplateMatching.createIntensity(type, imageType);
        return new TemplateMatching<T>(intensity);
    }
}

