/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.fiducial;

import boofcv.abst.shapes.polyline.ConfigPolylineSplitMerge;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.ConfigThresholdLocalOtsu;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.factory.shape.ConfigPolygonDetector;
import boofcv.struct.ConfigLength;
import boofcv.struct.Configuration;
import boofcv.struct.ConnectRule;

public class ConfigAztecCode
implements Configuration {
    public ConfigThreshold threshold;
    public ConfigPolygonDetector polygon = new ConfigPolygonDetector();
    public boolean considerTransposed = true;
    public int maxOrientationError = 4;

    public ConfigAztecCode() {
        ConfigThresholdLocalOtsu configThreshold = (ConfigThresholdLocalOtsu)ConfigThreshold.local((ThresholdType)ThresholdType.BLOCK_OTSU, (int)40);
        configThreshold.useOtsu2 = true;
        configThreshold.scale = 1.0;
        configThreshold.thresholdFromLocalBlocks = true;
        configThreshold.tuning = 4.0;
        this.threshold = configThreshold;
        this.polygon.detector.contourRule = ConnectRule.EIGHT;
        this.polygon.detector.clockwise = false;
        ((ConfigPolylineSplitMerge)this.polygon.detector.contourToPoly).maxSideError = ConfigLength.relative((double)0.12, (double)3.0);
        ((ConfigPolylineSplitMerge)this.polygon.detector.contourToPoly).cornerScorePenalty = 0.4;
        ((ConfigPolylineSplitMerge)this.polygon.detector.contourToPoly).minimumSideLength = 2;
        this.polygon.detector.minimumContour = ConfigLength.fixed((double)40.0);
        this.polygon.detector.minimumEdgeIntensity = 3.0;
        this.polygon.minimumRefineEdgeIntensity = 6.0;
        this.polygon.detector.tangentEdgeIntensity = 1.5;
    }

    public static ConfigAztecCode fast() {
        ConfigAztecCode config = new ConfigAztecCode();
        config.threshold = ConfigThreshold.global((ThresholdType)ThresholdType.GLOBAL_OTSU);
        return config;
    }

    public ConfigAztecCode setTo(ConfigAztecCode src) {
        this.threshold.setTo(src.threshold);
        this.polygon.setTo(src.polygon);
        this.considerTransposed = src.considerTransposed;
        this.maxOrientationError = src.maxOrientationError;
        return this;
    }

    public void checkValidity() {
        this.threshold.checkValidity();
        this.polygon.checkValidity();
        if (this.maxOrientationError < 0) {
            throw new IllegalArgumentException("maxOrientationError must be >= 0");
        }
    }
}

