/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.tld;

import boofcv.alg.descriptor.DescriptorDistance;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.struct.ImageRectangle;
import boofcv.struct.feature.NccFeature;
import boofcv.struct.image.ImageGray;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public class TldTemplateMatching<T extends ImageGray<T>> {
    private List<NccFeature> templatePositive = new ArrayList<NccFeature>();
    private List<NccFeature> templateNegative = new ArrayList<NccFeature>();
    private NccFeature observed = new NccFeature(225);
    private InterpolatePixelS<T> interpolate;
    protected ArrayDeque<NccFeature> unused = new ArrayDeque();

    public TldTemplateMatching(InterpolatePixelS<T> interpolate) {
        this.interpolate = interpolate;
    }

    protected TldTemplateMatching() {
    }

    public void reset() {
        this.unused.addAll(this.templateNegative);
        this.unused.addAll(this.templatePositive);
        this.templateNegative.clear();
        this.templatePositive.clear();
    }

    public void setImage(T gray) {
        this.interpolate.setImage(gray);
    }

    public void addDescriptor(boolean positive, ImageRectangle rect) {
        this.addDescriptor(positive, rect.x0, rect.y0, rect.x1, rect.y1);
    }

    public void addDescriptor(boolean positive, float x0, float y0, float x1, float y1) {
        NccFeature f = this.createDescriptor();
        this.computeNccDescriptor(f, x0, y0, x1, y1);
        this.addDescriptor(positive, f);
    }

    private void addDescriptor(boolean positive, NccFeature f) {
        if (positive && this.distance(f, this.templatePositive) < 0.05) {
            return;
        }
        if (!positive) {
            if (this.distance(f, this.templateNegative) < 0.05) {
                return;
            }
            if (this.distance(f, this.templatePositive) < 0.05) {
                return;
            }
        }
        if (positive) {
            this.templatePositive.add(f);
        } else {
            this.templateNegative.add(f);
        }
    }

    public void computeNccDescriptor(NccFeature f, float x0, float y0, float x1, float y1) {
        double mean = 0.0;
        float widthStep = (x1 - x0) / 15.0f;
        float heightStep = (y1 - y0) / 15.0f;
        int index = 0;
        for (int y = 0; y < 15; ++y) {
            float sampleY = y0 + (float)y * heightStep;
            for (int x = 0; x < 15; ++x) {
                int n = index++;
                double d = this.interpolate.get_fast(x0 + (float)x * widthStep, sampleY);
                f.data[n] = d;
                mean += d;
            }
        }
        mean /= 225.0;
        double variance = 0.0;
        index = 0;
        for (int y = 0; y < 15; ++y) {
            for (int x = 0; x < 15; ++x) {
                int n = index++;
                double d = f.data[n] - mean;
                f.data[n] = d;
                double v = d;
                variance += v * v;
            }
        }
        f.mean = mean;
        f.sigma = Math.sqrt(variance /= 225.0);
    }

    public NccFeature createDescriptor() {
        NccFeature f = this.unused.isEmpty() ? new NccFeature(225) : this.unused.pop();
        return f;
    }

    public double computeConfidence(int x0, int y0, int x1, int y1) {
        this.computeNccDescriptor(this.observed, x0, y0, x1, y1);
        if (this.templateNegative.size() > 0 && this.templatePositive.size() > 0) {
            double distancePositive = this.distance(this.observed, this.templatePositive);
            double distanceNegative = this.distance(this.observed, this.templateNegative);
            return distanceNegative / (distanceNegative + distancePositive);
        }
        if (this.templatePositive.size() > 0) {
            return 1.0 - this.distance(this.observed, this.templatePositive);
        }
        return this.distance(this.observed, this.templateNegative);
    }

    public double computeConfidence(ImageRectangle r) {
        return this.computeConfidence(r.x0, r.y0, r.x1, r.y1);
    }

    public double distance(NccFeature observed, List<NccFeature> candidates) {
        double maximum = -1.7976931348623157E308;
        for (int featIdx = 0; featIdx < candidates.size(); ++featIdx) {
            NccFeature f = candidates.get(featIdx);
            double score = DescriptorDistance.ncc((NccFeature)observed, (NccFeature)f);
            if (!(score > maximum)) continue;
            maximum = score;
        }
        return 1.0 - 0.5 * (maximum + 1.0);
    }

    public List<NccFeature> getTemplatePositive() {
        return this.templatePositive;
    }

    public List<NccFeature> getTemplateNegative() {
        return this.templateNegative;
    }
}

