/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.fiducial.calib.squares.SquareGraph;
import boofcv.alg.fiducial.qrcode.PositionPatternNode;
import boofcv.alg.fiducial.qrcode.SquareLocatorPatternDetectorBase;
import boofcv.alg.shapes.polygon.DetectPolygonBinaryGrayRefine;
import boofcv.alg.shapes.polygon.DetectPolygonFromContour;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.ImageGray;
import georegression.geometry.UtilLine2D_F64;
import georegression.geometry.UtilPoint2D_F64;
import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class QrCodePositionPatternDetector<T extends ImageGray<T>>
extends SquareLocatorPatternDetectorBase<T> {
    protected DogArray<PositionPatternNode> positionPatterns = new DogArray(PositionPatternNode::new, PositionPatternNode::reset);
    LineSegment2D_F64 segment = new LineSegment2D_F64();
    LineParametric2D_F64 parametric = new LineParametric2D_F64();
    float[] samples = new float[46];
    int[] length = new int[12];
    int[] type = new int[12];

    public QrCodePositionPatternDetector(DetectPolygonBinaryGrayRefine<T> squareDetector) {
        super(squareDetector);
    }

    public void resetRuntimeProfiling() {
        this.squareDetector.resetRuntimeProfiling();
    }

    @Override
    protected void findLocatorPatternsFromSquares() {
        this.squaresToPositionList();
    }

    private void squaresToPositionList() {
        this.positionPatterns.reset();
        List infoList = this.squareDetector.getPolygonInfo();
        for (int i = 0; i < infoList.size(); ++i) {
            DetectPolygonFromContour.Info info = (DetectPolygonFromContour.Info)infoList.get(i);
            double grayThreshold = (info.edgeInside + info.edgeOutside) / 2.0;
            if (!this.checkPositionPatternAppearance(info.polygon, (float)grayThreshold)) continue;
            this.squareDetector.refine(info);
            PositionPatternNode pp = (PositionPatternNode)this.positionPatterns.grow();
            pp.square = info.polygon;
            pp.grayThreshold = grayThreshold;
            SquareGraph.computeNodeInfo(pp);
        }
        if (this.verbose != null) {
            this.verbose.printf("squares=%d position_pattern=%d\n", this.squareDetector.getPolygonInfo().size(), this.positionPatterns.size);
        }
    }

    boolean checkPositionPatternAppearance(Polygon2D_F64 square, float grayThreshold) {
        return this.checkLine(square, grayThreshold, 0) || this.checkLine(square, grayThreshold, 1);
    }

    private boolean checkLine(Polygon2D_F64 square, float grayThreshold, int side) {
        int i;
        int c0 = side;
        int c1 = (side + 1) % 4;
        int c2 = (side + 2) % 4;
        int c3 = (side + 3) % 4;
        UtilPoint2D_F64.mean((Point2D_F64)square.get(c0), (Point2D_F64)square.get(c1), (Point2D_F64)this.segment.a);
        UtilPoint2D_F64.mean((Point2D_F64)square.get(c2), (Point2D_F64)square.get(c3), (Point2D_F64)this.segment.b);
        UtilLine2D_F64.convert((LineSegment2D_F64)this.segment, (LineParametric2D_F64)this.parametric);
        int period = this.samples.length / 9;
        double N = this.samples.length - 2 * period - 1;
        for (int i2 = 0; i2 < this.samples.length; ++i2) {
            double location = (double)(i2 - period) / N;
            float x = (float)(this.parametric.p.x + location * this.parametric.slope.x);
            float y = (float)(this.parametric.p.y + location * this.parametric.slope.y);
            this.samples[i2] = this.interpolate.get(x, y);
        }
        int size = 0;
        boolean black = this.samples[0] < grayThreshold;
        this.type[0] = black ? 0 : 1;
        for (i = 0; i < this.samples.length; ++i) {
            boolean b;
            boolean bl = b = this.samples[i] < grayThreshold;
            if (black == b) {
                int n = size;
                this.length[n] = this.length[n] + 1;
                continue;
            }
            black = b;
            if (size >= this.type.length - 1) break;
            this.type[++size] = black ? 0 : 1;
            this.length[size] = 1;
        }
        if (++size < 5 || size > 9) {
            return false;
        }
        i = 0;
        while (i + 5 <= size) {
            if (this.type[i] == 0) {
                int black02;
                int black0 = this.length[i];
                int black1 = this.length[i + 2];
                int black2 = this.length[i + 4];
                int white0 = this.length[i + 1];
                int white1 = this.length[i + 3];
                if (!((double)black0 < 0.4 * (double)white0) && black0 <= 3 * white0 && !((double)black2 < 0.4 * (double)white1) && black2 <= 3 * white1 && black1 >= (black02 = black0 + black2) && black1 <= 2 * black02) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    static boolean positionSquareIntensityCheck(float[] values, float threshold) {
        if (values[0] > threshold || values[1] < threshold) {
            return false;
        }
        if (values[2] > threshold || values[3] > threshold || values[4] > threshold) {
            return false;
        }
        return !(values[5] < threshold) && !(values[6] > threshold);
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix((VerbosePrint)this, (PrintStream)out);
    }

    public DogArray<PositionPatternNode> getPositionPatterns() {
        return this.positionPatterns;
    }
}

