/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

public class EciEncoding {
    public static final String BINARY = "binary";
    public static final String UTF8 = "UTF8";
    public static final String ISO8859_1 = "ISO8859_1";
    public static final String JIS = "JIS";

    public static boolean isValidUTF8(byte[] message) {
        int index = 0;
        while (index < message.length) {
            int letterSize;
            int value = message[index] & 0xFF;
            if (value >> 3 == 30) {
                letterSize = 4;
            } else if (value >> 4 == 14) {
                letterSize = 3;
            } else if (value >> 5 == 6) {
                letterSize = 2;
            } else if (value >> 7 == 0) {
                letterSize = 1;
            } else {
                return false;
            }
            for (int i = 1; i < letterSize; ++i) {
                if ((message[index + i] & 0xFF) >> 6 == 2) continue;
                return false;
            }
            if ((index += letterSize) != message.length) continue;
            return true;
        }
        return false;
    }

    public static String getEciCharacterSet(int designator) {
        String string;
        switch (designator) {
            case 0: 
            case 2: {
                string = "Cp437";
                break;
            }
            case 1: 
            case 3: {
                string = ISO8859_1;
                break;
            }
            case 4: {
                string = "ISO8859_2";
                break;
            }
            case 5: {
                string = "ISO8859_3";
                break;
            }
            case 6: {
                string = "ISO8859_4";
                break;
            }
            case 7: {
                string = "ISO8859_5";
                break;
            }
            case 8: {
                string = "ISO8859_6";
                break;
            }
            case 9: {
                string = "ISO8859_7";
                break;
            }
            case 10: {
                string = "ISO8859_8";
                break;
            }
            case 11: {
                string = "ISO8859_9";
                break;
            }
            case 12: {
                string = "ISO8859_10";
                break;
            }
            case 13: {
                string = "ISO8859_11";
                break;
            }
            case 14: {
                string = "ISO8859_12";
                break;
            }
            case 15: {
                string = "ISO8859_13";
                break;
            }
            case 16: {
                string = "ISO8859_14";
                break;
            }
            case 17: {
                string = "ISO8859_15";
                break;
            }
            case 18: {
                string = "ISO8859_16";
                break;
            }
            case 20: {
                string = "SJIS";
                break;
            }
            case 21: {
                string = "Cp1250";
                break;
            }
            case 22: {
                string = "Cp1251";
                break;
            }
            case 23: {
                string = "Cp1252";
                break;
            }
            case 24: {
                string = "Cp1256";
                break;
            }
            case 25: {
                string = "UnicodeBigUnmarked";
                break;
            }
            case 26: {
                string = UTF8;
                break;
            }
            case 27: 
            case 170: {
                string = "ASCII";
                break;
            }
            case 28: {
                string = "Big5";
                break;
            }
            case 29: {
                string = "GB18030";
                break;
            }
            case 30: {
                string = "EUC_KR";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ECI designator " + designator);
            }
        }
        return string;
    }
}

