/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.microqr;

import boofcv.alg.fiducial.microqr.MicroQrCode;
import boofcv.alg.fiducial.microqr.MicroQrCodeMaskPattern;
import boofcv.alg.fiducial.qrcode.PackedBits8;
import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.alg.fiducial.qrcode.QrCodeCodecBitsUtils;
import boofcv.alg.fiducial.qrcode.ReedSolomonCodes_U8;
import boofcv.misc.BoofMiscOps;
import georegression.struct.point.Point2D_I32;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.ddogleg.struct.DogArray_I8;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.data.BMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class MicroQrCodeEncoder
implements VerbosePrint {
    private final ReedSolomonCodes_U8 rscodes = new ReedSolomonCodes_U8(8, 285, 0);
    private final MicroQrCode qr = new MicroQrCode();
    private boolean autoErrorCorrection;
    private boolean autoMask;
    private Charset byteCharacterSet = StandardCharsets.UTF_8;
    PackedBits8 packed = new PackedBits8();
    private final DogArray_I8 message = new DogArray_I8();
    private final DogArray_I8 ecc = new DogArray_I8();
    private final List<QrCodeCodecBitsUtils.MessageSegment> segments = new ArrayList<QrCodeCodecBitsUtils.MessageSegment>();
    @Nullable
    PrintStream verbose = null;

    public MicroQrCodeEncoder() {
        this.reset();
    }

    public void reset() {
        this.qr.reset();
        this.qr.version = -1;
        this.packed.size = 0;
        this.autoMask = true;
        this.autoErrorCorrection = true;
        this.segments.clear();
    }

    public MicroQrCodeEncoder setVersion(int version) {
        this.qr.version = version;
        return this;
    }

    public MicroQrCodeEncoder setError(@Nullable MicroQrCode.ErrorLevel level) {
        boolean bl = this.autoErrorCorrection = level == null;
        if (level != null) {
            this.qr.error = level;
        }
        return this;
    }

    public MicroQrCodeEncoder setMask(MicroQrCodeMaskPattern pattern) {
        this.autoMask = false;
        this.qr.mask = pattern;
        return this;
    }

    public MicroQrCodeEncoder addAutomatic(String message) {
        QrCodeCodecBitsUtils.addAutomatic(this.byteCharacterSet, message, this.segments);
        return this;
    }

    private void encodeMode(QrCode.Mode mode) {
        int bits = MicroQrCode.modeIndicatorBitCount(this.qr.version);
        if (bits == 0) {
            return;
        }
        this.packed.append(mode.ordinal(), bits, false);
    }

    public MicroQrCodeEncoder addNumeric(String message) {
        this.segments.add(QrCodeCodecBitsUtils.createSegmentNumeric(message));
        return this;
    }

    public MicroQrCodeEncoder addNumeric(byte[] numbers) {
        this.segments.add(QrCodeCodecBitsUtils.createSegmentNumeric(numbers));
        return this;
    }

    private void encodeNumeric(byte[] numbers, int length) {
        this.qr.mode = QrCode.Mode.NUMERIC;
        this.encodeMode(this.qr.mode);
        int lengthBits = MicroQrCodeEncoder.getLengthBitsNumeric(this.qr.version);
        QrCodeCodecBitsUtils.encodeNumeric(numbers, length, lengthBits, this.packed);
    }

    public MicroQrCodeEncoder addAlphanumeric(String alphaNumeric) {
        this.segments.add(QrCodeCodecBitsUtils.createSegmentAlphanumeric(alphaNumeric));
        return this;
    }

    private void encodeAlphanumeric(byte[] numbers, int length) {
        if (this.qr.version < 2) {
            throw new RuntimeException("Alphanumeric requires version >= 2");
        }
        this.qr.mode = QrCode.Mode.ALPHANUMERIC;
        this.encodeMode(this.qr.mode);
        int lengthBits = MicroQrCodeEncoder.getLengthBitsAlphanumeric(this.qr.version);
        QrCodeCodecBitsUtils.encodeAlphanumeric(numbers, length, lengthBits, this.packed);
    }

    public MicroQrCodeEncoder addBytes(String message) {
        return this.addBytes(message.getBytes(this.byteCharacterSet));
    }

    public MicroQrCodeEncoder addBytes(byte[] data) {
        this.segments.add(QrCodeCodecBitsUtils.createSegmentBytes(data));
        return this;
    }

    private void encodeBytes(byte[] data, int length) {
        if (this.qr.version < 3) {
            throw new RuntimeException("Bytes requires version >= 3");
        }
        this.qr.mode = QrCode.Mode.BYTE;
        this.encodeMode(this.qr.mode);
        int lengthBits = MicroQrCodeEncoder.getLengthBitsBytes(this.qr.version);
        QrCodeCodecBitsUtils.encodeBytes(data, length, lengthBits, this.packed);
    }

    public MicroQrCodeEncoder addKanji(String message) {
        this.segments.add(QrCodeCodecBitsUtils.createSegmentKanji(message));
        return this;
    }

    private void encodeKanji(byte[] bytes, int length) {
        if (this.qr.version < 3) {
            throw new IllegalArgumentException("Kanji requires version >= 3");
        }
        this.qr.mode = QrCode.Mode.KANJI;
        this.encodeMode(this.qr.mode);
        int lengthBits = MicroQrCodeEncoder.getLengthBitsKanji(this.qr.version);
        QrCodeCodecBitsUtils.encodeKanji(bytes, length, lengthBits, this.packed);
    }

    public static int getLengthBitsNumeric(int version) {
        return 2 + version;
    }

    public static int getLengthBitsAlphanumeric(int version) {
        return 1 + version;
    }

    public static int getLengthBitsBytes(int version) {
        return 1 + version;
    }

    public static int getLengthBitsKanji(int version) {
        return version;
    }

    public MicroQrCode fixate() {
        this.autoSelectVersionAndError();
        if (this.verbose != null) {
            this.verbose.printf("version=%d error=%s mask=%s\n", new Object[]{this.qr.version, this.qr.error, this.qr.mask});
        }
        int expectedBitSize = this.bitsAtVersion(this.qr.version);
        this.qr.message = "";
        for (int segIdx = 0; segIdx < this.segments.size(); ++segIdx) {
            QrCodeCodecBitsUtils.MessageSegment m = this.segments.get(segIdx);
            this.qr.message = this.qr.message + m.message;
            switch (m.mode) {
                case NUMERIC: {
                    this.encodeNumeric(m.data, m.length);
                    break;
                }
                case ALPHANUMERIC: {
                    this.encodeAlphanumeric(m.data, m.length);
                    break;
                }
                case BYTE: {
                    this.encodeBytes(m.data, m.length);
                    break;
                }
                case KANJI: {
                    this.encodeKanji(m.data, m.length);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported: " + m.mode);
                }
            }
            if (this.verbose == null) continue;
            this.verbose.printf("_ segment: mode=%s message.size=%d packed.size=%d\n", new Object[]{m.mode, this.qr.message.length(), this.packed.size});
        }
        if (this.packed.size != expectedBitSize) {
            throw new RuntimeException("Bad size code. " + this.packed.size + " vs " + expectedBitSize);
        }
        int maxBits = MicroQrCode.maxDataBits(this.qr.version, this.qr.error);
        if (this.verbose != null) {
            this.verbose.printf("_ All Segments: packed.size=%d max=%d\n", this.packed.size, maxBits);
        }
        if (this.packed.size > maxBits) {
            throw new IllegalArgumentException("The message is longer than the max possible size");
        }
        int terminatorBits = this.qr.terminatorBits();
        if (this.packed.size < maxBits) {
            this.packed.append(0, Math.min(terminatorBits, maxBits - this.packed.size), false);
        }
        if (this.verbose != null) {
            this.verbose.printf("_ After Terminator: packed.size=%d\n", this.packed.size);
        }
        this.bitsToMessage(this.packed);
        if (this.autoMask) {
            this.qr.mask = MicroQrCodeEncoder.autoSelectMask(this.qr);
        }
        return this.qr;
    }

    static MicroQrCodeMaskPattern autoSelectMask(MicroQrCode qr) {
        int N = qr.getNumberOfModules();
        BMatrixRMaj matrix = MicroQrCodeEncoder.fillInBinaryMatrix(qr, N);
        return MicroQrCodeEncoder.selectBestMask(N, matrix);
    }

    private static MicroQrCodeMaskPattern selectBestMask(int N, BMatrixRMaj matrix) {
        MicroQrCodeMaskPattern bestMast = null;
        int bestScore = -1;
        for (MicroQrCodeMaskPattern mask : MicroQrCodeMaskPattern.values()) {
            int right = 0;
            int down = 0;
            for (int index = 1; index < N; ++index) {
                if (mask.apply(index, N - 1, matrix.get(index, N - 1) ? 1 : 0) == 1) {
                    ++right;
                }
                if (mask.apply(N - 1, index, matrix.get(N - 1, index) ? 1 : 0) != 1) continue;
                ++down;
            }
            int score = Math.min(right, down) * 16 + Math.max(right, down);
            if (score <= bestScore) continue;
            bestScore = score;
            bestMast = mask;
        }
        return Objects.requireNonNull(bestMast, "No valid mask?!");
    }

    private static BMatrixRMaj fillInBinaryMatrix(MicroQrCode qr, int N) {
        BMatrixRMaj matrix = new BMatrixRMaj(N, N);
        List<Point2D_I32> location = MicroQrCode.LOCATION_BITS[qr.version];
        PackedBits8 bits = new PackedBits8();
        bits.data = qr.rawbits;
        bits.size = location.size();
        for (int i = 0; i < location.size(); ++i) {
            Point2D_I32 p = location.get(i);
            matrix.unsafe_set(p.y, p.x, bits.get(i) == 1);
        }
        return matrix;
    }

    private void autoSelectVersionAndError() {
        if (this.qr.version == -1) {
            int minimumVersion = this.ensureMinimumVersionForMode();
            int maxEncodedSize = 0;
            block0: for (int version = minimumVersion; version <= 4; ++version) {
                MicroQrCode.ErrorLevel[] errorsToTry = this.autoErrorCorrection ? MicroQrCode.allowedErrorCorrection(version) : new MicroQrCode.ErrorLevel[]{this.qr.error};
                MicroQrCode.ErrorLevel[] errorLevelArray = errorsToTry;
                int n = errorLevelArray.length;
                for (int i = 0; i < n; ++i) {
                    MicroQrCode.ErrorLevel error;
                    this.qr.error = error = errorLevelArray[i];
                    int maxDataBits = MicroQrCode.maxDataBits(version, error);
                    int encodedDataBits = this.bitsAtVersion(version);
                    maxEncodedSize = Math.max(maxEncodedSize, encodedDataBits);
                    if (encodedDataBits > maxDataBits) continue;
                    this.qr.version = version;
                    break block0;
                }
            }
            if (this.qr.version == -1) {
                throw new IllegalArgumentException("Packet too big to be encoded. size=" + maxEncodedSize + " (bits)");
            }
        } else if (this.qr.version == 1) {
            this.qr.error = MicroQrCode.ErrorLevel.DETECT;
        } else if (this.autoErrorCorrection) {
            @Nullable MicroQrCode.ErrorLevel selected = null;
            int encodedDataBits = this.bitsAtVersion(this.qr.version);
            for (MicroQrCode.ErrorLevel error : MicroQrCode.allowedErrorCorrection(this.qr.version)) {
                int maxDataBits = MicroQrCode.maxDataBits(this.qr.version, error);
                if (encodedDataBits > maxDataBits) continue;
                selected = error;
                break;
            }
            if (selected == null) {
                throw new IllegalArgumentException("You need to use a high version number to store the data. Tried all error correction levels at version " + this.qr.version + ". Total Data " + this.packed.size / 8);
            }
            this.qr.error = selected;
        }
        int dataBits = this.bitsAtVersion(this.qr.version);
        int maxDataBits = MicroQrCode.maxDataBits(this.qr.version, this.qr.error);
        if (dataBits > maxDataBits) {
            int encodedBits = this.totalEncodedBitsNoOverHead();
            throw new IllegalArgumentException("Version and error level can't encode all the data. Version=" + this.qr.version + ", Error=" + this.qr.error + " , Encoded_Bits=" + encodedBits + ", Overhead_Bits=" + (dataBits - encodedBits) + " , Data_bits=" + dataBits + ", Limit_bits=" + maxDataBits);
        }
    }

    private int ensureMinimumVersionForMode() {
        int minimum = 0;
        for (QrCodeCodecBitsUtils.MessageSegment s : this.segments) {
            int n;
            switch (s.mode) {
                case NUMERIC: {
                    n = 1;
                    break;
                }
                case ALPHANUMERIC: {
                    n = 2;
                    break;
                }
                case BYTE: 
                case KANJI: {
                    n = 3;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected mode " + s.mode);
                }
            }
            int minVersion = n;
            minimum = Math.max(minVersion, minimum);
        }
        return minimum;
    }

    private int bitsAtVersion(int version) {
        int total = 0;
        for (int i = 0; i < this.segments.size(); ++i) {
            total += this.sizeInBits(this.segments.get(i), version);
        }
        return total;
    }

    private int totalEncodedBitsNoOverHead() {
        int total = 0;
        for (int i = 0; i < this.segments.size(); ++i) {
            total += this.segments.get((int)i).encodedSizeBits;
        }
        return total;
    }

    protected void bitsToMessage(PackedBits8 stream) {
        stream.append(0, (8 - stream.size % 8) % 8, false);
        MicroQrCode.VersionInfo version = MicroQrCode.VERSION_INFO[this.qr.version];
        MicroQrCode.DataInfo dataInfo = version.levels.get((Object)this.qr.error);
        if (dataInfo == null) {
            throw new IllegalArgumentException("Invalid error correction level selected for level");
        }
        this.qr.rawbits = new byte[version.codewords];
        int wordsEcc = version.codewords - dataInfo.dataCodewords;
        this.message.resize(dataInfo.dataCodewords);
        this.rscodes.generator(wordsEcc);
        this.ecc.resize(wordsEcc);
        System.arraycopy(stream.data, 0, this.message.data, 0, stream.arrayLength());
        this.addPadding(this.message, stream.arrayLength(), 55, 136);
        QrCodeCodecBitsUtils.flipBits8(this.message);
        this.rscodes.computeECC(this.message, this.ecc);
        QrCodeCodecBitsUtils.flipBits8(this.message);
        QrCodeCodecBitsUtils.flipBits8(this.ecc);
        System.arraycopy(this.message.data, 0, this.qr.rawbits, 0, this.message.size);
        System.arraycopy(this.ecc.data, 0, this.qr.rawbits, this.message.size, this.ecc.size);
    }

    private void addPadding(DogArray_I8 queue, int dataBytes, int padding0, int padding1) {
        if (this.verbose != null) {
            this.verbose.printf("_ padding.size=%d\n", queue.size - dataBytes);
        }
        boolean a = true;
        for (int i = dataBytes; i < queue.size; ++i) {
            queue.data[i] = a ? (byte)padding0 : (byte)padding1;
            a = !a;
        }
        if (dataBytes < queue.size && (this.qr.version == 1 || this.qr.version == 3)) {
            queue.data[queue.size - 1] = 0;
        }
    }

    public int sizeInBits(QrCodeCodecBitsUtils.MessageSegment segment, int version) {
        int n;
        switch (segment.mode) {
            case NUMERIC: {
                n = MicroQrCodeEncoder.getLengthBitsNumeric(version);
                break;
            }
            case ALPHANUMERIC: {
                n = MicroQrCodeEncoder.getLengthBitsAlphanumeric(version);
                break;
            }
            case BYTE: {
                n = MicroQrCodeEncoder.getLengthBitsBytes(version);
                break;
            }
            case KANJI: {
                n = MicroQrCodeEncoder.getLengthBitsKanji(version);
                break;
            }
            default: {
                throw new RuntimeException("Egads");
            }
        }
        int lengthBits = n;
        return segment.encodedSizeBits + lengthBits + MicroQrCode.modeIndicatorBitCount(version);
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix((VerbosePrint)this, (PrintStream)out);
    }

    public Charset getByteCharacterSet() {
        return this.byteCharacterSet;
    }

    public void setByteCharacterSet(Charset byteCharacterSet) {
        this.byteCharacterSet = byteCharacterSet;
    }
}

