/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.hamminggrids;

import boofcv.alg.drawing.FiducialRenderEngine;
import boofcv.alg.fiducial.square.FiducialSquareHammingGenerator;
import boofcv.factory.fiducial.ConfigHammingGrid;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;

public class HammingGridGenerator {
    public double squareWidth = 1.0;
    protected FiducialRenderEngine render;
    final ConfigHammingGrid config;
    private final FiducialSquareHammingGenerator squareGenerator;
    public final List<Point2D_F64> corners = new ArrayList<Point2D_F64>();

    public HammingGridGenerator(ConfigHammingGrid config) {
        this.config = config;
        this.squareGenerator = new FiducialSquareHammingGenerator(config.markers);
    }

    public void render() {
        this.render.init();
        this.squareGenerator.setRenderer(this.render);
        double w = this.squareWidth * this.config.squareSize;
        double ws = w * (this.config.spaceToSquare + 1.0);
        this.squareGenerator.setMarkerWidth(w);
        int markerIndex = this.config.markerOffset;
        for (int row = 0; row < this.config.numRows; ++row) {
            this.squareGenerator.offsetY = (double)row * ws;
            int col = 0;
            while (col < this.config.numCols) {
                this.squareGenerator.offsetX = (double)col * ws;
                this.squareGenerator.generateNoInit(markerIndex);
                ++col;
                ++markerIndex;
            }
        }
        this.saveCornerLocations();
    }

    public void saveCornerLocations() {
        this.corners.clear();
        int rows = this.config.numRows;
        int cols = this.config.numCols;
        double w = this.squareWidth * this.config.squareSize;
        double ws = w * (this.config.spaceToSquare + 1.0);
        for (int row = 0; row < rows; ++row) {
            double x;
            int col;
            double y = (double)(rows - row - 1) * ws + w;
            for (col = 0; col < cols; ++col) {
                x = (double)col * ws;
                this.corners.add(new Point2D_F64(x, y));
                this.corners.add(new Point2D_F64(x + w, y));
            }
            y -= w;
            for (col = 0; col < cols; ++col) {
                x = (double)col * ws;
                this.corners.add(new Point2D_F64(x, y));
                this.corners.add(new Point2D_F64(x + w, y));
            }
        }
    }

    public void setSquareWidth(double squareWidth) {
        this.squareWidth = squareWidth;
    }

    public double getSquareWidth() {
        return this.squareWidth;
    }

    public void setRender(FiducialRenderEngine render) {
        this.render = render;
    }
}

