/*
 * Decompiled with CFR 0.152.
 */
package org.bitstrings.maven.plugins.dependencypath;

import java.io.File;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.bitstrings.maven.plugins.dependencypath.PropertySet;
import org.codehaus.plexus.util.PathTool;

public class DependencyPathMojo
extends AbstractMojo {
    private MavenProject project;
    private PropertySet defaultPropertySet;
    private PropertySet[] propertySets;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.defaultPropertySet == null) {
            this.defaultPropertySet = new PropertySet();
        }
        if (this.propertySets == null) {
            this.propertySets = new PropertySet[]{new PropertySet()};
        }
        if (this.defaultPropertySet.getAutoRelativeSuffix() == null) {
            this.defaultPropertySet.setAutoRelativeSuffix(true);
        }
        if (this.defaultPropertySet.getTransitive() == null) {
            this.defaultPropertySet.setTransitive(true);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("defaultPropertySet" + this.defaultPropertySet));
            this.getLog().debug((CharSequence)("propertySets" + Arrays.toString(this.propertySets)));
        }
        Properties properties = this.project.getProperties();
        for (PropertySet propertySet : this.propertySets) {
            Set<String> includes = propertySet.getIncludes();
            Set<String> excludes = propertySet.getExcludes();
            Boolean transitive = propertySet.getTransitive();
            if (transitive == null) {
                transitive = this.defaultPropertySet.getTransitive();
            }
            Set artifacts = transitive != false ? this.project.getArtifacts() : this.project.getDependencyArtifacts();
            for (Artifact artifact : artifacts) {
                String suffix;
                String dependencyConflictId = artifact.getDependencyConflictId();
                if (includes != null && !includes.isEmpty() && !includes.contains(dependencyConflictId) || excludes != null && !excludes.isEmpty() && excludes.contains(dependencyConflictId)) continue;
                String key = dependencyConflictId;
                File relativeTo = propertySet.getRelativeTo();
                if (relativeTo == null) {
                    relativeTo = this.defaultPropertySet.getRelativeTo();
                }
                if (relativeTo != null) {
                    Boolean autoRelativeSuffix = propertySet.getAutoRelativeSuffix();
                    if (autoRelativeSuffix == null) {
                        autoRelativeSuffix = this.defaultPropertySet.getAutoRelativeSuffix();
                    }
                    if (autoRelativeSuffix.booleanValue()) {
                        key = key + ".relative";
                    }
                }
                if ((suffix = propertySet.getSuffix()) == null) {
                    suffix = this.defaultPropertySet.getSuffix();
                }
                if (suffix != null) {
                    key = key + "." + suffix;
                }
                String path = this.getPath(artifact, relativeTo);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Setting property for " + dependencyConflictId + " with key=" + key + ", path=" + path));
                }
                if (path == null) {
                    throw new MojoExecutionException("Unable to obtain path for " + dependencyConflictId + (relativeTo == null ? "(absolute)" : "(relative to " + relativeTo + ")") + ".");
                }
                properties.setProperty(key, path);
            }
        }
    }

    protected String getPath(Artifact artifact, File relativeTo) {
        return relativeTo == null ? artifact.getFile().getAbsolutePath() : PathTool.getRelativeFilePath((String)relativeTo.getPath(), (String)artifact.getFile().getAbsolutePath());
    }
}

