/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.keys;

import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.Set;
import org.jose4j.lang.JoseException;

abstract class KeyPairUtil {
    KeyPairUtil() {
    }

    abstract String getAlgorithm();

    protected KeyFactory getKeyFactory() throws JoseException {
        try {
            return KeyFactory.getInstance(this.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new JoseException("Couldn't find " + this.getAlgorithm() + " KeyFactory! " + e, e);
        }
    }

    protected KeyPairGenerator getKeyPairGenerator() throws JoseException {
        try {
            return KeyPairGenerator.getInstance(this.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new JoseException("Couldn't find " + this.getAlgorithm() + " KeyPairGenerator! " + e, e);
        }
    }

    public boolean isAvailable() {
        String algorithm;
        Set<String> keyFactories = Security.getAlgorithms("KeyFactory");
        Set<String> keyPairGenerators = Security.getAlgorithms("KeyPairGenerator");
        return keyPairGenerators.contains(algorithm = this.getAlgorithm()) && keyFactories.contains(algorithm);
    }
}

