/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.amqp.eventhandling.legacy;

import java.io.DataInputStream;
import java.io.IOException;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.extensions.amqp.eventhandling.legacy.EventMessageType;
import org.axonframework.messaging.Message;
import org.axonframework.serialization.SerializedMessage;
import org.axonframework.serialization.SerializedMetaData;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;

public class EventMessageReader {
    private final Serializer serializer;
    private final DataInputStream in;

    public EventMessageReader(DataInputStream input, Serializer serializer) {
        this.in = input;
        this.serializer = serializer;
    }

    public <T> EventMessage<T> readEventMessage() throws IOException {
        int firstByte = this.in.read();
        if (firstByte == -1) {
            return null;
        }
        EventMessageType messageType = EventMessageType.fromTypeByte((byte)firstByte);
        String identifier = this.in.readUTF();
        String timestamp = this.in.readUTF();
        String aggregateIdentifier = null;
        long sequenceNumber = 0L;
        if (messageType == EventMessageType.DOMAIN_EVENT_MESSAGE) {
            aggregateIdentifier = this.in.readUTF();
            sequenceNumber = this.in.readLong();
        }
        String payloadType = this.in.readUTF();
        String payloadRevision = this.in.readUTF();
        byte[] payload = new byte[this.in.readInt()];
        this.in.readFully(payload);
        int metaDataSize = this.in.readInt();
        byte[] metaData = new byte[metaDataSize];
        this.in.readFully(metaData);
        SimpleSerializedObject serializedPayload = new SimpleSerializedObject((Object)payload, byte[].class, payloadType, payloadRevision);
        SerializedMetaData serializedMetaData = new SerializedMetaData((Object)metaData, byte[].class);
        if (messageType == EventMessageType.DOMAIN_EVENT_MESSAGE) {
            return new GenericDomainEventMessage(null, aggregateIdentifier, sequenceNumber, (Message)new SerializedMessage(identifier, (SerializedObject)serializedPayload, (SerializedObject)serializedMetaData, this.serializer), () -> DateTimeUtils.parseInstant((CharSequence)timestamp));
        }
        return new GenericEventMessage((Message)new SerializedMessage(identifier, (SerializedObject)serializedPayload, (SerializedObject)serializedMetaData, this.serializer), () -> DateTimeUtils.parseInstant((CharSequence)timestamp));
    }
}

