/*
 * Decompiled with CFR 0.152.
 */
package org.audiveris.proxymusic.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.audiveris.proxymusic.Identification;
import org.audiveris.proxymusic.Miscellaneous;
import org.audiveris.proxymusic.MiscellaneousField;
import org.audiveris.proxymusic.ObjectFactory;
import org.audiveris.proxymusic.ScorePartwise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Source {
    private static final Logger logger = LoggerFactory.getLogger(Source.class);
    private static final String SOURCE_PREFIX = "source-";
    private static final String SHEET_PREFIX = "sheet-";
    private String file;
    private int offset;
    private URI uri;
    private final List<SheetSystems> sheets = new ArrayList<SheetSystems>();

    public static Source decode(ScorePartwise scorePartwise) {
        Identification identification = scorePartwise.getIdentification();
        if (identification == null) {
            return null;
        }
        Miscellaneous misc = identification.getMiscellaneous();
        if (misc == null) {
            return null;
        }
        Source source = new Source();
        for (MiscellaneousField field : misc.getMiscellaneousField()) {
            String name = field.getName();
            String value = field.getValue().trim();
            if (!name.startsWith(SOURCE_PREFIX)) continue;
            String tail = name.substring(SOURCE_PREFIX.length());
            if (tail.equals("file")) {
                source.file = value;
                continue;
            }
            if (tail.equals("uri")) {
                source.uri = URI.create(value);
                continue;
            }
            if (tail.equals("offset")) {
                source.offset = Integer.decode(value);
                continue;
            }
            if (!tail.startsWith(SHEET_PREFIX)) continue;
            String numStr = tail.substring(SHEET_PREFIX.length());
            int num = Integer.decode(numStr);
            SheetSystems sheet = new SheetSystems(num);
            source.sheets.add(sheet);
            sheet.getSystems().addAll(Source.parseInts(value));
        }
        return source;
    }

    public void encode(ScorePartwise scorePartwise) {
        MiscellaneousField field;
        Miscellaneous misc;
        ObjectFactory factory = new ObjectFactory();
        Identification identification = scorePartwise.getIdentification();
        if (identification == null) {
            identification = factory.createIdentification();
            scorePartwise.setIdentification(identification);
        }
        if ((misc = identification.getMiscellaneous()) == null) {
            misc = factory.createMiscellaneous();
            identification.setMiscellaneous(misc);
        }
        if (this.file != null) {
            field = factory.createMiscellaneousField();
            misc.getMiscellaneousField().add(field);
            field.setName("source-file");
            field.setValue(this.file);
        } else if (this.uri != null) {
            field = factory.createMiscellaneousField();
            misc.getMiscellaneousField().add(field);
            field.setName("source-uri");
            field.setValue(this.uri.toString());
        }
        if (this.offset != 0) {
            field = factory.createMiscellaneousField();
            misc.getMiscellaneousField().add(field);
            field.setName("source-offset");
            field.setValue("" + this.offset);
        }
        for (SheetSystems sheet : this.sheets) {
            field = factory.createMiscellaneousField();
            misc.getMiscellaneousField().add(field);
            field.setName("source-sheet-" + sheet.sheetNumber);
            field.setValue(Source.packInts(sheet.getSystems()));
        }
    }

    public String getFile() {
        return this.file;
    }

    public int getOffset() {
        return this.offset;
    }

    public List<SheetSystems> getSheets() {
        return this.sheets;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("{");
        if (this.file != null) {
            sb.append("file='").append(this.file).append("'");
        } else if (this.uri != null) {
            sb.append("uri=").append(this.uri);
        }
        if (this.offset != 0) {
            sb.append(" offset=").append(this.offset);
        }
        for (SheetSystems sheet : this.sheets) {
            sb.append(" ").append(sheet);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String packInts(List<Integer> ints) {
        StringBuilder sb = new StringBuilder();
        for (int val : ints) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(val);
        }
        return sb.toString();
    }

    private static List<Integer> parseInts(String str) {
        String[] tokens;
        ArrayList<Integer> intList = new ArrayList<Integer>();
        for (String token : tokens = str.split("\\s+")) {
            try {
                String trimmedToken = token.trim();
                if (trimmedToken.isEmpty()) continue;
                intList.add(Integer.decode(trimmedToken));
            }
            catch (NumberFormatException ex) {
                logger.warn("Illegal integer", (Throwable)ex);
            }
        }
        return intList;
    }

    public static class SheetSystems {
        final int sheetNumber;
        private final List<Integer> systems = new ArrayList<Integer>();

        public SheetSystems(int sheetNumber) {
            this.sheetNumber = sheetNumber;
        }

        public List<Integer> getSystems() {
            return this.systems;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("sheet");
            sb.append("#").append(this.sheetNumber);
            sb.append("[");
            boolean first = true;
            for (Integer system : this.systems) {
                if (!first) {
                    sb.append(" ");
                }
                sb.append(system);
                first = false;
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

