/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.multipart.part;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.asynchttpclient.request.body.multipart.ByteArrayPart;
import org.asynchttpclient.request.body.multipart.part.FileLikeMultipartPart;
import org.asynchttpclient.request.body.multipart.part.MultipartState;

public class ByteArrayMultipartPart
extends FileLikeMultipartPart<ByteArrayPart> {
    private final ByteBuf contentBuffer;

    public ByteArrayMultipartPart(ByteArrayPart part, byte[] boundary) {
        super(part, boundary);
        this.contentBuffer = Unpooled.wrappedBuffer((byte[])part.getBytes());
    }

    @Override
    protected long getContentLength() {
        return ((ByteArrayPart)this.part).getBytes().length;
    }

    @Override
    protected long transferContentTo(ByteBuf target) throws IOException {
        return this.transfer(this.contentBuffer, target, MultipartState.POST_CONTENT);
    }

    @Override
    protected long transferContentTo(WritableByteChannel target) throws IOException {
        return this.transfer(this.contentBuffer, target, MultipartState.POST_CONTENT);
    }

    @Override
    public void close() {
        super.close();
        this.contentBuffer.release();
    }
}

