/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.channel;

import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.HttpUtils;

public interface ChannelPoolPartitioning {
    public Object getPartitionKey(Uri var1, String var2, ProxyServer var3);

    public static enum PerHostChannelPoolPartitioning implements ChannelPoolPartitioning
    {
        INSTANCE;


        @Override
        public Object getPartitionKey(Uri uri, String virtualHost, ProxyServer proxyServer) {
            String targetHostBaseUrl;
            String string = targetHostBaseUrl = virtualHost != null ? virtualHost : HttpUtils.getBaseUrl(uri);
            if (proxyServer != null) {
                return uri.isSecured() ? new ProxyPartitionKey(proxyServer.getHost(), proxyServer.getSecuredPort(), true, targetHostBaseUrl) : new ProxyPartitionKey(proxyServer.getHost(), proxyServer.getPort(), false, targetHostBaseUrl);
            }
            return targetHostBaseUrl;
        }
    }

    public static class ProxyPartitionKey {
        private final String proxyHost;
        private final int proxyPort;
        private final boolean secured;
        private final String targetHostBaseUrl;

        public ProxyPartitionKey(String proxyHost, int proxyPort, boolean secured, String targetHostBaseUrl) {
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.secured = secured;
            this.targetHostBaseUrl = targetHostBaseUrl;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.proxyHost == null ? 0 : this.proxyHost.hashCode());
            result = 31 * result + this.proxyPort;
            result = 31 * result + (this.secured ? 1231 : 1237);
            result = 31 * result + (this.targetHostBaseUrl == null ? 0 : this.targetHostBaseUrl.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProxyPartitionKey other = (ProxyPartitionKey)obj;
            if (this.proxyHost == null ? other.proxyHost != null : !this.proxyHost.equals(other.proxyHost)) {
                return false;
            }
            if (this.proxyPort != other.proxyPort) {
                return false;
            }
            if (this.secured != other.secured) {
                return false;
            }
            return !(this.targetHostBaseUrl == null ? other.targetHostBaseUrl != null : !this.targetHostBaseUrl.equals(other.targetHostBaseUrl));
        }

        public String toString() {
            return "ProxyPartitionKey(proxyHost=" + this.proxyHost + ", proxyPort=" + this.proxyPort + ", secured=" + this.secured + ", targetHostBaseUrl=" + this.targetHostBaseUrl;
        }
    }
}

