/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.guava.api;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.guava.internal.RangeSets;

public class RangeSetAssert<T extends Comparable<T>>
extends AbstractAssert<RangeSetAssert<T>, RangeSet<T>> {
    @VisibleForTesting
    RangeSets rangeSets = RangeSets.instance();

    protected RangeSetAssert(RangeSet<T> actual) {
        super(actual, RangeSetAssert.class);
    }

    public RangeSetAssert<T> hasSize(int size) {
        this.rangeSets.assertHasSize((AssertionInfo)this.info, (RangeSet)this.actual, size);
        return (RangeSetAssert)this.myself;
    }

    @SafeVarargs
    public final RangeSetAssert<T> contains(T ... ranges) {
        this.rangeSets.assertContains((AssertionInfo)this.info, (RangeSet)this.actual, (Comparable[])ranges);
        return (RangeSetAssert)this.myself;
    }

    public RangeSetAssert<T> containsAll(Iterable<T> ranges) {
        this.rangeSets.assertContainsAll((AssertionInfo)this.info, (RangeSet)this.actual, ranges);
        return (RangeSetAssert)this.myself;
    }

    @SafeVarargs
    public final RangeSetAssert<T> containsAnyOf(T ... ranges) {
        this.rangeSets.assertContainsAnyOf((AssertionInfo)this.info, (RangeSet)this.actual, (Comparable[])ranges);
        return (RangeSetAssert)this.myself;
    }

    public RangeSetAssert<T> containsAnyRangesOf(Iterable<T> ranges) {
        this.rangeSets.assertContainsAnyRangesOf((AssertionInfo)this.info, (RangeSet)this.actual, ranges);
        return (RangeSetAssert)this.myself;
    }

    @SafeVarargs
    public final RangeSetAssert<T> doesNotContain(T ... ranges) {
        this.rangeSets.assertDoesNotContain((AssertionInfo)this.info, (RangeSet)this.actual, (Comparable[])ranges);
        return (RangeSetAssert)this.myself;
    }

    public RangeSetAssert<T> doesNotContainAll(Iterable<T> ranges) {
        this.rangeSets.assertDoesNotContainAll((AssertionInfo)this.info, (RangeSet)this.actual, ranges);
        return (RangeSetAssert)this.myself;
    }

    public RangeSetAssert<T> isEmpty() {
        this.rangeSets.assertEmpty((AssertionInfo)this.info, (RangeSet)this.actual);
        return (RangeSetAssert)this.myself;
    }

    public RangeSetAssert<T> isNotEmpty() {
        this.rangeSets.assertNotEmpty((AssertionInfo)this.info, (RangeSet)this.actual);
        return (RangeSetAssert)this.myself;
    }

    public RangeSetAssert<T> isNullOrEmpty() {
        this.rangeSets.assertNullOrEmpty((AssertionInfo)this.info, (RangeSet)this.actual);
        return (RangeSetAssert)this.myself;
    }

    @SafeVarargs
    public final RangeSetAssert<T> intersects(Range<T> ... ranges) {
        this.rangeSets.assertIntersects((AssertionInfo)this.info, (RangeSet)this.actual, ranges);
        return (RangeSetAssert)this.myself;
    }

    public RangeSetAssert<T> intersectsAll(RangeSet<T> rangeSet) {
        this.rangeSets.assertIntersectsAll((AssertionInfo)this.info, (RangeSet)this.actual, rangeSet);
        return (RangeSetAssert)this.myself;
    }

    public RangeSetAssert<T> intersectsAll(Iterable<Range<T>> ranges) {
        this.rangeSets.assertIntersectsAll((AssertionInfo)this.info, (RangeSet)this.actual, ranges);
        return (RangeSetAssert)this.myself;
    }

    @SafeVarargs
    public final RangeSetAssert<T> intersectsAnyOf(Range<T> ... ranges) {
        this.rangeSets.assertIntersectsAnyOf((AssertionInfo)this.info, (RangeSet)this.actual, ranges);
        return (RangeSetAssert)this.myself;
    }

    public RangeSetAssert<T> intersectsAnyRangesOf(Iterable<Range<T>> ranges) {
        this.rangeSets.assertIntersectsAnyRangesOf((AssertionInfo)this.info, (RangeSet)this.actual, ranges);
        return (RangeSetAssert)this.myself;
    }

    public RangeSetAssert<T> intersectsAnyRangesOf(RangeSet<T> rangeSet) {
        this.rangeSets.assertIntersectsAnyRangesOf((AssertionInfo)this.info, (RangeSet)this.actual, rangeSet);
        return (RangeSetAssert)this.myself;
    }

    @SafeVarargs
    public final RangeSetAssert<T> doesNotIntersect(Range<T> ... ranges) {
        this.rangeSets.assertDoesNotIntersect((AssertionInfo)this.info, (RangeSet)this.actual, ranges);
        return (RangeSetAssert)this.myself;
    }

    public RangeSetAssert<T> doesNotIntersectAnyRangeFrom(RangeSet<T> rangeSet) {
        this.rangeSets.assertDoesNotIntersectAnyRangeFrom((AssertionInfo)this.info, (RangeSet)this.actual, rangeSet);
        return (RangeSetAssert)this.myself;
    }

    public RangeSetAssert<T> doesNotIntersectAnyRangeFrom(Iterable<Range<T>> ranges) {
        this.rangeSets.assertDoesNotIntersectAnyRangeFrom((AssertionInfo)this.info, (RangeSet)this.actual, ranges);
        return (RangeSetAssert)this.myself;
    }

    @SafeVarargs
    public final RangeSetAssert<T> encloses(Range<T> ... ranges) {
        this.rangeSets.assertEncloses((AssertionInfo)this.info, (RangeSet)this.actual, ranges);
        return (RangeSetAssert)this.myself;
    }

    public RangeSetAssert<T> enclosesAll(Iterable<Range<T>> ranges) {
        this.rangeSets.assertEnclosesAll((AssertionInfo)this.info, (RangeSet)this.actual, ranges);
        return (RangeSetAssert)this.myself;
    }

    public RangeSetAssert<T> enclosesAll(RangeSet<T> rangeSet) {
        this.rangeSets.assertEnclosesAll((AssertionInfo)this.info, (RangeSet)this.actual, rangeSet);
        return (RangeSetAssert)this.myself;
    }

    @SafeVarargs
    public final RangeSetAssert<T> enclosesAnyOf(Range<T> ... ranges) {
        this.rangeSets.assertEnclosesAnyOf((AssertionInfo)this.info, (RangeSet)this.actual, ranges);
        return (RangeSetAssert)this.myself;
    }

    public RangeSetAssert<T> enclosesAnyRangesOf(Iterable<Range<T>> ranges) {
        this.rangeSets.assertEnclosesAnyRangesOf((AssertionInfo)this.info, (RangeSet)this.actual, ranges);
        return (RangeSetAssert)this.myself;
    }

    public RangeSetAssert<T> enclosesAnyRangesOf(RangeSet<T> rangeSet) {
        this.rangeSets.assertEnclosesAnyRangesOf((AssertionInfo)this.info, (RangeSet)this.actual, rangeSet);
        return (RangeSetAssert)this.myself;
    }

    @SafeVarargs
    public final RangeSetAssert<T> doesNotEnclose(Range<T> ... ranges) {
        this.rangeSets.assertDoesNotEnclose((AssertionInfo)this.info, (RangeSet)this.actual, ranges);
        return (RangeSetAssert)this.myself;
    }

    public RangeSetAssert<T> doesNotEncloseAnyRangesOf(Iterable<Range<T>> ranges) {
        this.rangeSets.doesNotEncloseAnyRangesOf((AssertionInfo)this.info, (RangeSet)this.actual, ranges);
        return (RangeSetAssert)this.myself;
    }

    public RangeSetAssert<T> doesNotEncloseAnyRangesOf(RangeSet<T> rangeSet) {
        this.rangeSets.doesNotEncloseAnyRangesOf((AssertionInfo)this.info, (RangeSet)this.actual, rangeSet);
        return (RangeSetAssert)this.myself;
    }
}

