/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.authentication.surrogate.SurrogateLdapAuthenticationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.surrogate.SurrogateAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.LdapUtils;
import org.ldaptive.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@Configuration(value="SurrogateLdapAuthenticationConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnProperty(prefix="cas.authn.surrogate.ldap", name={"ldap-url"})
public class SurrogateLdapAuthenticationConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogateLdapAuthenticationConfiguration.class);

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"surrogateLdapConnectionFactory"})
    public ConnectionFactory surrogateLdapConnectionFactory(CasConfigurationProperties casProperties) {
        SurrogateAuthenticationProperties su = casProperties.getAuthn().getSurrogate();
        return LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)su.getLdap());
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public SurrogateAuthenticationService surrogateAuthenticationService(@Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="surrogateLdapConnectionFactory") ConnectionFactory surrogateLdapConnectionFactory, CasConfigurationProperties casProperties) {
        SurrogateAuthenticationProperties su = casProperties.getAuthn().getSurrogate();
        LOGGER.debug("Using LDAP [{}] with baseDn [{}] to locate surrogate accounts", (Object)su.getLdap().getLdapUrl(), (Object)su.getLdap().getBaseDn());
        return new SurrogateLdapAuthenticationService(surrogateLdapConnectionFactory, su.getLdap(), servicesManager);
    }
}

