/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.surrogate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.surrogate.BaseSurrogateAuthenticationService;
import org.apereo.cas.configuration.model.support.surrogate.SurrogateLdapAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.RegexUtils;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.FilterTemplate;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class SurrogateLdapAuthenticationService
extends BaseSurrogateAuthenticationService
implements DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogateLdapAuthenticationService.class);
    private final ConnectionFactory connectionFactory;
    private final SurrogateLdapAuthenticationProperties ldapProperties;

    public SurrogateLdapAuthenticationService(ConnectionFactory connectionFactory, SurrogateLdapAuthenticationProperties ldap, ServicesManager servicesManager) {
        super(servicesManager);
        this.connectionFactory = connectionFactory;
        this.ldapProperties = ldap;
    }

    public boolean canAuthenticateAsInternal(String surrogate, Principal principal, Optional<Service> service) {
        try {
            String id = principal.getId();
            FilterTemplate filter = LdapUtils.newLdaptiveSearchFilter((String)this.ldapProperties.getSurrogateSearchFilter(), (List)CollectionUtils.wrapList((Object[])new String[]{"user", "surrogate"}), (List)CollectionUtils.wrapList((Object[])new String[]{id, surrogate}));
            LOGGER.debug("Using search filter to locate surrogate accounts for [{}]: [{}]", (Object)id, (Object)filter);
            SearchResponse response = LdapUtils.executeSearchOperation((ConnectionFactory)this.connectionFactory, (String)this.ldapProperties.getBaseDn(), (FilterTemplate)filter, (int)this.ldapProperties.getPageSize());
            LOGGER.debug("LDAP response: [{}]", (Object)response);
            return LdapUtils.containsResultEntry((SearchResponse)response);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return false;
        }
    }

    public Collection<String> getEligibleAccountsForSurrogateToProxy(String username) {
        try {
            FilterTemplate filter = LdapUtils.newLdaptiveSearchFilter((String)this.ldapProperties.getSearchFilter(), (List)CollectionUtils.wrap((Object)username));
            LOGGER.debug("Using search filter to find eligible accounts: [{}]", (Object)filter);
            SearchResponse response = LdapUtils.executeSearchOperation((ConnectionFactory)this.connectionFactory, (String)this.ldapProperties.getBaseDn(), (FilterTemplate)filter, (int)this.ldapProperties.getPageSize());
            LOGGER.debug("LDAP response: [{}]", (Object)response);
            if (!LdapUtils.containsResultEntry((SearchResponse)response)) {
                LOGGER.warn("LDAP response is not found or does not contain a result entry for [{}]", (Object)username);
                return new ArrayList<String>(0);
            }
            LdapEntry ldapEntry = response.getEntry();
            LdapAttribute attribute = ldapEntry.getAttribute(this.ldapProperties.getMemberAttributeName());
            LOGGER.debug("Locating LDAP entry [{}] with attribute [{}]", (Object)ldapEntry, (Object)attribute);
            if (attribute == null || attribute.getStringValues().isEmpty()) {
                LOGGER.warn("Attribute [{}] not found or has no values", (Object)this.ldapProperties.getMemberAttributeName());
                return new ArrayList<String>(0);
            }
            Pattern pattern = RegexUtils.createPattern((String)this.ldapProperties.getMemberAttributeValueRegex());
            LOGGER.debug("Constructed attribute value regex pattern [{}]", (Object)pattern.pattern());
            List<String> eligible = attribute.getStringValues().stream().map(pattern::matcher).filter(Matcher::matches).map(p -> {
                if (p.groupCount() > 0) {
                    return p.group(1);
                }
                return p.group();
            }).sorted().collect(Collectors.toList());
            LOGGER.debug("Following accounts may be eligible for surrogate authentication: [{}]", eligible);
            return eligible;
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            LOGGER.debug("No accounts may be eligible for surrogate authentication");
            return new ArrayList<String>(0);
        }
    }

    public void destroy() {
        this.connectionFactory.close();
    }
}

