/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import com.mongodb.client.MongoCollection;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.apereo.cas.mongo.MongoDbConnectionFactory;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.TextIndexDefinition;

public class MongoDbTicketRegistryFacilitator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbTicketRegistryFacilitator.class);
    private final TicketCatalog ticketCatalog;
    private final MongoTemplate mongoTemplate;
    private final boolean dropCollection;
    private final boolean createIndexes;
    private final boolean dropExistingIndexes;

    public void createTicketCollections() {
        Collection definitions = this.ticketCatalog.findAll();
        definitions.forEach(t -> {
            MongoCollection<Document> c = this.createTicketCollection((TicketDefinition)t);
            LOGGER.debug("Created MongoDb collection configuration for [{}]", (Object)c.getNamespace().getFullName());
        });
        LOGGER.info("Configured MongoDb Ticket Registry instance with available collections: [{}]", (Object)this.mongoTemplate.getCollectionNames());
    }

    private MongoCollection<Document> createTicketCollection(TicketDefinition ticket) {
        String collectionName = ticket.getProperties().getStorageName();
        LOGGER.trace("Setting up MongoDb Ticket Registry instance [{}]", (Object)collectionName);
        MongoDbConnectionFactory.createCollection((MongoOperations)this.mongoTemplate, (String)collectionName, (boolean)this.dropCollection);
        MongoCollection collection = this.mongoTemplate.getCollection(collectionName);
        if (this.createIndexes) {
            if (this.dropExistingIndexes) {
                LOGGER.trace("Dropping existing indexes on collection [{}]...", (Object)collectionName);
                MongoDbConnectionFactory.dropCollectionIndexes((MongoCollection)collection);
            }
            TextIndexDefinition columnsIndex = new TextIndexDefinition.TextIndexDefinitionBuilder().onField("json").onField("type").onField("ticketId").build();
            Index expireIndex = new Index().on("expireAt", Sort.Direction.ASC);
            long timeout = ticket.getProperties().getStorageTimeout();
            if (timeout > 0L && timeout != Long.MAX_VALUE) {
                expireIndex.expire(Duration.ofSeconds(timeout));
            }
            ArrayList<Object> expectedIndexes = new ArrayList<Object>();
            expectedIndexes.add(expireIndex);
            expectedIndexes.add(columnsIndex);
            LOGGER.debug("Expected indexes are [{}]", expectedIndexes);
            MongoDbConnectionFactory.createOrUpdateIndexes((MongoTemplate)this.mongoTemplate, (MongoCollection)collection, expectedIndexes);
        }
        return collection;
    }

    @Generated
    public MongoDbTicketRegistryFacilitator(TicketCatalog ticketCatalog, MongoTemplate mongoTemplate, boolean dropCollection, boolean createIndexes, boolean dropExistingIndexes) {
        this.ticketCatalog = ticketCatalog;
        this.mongoTemplate = mongoTemplate;
        this.dropCollection = dropCollection;
        this.createIndexes = createIndexes;
        this.dropExistingIndexes = dropExistingIndexes;
    }
}

