/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketState;
import org.apereo.cas.ticket.registry.AbstractTicketRegistry;
import org.apereo.cas.ticket.registry.TicketHolder;
import org.apereo.cas.ticket.serialization.TicketSerializationManager;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.LoggingUtils;
import org.hjson.JsonValue;
import org.hjson.Stringify;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.TextCriteria;
import org.springframework.data.mongodb.core.query.TextQuery;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.util.StreamUtils;

public class MongoDbTicketRegistry
extends AbstractTicketRegistry {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbTicketRegistry.class);
    private final TicketCatalog ticketCatalog;
    private final MongoOperations mongoTemplate;
    private final TicketSerializationManager ticketSerializationManager;

    private static Date getExpireAt(Ticket ticket) {
        Long ttl;
        ExpirationPolicy expirationPolicy = ticket.getExpirationPolicy();
        Long l = ttl = ticket instanceof TicketState ? expirationPolicy.getTimeToLive((TicketState)ticket) : expirationPolicy.getTimeToLive();
        if (ttl < 1L || ttl == Long.MAX_VALUE) {
            LOGGER.trace("Expiration date is undefined for ttl value [{}]", (Object)ttl);
            return null;
        }
        long exp = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(ttl);
        return DateTimeUtils.dateOf((Instant)Instant.ofEpochMilli(exp));
    }

    public void addTicketInternal(Ticket ticket) {
        try {
            LOGGER.debug("Adding ticket [{}]", (Object)ticket.getId());
            TicketHolder holder = this.buildTicketAsDocument(ticket);
            TicketDefinition metadata = this.ticketCatalog.find(ticket);
            if (metadata == null) {
                LOGGER.error("Could not locate ticket definition in the catalog for ticket [{}]", (Object)ticket.getId());
                return;
            }
            LOGGER.trace("Located ticket definition [{}] in the ticket catalog", (Object)metadata);
            String collectionName = this.getTicketCollectionInstanceByMetadata(metadata);
            LOGGER.trace("Found collection [{}] linked to ticket [{}]", (Object)collectionName, (Object)metadata);
            this.mongoTemplate.insert((Object)holder, collectionName);
            LOGGER.debug("Added ticket [{}]", (Object)ticket.getId());
        }
        catch (Exception e) {
            LOGGER.error("Failed adding [{}]", (Object)ticket);
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
    }

    public Ticket getTicket(String ticketId, Predicate<Ticket> predicate) {
        try {
            LOGGER.debug("Locating ticket ticketId [{}]", (Object)ticketId);
            String encTicketId = this.encodeTicketId(ticketId);
            if (encTicketId == null) {
                LOGGER.debug("Ticket id [{}] could not be found", (Object)ticketId);
                return null;
            }
            TicketDefinition metadata = this.ticketCatalog.find(ticketId);
            if (metadata == null) {
                LOGGER.debug("Ticket definition [{}] could not be found in the ticket catalog", (Object)ticketId);
                return null;
            }
            String collectionName = this.getTicketCollectionInstanceByMetadata(metadata);
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"ticketId").is((Object)encTicketId));
            TicketHolder d = (TicketHolder)this.mongoTemplate.findOne(query, TicketHolder.class, collectionName);
            if (d != null) {
                Ticket decoded = this.deserializeTicketFromMongoDocument(d);
                Ticket result = this.decodeTicket(decoded);
                if (predicate.test(result)) {
                    return result;
                }
                return null;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed fetching [{}]", (Object)ticketId);
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        return null;
    }

    public long deleteAll() {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"ticketId").exists(true));
        return this.ticketCatalog.findAll().stream().map(this::getTicketCollectionInstanceByMetadata).filter(StringUtils::isNotBlank).mapToLong(collectionName -> {
            long countTickets = this.mongoTemplate.count(query, collectionName);
            this.mongoTemplate.remove(query, collectionName);
            return countTickets;
        }).sum();
    }

    public Collection<? extends Ticket> getTickets() {
        return this.ticketCatalog.findAll().stream().map(this::getTicketCollectionInstanceByMetadata).map(map -> this.mongoTemplate.findAll(TicketHolder.class, map)).flatMap(Collection::stream).map(ticket -> this.decodeTicket(this.deserializeTicketFromMongoDocument((TicketHolder)ticket))).collect(Collectors.toSet());
    }

    public Ticket updateTicket(Ticket ticket) {
        LOGGER.debug("Updating ticket [{}]", (Object)ticket);
        try {
            TicketHolder holder = this.buildTicketAsDocument(ticket);
            TicketDefinition metadata = this.ticketCatalog.find(ticket);
            if (metadata == null) {
                LOGGER.error("Could not locate ticket definition in the catalog for ticket [{}]", (Object)ticket.getId());
                return null;
            }
            LOGGER.debug("Located ticket definition [{}] in the ticket catalog", (Object)metadata);
            String collectionName = this.getTicketCollectionInstanceByMetadata(metadata);
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"ticketId").is((Object)holder.getTicketId()));
            Update update = Update.update((String)"json", (Object)holder.getJson());
            UpdateResult result = this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, collectionName);
            LOGGER.debug("Updated ticket [{}] with result [{}]", (Object)ticket, (Object)result);
            return result.getMatchedCount() > 0L ? ticket : null;
        }
        catch (Exception e) {
            LOGGER.error("Failed updating [{}]", (Object)ticket);
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return null;
        }
    }

    public Stream<Ticket> stream() {
        return this.ticketCatalog.findAll().stream().map(this::getTicketCollectionInstanceByMetadata).map(map -> this.mongoTemplate.stream(new Query(), TicketHolder.class, map)).flatMap(StreamUtils::createStreamFromIterator).map(ticket -> this.decodeTicket(this.deserializeTicketFromMongoDocument((TicketHolder)ticket)));
    }

    public long sessionCount() {
        return this.countTicketsByTicketType(TicketGrantingTicket.class);
    }

    public long countSessionsFor(String principalId) {
        if (this.isCipherExecutorEnabled()) {
            return super.countSessionsFor(principalId);
        }
        Collection ticketDefinitions = this.ticketCatalog.find(TicketGrantingTicket.class);
        return ticketDefinitions.stream().map(this::getTicketCollectionInstanceByMetadata).mapToLong(map -> {
            TextCriteria criteria = TextCriteria.forDefaultLanguage().matchingAny(new String[]{principalId});
            Query query = TextQuery.queryText((TextCriteria)criteria).sortByScore().with((Pageable)PageRequest.of((int)0, (int)10));
            return this.mongoTemplate.count(query, map);
        }).sum();
    }

    public long serviceTicketCount() {
        return this.countTicketsByTicketType(ServiceTicket.class);
    }

    public boolean deleteSingleTicket(String ticketIdToDelete) {
        String ticketId = this.encodeTicketId(ticketIdToDelete);
        LOGGER.debug("Deleting ticket [{}]", (Object)ticketId);
        TicketDefinition metadata = this.ticketCatalog.find(ticketIdToDelete);
        String collectionName = this.getTicketCollectionInstanceByMetadata(metadata);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"ticketId").is((Object)ticketId));
        DeleteResult res = this.mongoTemplate.remove(query, collectionName);
        LOGGER.debug("Deleted ticket [{}] with result [{}]", (Object)ticketIdToDelete, (Object)res);
        return true;
    }

    private long countTicketsByTicketType(Class<? extends Ticket> ticketType) {
        Collection ticketDefinitions = this.ticketCatalog.find(ticketType);
        return ticketDefinitions.stream().map(this::getTicketCollectionInstanceByMetadata).mapToLong(map -> this.mongoTemplate.count(new Query(), map)).sum();
    }

    private TicketHolder buildTicketAsDocument(Ticket ticket) throws Exception {
        Ticket encTicket = this.encodeTicket(ticket);
        String json = this.serializeTicketForMongoDocument(encTicket);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            LOGGER.trace("Serialized ticket into a JSON document as \n [{}]", (Object)JsonValue.readJSON((String)json).toString(Stringify.FORMATTED));
            Date expireAt = MongoDbTicketRegistry.getExpireAt(ticket);
            LOGGER.trace("Calculated expiration date for ticket ttl as [{}]", (Object)expireAt);
            return new TicketHolder(json, encTicket.getId(), encTicket.getClass().getName(), expireAt);
        }
        throw new IllegalArgumentException("Ticket " + ticket.getId() + " cannot be serialized to JSON");
    }

    private String getTicketCollectionInstanceByMetadata(TicketDefinition metadata) {
        String mapName = metadata.getProperties().getStorageName();
        LOGGER.debug("Locating collection name [{}] for ticket definition [{}]", (Object)mapName, (Object)metadata);
        MongoCollection c = this.getTicketCollectionInstance(mapName);
        if (c != null) {
            return c.getNamespace().getCollectionName();
        }
        throw new IllegalArgumentException("Could not locate MongoDb collection " + mapName);
    }

    private MongoCollection getTicketCollectionInstance(String mapName) {
        try {
            MongoCollection inst = this.mongoTemplate.getCollection(mapName);
            LOGGER.debug("Located MongoDb collection instance [{}]", (Object)mapName);
            return inst;
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return null;
        }
    }

    private String serializeTicketForMongoDocument(Ticket ticket) {
        return this.ticketSerializationManager.serializeTicket(ticket);
    }

    private Ticket deserializeTicketFromMongoDocument(TicketHolder holder) {
        return this.ticketSerializationManager.deserializeTicket(holder.getJson(), holder.getType());
    }

    @Generated
    public MongoDbTicketRegistry(TicketCatalog ticketCatalog, MongoOperations mongoTemplate, TicketSerializationManager ticketSerializationManager) {
        this.ticketCatalog = ticketCatalog;
        this.mongoTemplate = mongoTemplate;
        this.ticketSerializationManager = ticketSerializationManager;
    }
}

