/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionRandomizedSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.mongo.BaseMongoDbProperties;
import org.apereo.cas.configuration.model.support.mongo.ticketregistry.MongoDbTicketRegistryProperties;
import org.apereo.cas.mongo.MongoDbConnectionFactory;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.registry.MongoDbTicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.serialization.TicketSerializationManager;
import org.apereo.cas.util.CoreTicketUtils;
import org.apereo.cas.util.MongoDbTicketRegistryFacilitator;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Configuration(value="MongoTicketRegistryConfiguration", proxyBeanMethods=false)
public class MongoDbTicketRegistryConfiguration {
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public TicketRegistry ticketRegistry(@Qualifier(value="ticketCatalog") TicketCatalog ticketCatalog, CasConfigurationProperties casProperties, @Qualifier(value="mongoDbTicketRegistryTemplate") MongoTemplate mongoDbTicketRegistryTemplate, @Qualifier(value="ticketSerializationManager") TicketSerializationManager ticketSerializationManager) {
        MongoDbTicketRegistryProperties mongo = casProperties.getTicket().getRegistry().getMongo();
        MongoDbTicketRegistry registry = new MongoDbTicketRegistry(ticketCatalog, (MongoOperations)mongoDbTicketRegistryTemplate, ticketSerializationManager);
        registry.setCipherExecutor(CoreTicketUtils.newTicketRegistryCipherExecutor((EncryptionRandomizedSigningJwtCryptographyProperties)mongo.getCrypto(), (String)"mongo"));
        new MongoDbTicketRegistryFacilitator(ticketCatalog, mongoDbTicketRegistryTemplate, mongo.isDropCollection(), mongo.isUpdateIndexes(), mongo.isDropIndexes()).createTicketCollections();
        return registry;
    }

    @ConditionalOnMissingBean(name={"mongoDbTicketRegistryTemplate"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MongoTemplate mongoDbTicketRegistryTemplate(CasConfigurationProperties casProperties, @Qualifier(value="casSslContext") CasSSLContext casSslContext) {
        MongoDbConnectionFactory factory = new MongoDbConnectionFactory(casSslContext.getSslContext());
        MongoDbTicketRegistryProperties mongo = casProperties.getTicket().getRegistry().getMongo();
        return factory.buildMongoTemplate((BaseMongoDbProperties)mongo);
    }
}

