/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry.support.kryo.serial;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.apereo.cas.util.DateTimeUtils;

public class ZonedDateTimeTranscoder
extends Serializer<ZonedDateTime> {
    public void write(Kryo kryo, Output output, ZonedDateTime dateTime) {
        kryo.writeObject(output, (Object)dateTime.toInstant().toEpochMilli());
        kryo.writeObject(output, (Object)dateTime.getZone().getId());
    }

    public ZonedDateTime read(Kryo kryo, Input input, Class<ZonedDateTime> type) {
        long time = (Long)kryo.readObject(input, Long.class);
        ZoneId zone = ZoneId.of(input.readString());
        return DateTimeUtils.zonedDateTimeOf((long)time, (ZoneId)zone);
    }
}

