/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry.support.kryo.serial;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.base.Throwables;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.apereo.cas.services.DefaultRegisteredServiceUsernameProvider;
import org.apereo.cas.services.LogoutType;
import org.apereo.cas.services.RefuseRegisteredServiceProxyPolicy;
import org.apereo.cas.services.RegexRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceProxyPolicy;
import org.apereo.cas.services.RegisteredServicePublicKey;
import org.apereo.cas.services.RegisteredServicePublicKeyImpl;
import org.apereo.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.ReturnAllowedAttributeReleasePolicy;

public class RegisteredServiceSerializer
extends Serializer<RegisteredService> {
    private static URL getEmptyUrl() {
        try {
            return new URL("https://");
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void write(Kryo kryo, Output output, RegisteredService service) {
        kryo.writeObject(output, (Object)service.getServiceId());
        kryo.writeObject(output, (Object)StringUtils.defaultIfEmpty((CharSequence)service.getName(), (CharSequence)""));
        kryo.writeObject(output, (Object)StringUtils.defaultIfEmpty((CharSequence)service.getDescription(), (CharSequence)""));
        kryo.writeObject(output, (Object)service.getId());
        kryo.writeObject(output, (Object)service.getEvaluationOrder());
        kryo.writeObject(output, ObjectUtils.defaultIfNull((Object)service.getLogo(), (Object)RegisteredServiceSerializer.getEmptyUrl()));
        kryo.writeObject(output, (Object)service.getLogoutType());
        kryo.writeObject(output, ObjectUtils.defaultIfNull((Object)service.getLogoutUrl(), (Object)RegisteredServiceSerializer.getEmptyUrl()));
        kryo.writeObject(output, new HashSet(service.getRequiredHandlers()));
        kryo.writeObject(output, (Object)StringUtils.defaultIfEmpty((CharSequence)service.getTheme(), (CharSequence)""));
        RegisteredServiceSerializer.writeObjectByReflection(kryo, output, ObjectUtils.defaultIfNull((Object)service.getPublicKey(), (Object)new RegisteredServicePublicKeyImpl()));
        RegisteredServiceSerializer.writeObjectByReflection(kryo, output, ObjectUtils.defaultIfNull((Object)service.getProxyPolicy(), (Object)new RefuseRegisteredServiceProxyPolicy()));
        RegisteredServiceSerializer.writeObjectByReflection(kryo, output, ObjectUtils.defaultIfNull((Object)service.getAttributeReleasePolicy(), (Object)new ReturnAllowedAttributeReleasePolicy()));
        RegisteredServiceSerializer.writeObjectByReflection(kryo, output, ObjectUtils.defaultIfNull((Object)service.getUsernameAttributeProvider(), (Object)new DefaultRegisteredServiceUsernameProvider()));
        RegisteredServiceSerializer.writeObjectByReflection(kryo, output, ObjectUtils.defaultIfNull((Object)service.getAccessStrategy(), (Object)new DefaultRegisteredServiceAccessStrategy()));
    }

    public RegisteredService read(Kryo kryo, Input input, Class<RegisteredService> type) {
        RegexRegisteredService svc = new RegexRegisteredService();
        svc.setServiceId((String)kryo.readObject(input, String.class));
        svc.setName((String)kryo.readObject(input, String.class));
        svc.setDescription((String)kryo.readObject(input, String.class));
        svc.setId(((Long)kryo.readObject(input, Long.class)).longValue());
        svc.setEvaluationOrder(((Integer)kryo.readObject(input, Integer.class)).intValue());
        svc.setLogo((URL)kryo.readObject(input, URL.class));
        svc.setLogoutType((LogoutType)kryo.readObject(input, LogoutType.class));
        svc.setLogoutUrl((URL)kryo.readObject(input, URL.class));
        svc.setRequiredHandlers((Set)kryo.readObject(input, HashSet.class));
        svc.setTheme((String)kryo.readObject(input, String.class));
        svc.setPublicKey((RegisteredServicePublicKey)RegisteredServiceSerializer.readObjectByReflection(kryo, input));
        svc.setProxyPolicy((RegisteredServiceProxyPolicy)RegisteredServiceSerializer.readObjectByReflection(kryo, input));
        svc.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)RegisteredServiceSerializer.readObjectByReflection(kryo, input));
        svc.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)RegisteredServiceSerializer.readObjectByReflection(kryo, input));
        svc.setAccessStrategy((RegisteredServiceAccessStrategy)RegisteredServiceSerializer.readObjectByReflection(kryo, input));
        return svc;
    }

    private static void writeObjectByReflection(Kryo kryo, Output output, Object obj) {
        String className = obj.getClass().getCanonicalName();
        kryo.writeObject(output, (Object)className);
        kryo.writeObject(output, obj);
    }

    private static <T> T readObjectByReflection(Kryo kryo, Input input) {
        try {
            String className = (String)kryo.readObject(input, String.class);
            Class<?> clazz = Class.forName(className);
            return (T)kryo.readObject(input, clazz);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

