/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.PreDestroy;
import net.spy.memcached.MemcachedClientIF;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.registry.AbstractTicketRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class MemCacheTicketRegistry
extends AbstractTicketRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemCacheTicketRegistry.class);
    private static final String NO_MEMCACHED_CLIENT_IS_DEFINED = "No memcached client is defined.";
    private final MemcachedClientIF client;

    public MemCacheTicketRegistry(MemcachedClientIF client) {
        this.client = client;
    }

    public Ticket updateTicket(Ticket ticketToUpdate) {
        Assert.notNull((Object)this.client, (String)NO_MEMCACHED_CLIENT_IS_DEFINED);
        Ticket ticket = this.encodeTicket(ticketToUpdate);
        LOGGER.debug("Updating ticket [{}]", (Object)ticket);
        try {
            if (!((Boolean)this.client.replace(ticket.getId(), MemCacheTicketRegistry.getTimeout(ticketToUpdate), (Object)ticket).get()).booleanValue()) {
                LOGGER.error("Failed to update [{}]", (Object)ticket);
                return null;
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted while waiting for response to async replace operation for ticket [{}]. Cannot determine whether update was successful.", (Object)ticket);
        }
        catch (Exception e) {
            LOGGER.error("Failed updating [{}]", (Object)ticket, (Object)e);
        }
        return ticket;
    }

    public void addTicket(Ticket ticketToAdd) {
        Assert.notNull((Object)this.client, (String)NO_MEMCACHED_CLIENT_IS_DEFINED);
        try {
            Ticket ticket = this.encodeTicket(ticketToAdd);
            LOGGER.debug("Adding ticket [{}]", (Object)ticket);
            int timeout = MemCacheTicketRegistry.getTimeout(ticketToAdd);
            if (!((Boolean)this.client.add(ticket.getId(), MemCacheTicketRegistry.getTimeout(ticketToAdd), (Object)ticket).get()).booleanValue()) {
                LOGGER.error("Failed to add [{}] without timeout [{}]", (Object)ticketToAdd, (Object)timeout);
            }
            if (this.client.get(ticket.getId()) == null) {
                LOGGER.warn("Ticket [{}] was added to memcached with timeout [{}], yet it cannot be retrieved. Ticket expiration policy may be too aggressive ?", (Object)ticketToAdd, (Object)timeout);
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted while waiting for response to async add operation for ticket [{}].Cannot determine whether add was successful.", (Object)ticketToAdd);
        }
        catch (Exception e) {
            LOGGER.error("Failed adding [{}]", (Object)ticketToAdd, (Object)e);
        }
    }

    public long deleteAll() {
        LOGGER.debug("deleteAll() isn't supported. Returning empty list");
        return 0L;
    }

    public boolean deleteSingleTicket(String ticketId) {
        Assert.notNull((Object)this.client, (String)NO_MEMCACHED_CLIENT_IS_DEFINED);
        try {
            if (((Boolean)this.client.delete(ticketId).get()).booleanValue()) {
                LOGGER.debug("Removed ticket [{}] from the cache", (Object)ticketId);
            } else {
                LOGGER.info("Ticket [{}] not found or is already removed.", (Object)ticketId);
            }
        }
        catch (Exception e) {
            LOGGER.error("Ticket not found or is already removed. Failed deleting [{}]", (Object)ticketId, (Object)e);
        }
        return true;
    }

    public Ticket getTicket(String ticketIdToGet) {
        Assert.notNull((Object)this.client, (String)NO_MEMCACHED_CLIENT_IS_DEFINED);
        String ticketId = this.encodeTicketId(ticketIdToGet);
        try {
            Ticket t = (Ticket)this.client.get(ticketId);
            if (t != null) {
                return this.decodeTicket(t);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed fetching [{}] ", (Object)ticketId, (Object)e);
        }
        return null;
    }

    public Collection<Ticket> getTickets() {
        LOGGER.debug("getTickets() isn't supported. Returning empty list");
        return new ArrayList<Ticket>();
    }

    @PreDestroy
    public void destroy() {
        if (this.client == null) {
            return;
        }
        this.client.shutdown();
    }

    private static int getTimeout(Ticket ticket) {
        int ttl = ticket.getExpirationPolicy().getTimeToLive().intValue();
        if (ttl == 0) {
            return 1;
        }
        return ttl;
    }
}

