/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.google.common.base.Throwables;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.DefaultHashAlgorithm;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedClientIF;
import net.spy.memcached.spring.MemcachedClientFactoryBean;
import net.spy.memcached.transcoders.Transcoder;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.CryptographyProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.ticket.registry.MemCacheTicketRegistry;
import org.apereo.cas.ticket.registry.NoOpTicketRegistryCleaner;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistryCleaner;
import org.apereo.cas.ticket.registry.support.kryo.KryoTranscoder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(value="memcachedConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class MemcachedTicketRegistryConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="logoutManager")
    private LogoutManager logoutManager;

    @Lazy
    @Bean
    public MemcachedClientFactoryBean memcachedClient() {
        try {
            MemcachedClientFactoryBean bean = new MemcachedClientFactoryBean();
            bean.setServers(this.casProperties.getTicket().getRegistry().getMemcached().getServers());
            bean.setLocatorType(ConnectionFactoryBuilder.Locator.valueOf((String)this.casProperties.getTicket().getRegistry().getMemcached().getLocatorType()));
            bean.setTranscoder((Transcoder)this.kryoTranscoder());
            bean.setFailureMode(FailureMode.valueOf((String)this.casProperties.getTicket().getRegistry().getMemcached().getFailureMode()));
            bean.setHashAlg((HashAlgorithm)DefaultHashAlgorithm.valueOf((String)this.casProperties.getTicket().getRegistry().getMemcached().getHashAlgorithm()));
            return bean;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Bean
    public KryoTranscoder kryoTranscoder() {
        return new KryoTranscoder();
    }

    @Autowired
    @Bean
    public TicketRegistry ticketRegistry(@Qualifier(value="memcachedClient") MemcachedClientIF memcachedClientIF) {
        MemCacheTicketRegistry registry = new MemCacheTicketRegistry(memcachedClientIF);
        registry.setCipherExecutor(Beans.newTicketRegistryCipherExecutor((CryptographyProperties)this.casProperties.getTicket().getRegistry().getMemcached().getCrypto()));
        return registry;
    }

    @Bean
    public TicketRegistryCleaner ticketRegistryCleaner() {
        return new NoOpTicketRegistryCleaner();
    }
}

