/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.events.mongo;

import java.time.ZonedDateTime;
import java.util.stream.Stream;
import lombok.Generated;
import org.apereo.cas.support.events.CasEventRepositoryFilter;
import org.apereo.cas.support.events.dao.AbstractCasEventRepository;
import org.apereo.cas.support.events.dao.CasEvent;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class MongoDbCasEventRepository
extends AbstractCasEventRepository {
    private final MongoOperations mongoTemplate;
    private final String collectionName;

    public MongoDbCasEventRepository(CasEventRepositoryFilter eventRepositoryFilter, MongoOperations mongoTemplate, String collectionName) {
        super(eventRepositoryFilter);
        this.mongoTemplate = mongoTemplate;
        this.collectionName = collectionName;
    }

    public Stream<? extends CasEvent> load() {
        return this.mongoTemplate.stream(new Query(), CasEvent.class, this.collectionName).stream();
    }

    public Stream<? extends CasEvent> load(ZonedDateTime dateTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"creationTime").gte((Object)dateTime.toString()));
        return this.mongoTemplate.stream(query, CasEvent.class, this.collectionName).stream();
    }

    public Stream<? extends CasEvent> getEventsOfTypeForPrincipal(String type, String principal) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type).and("principalId").is((Object)principal));
        return this.mongoTemplate.stream(query, CasEvent.class, this.collectionName).stream();
    }

    public Stream<? extends CasEvent> getEventsOfTypeForPrincipal(String type, String principal, ZonedDateTime dateTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type).and("principalId").is((Object)principal).and("creationTime").gte((Object)dateTime.toString()));
        return this.mongoTemplate.stream(query, CasEvent.class, this.collectionName).stream();
    }

    public Stream<? extends CasEvent> getEventsOfType(String type) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type));
        return this.mongoTemplate.stream(query, CasEvent.class, this.collectionName).stream();
    }

    public Stream<? extends CasEvent> getEventsOfType(String type, ZonedDateTime dateTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type).and("creationTime").gte((Object)dateTime.toString()));
        return this.mongoTemplate.stream(query, CasEvent.class, this.collectionName).stream();
    }

    public Stream<? extends CasEvent> getEventsForPrincipal(String id) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"principalId").is((Object)id));
        return this.mongoTemplate.stream(query, CasEvent.class, this.collectionName).stream();
    }

    public Stream<? extends CasEvent> getEventsForPrincipal(String principal, ZonedDateTime dateTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"principalId").is((Object)principal).and("creationTime").gte((Object)dateTime.toString()));
        return this.mongoTemplate.stream(query, CasEvent.class, this.collectionName).stream();
    }

    public CasEvent saveInternal(CasEvent event) {
        return (CasEvent)this.mongoTemplate.save((Object)event, this.collectionName);
    }

    @Generated
    public String toString() {
        return "MongoDbCasEventRepository(mongoTemplate=" + this.mongoTemplate + ", collectionName=" + this.collectionName + ")";
    }
}

