/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.events.MongoDbEventsProperties;
import org.apereo.cas.configuration.model.support.mongo.BaseMongoDbProperties;
import org.apereo.cas.mongo.MongoDbConnectionFactory;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.cas.support.events.CasEventRepositoryFilter;
import org.apereo.cas.support.events.mongo.MongoDbCasEventRepository;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.dao.annotation.PersistenceExceptionTranslationPostProcessor;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Configuration(value="MongoDbEventsConfiguration", proxyBeanMethods=false)
public class MongoDbEventsConfiguration {
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public PersistenceExceptionTranslationPostProcessor persistenceExceptionTranslationPostProcessor() {
        return new PersistenceExceptionTranslationPostProcessor();
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"mongoEventsTemplate"})
    public MongoTemplate mongoEventsTemplate(CasConfigurationProperties casProperties, @Qualifier(value="casSslContext") CasSSLContext casSslContext) {
        MongoDbEventsProperties mongo = casProperties.getEvents().getMongo();
        MongoDbConnectionFactory factory = new MongoDbConnectionFactory(casSslContext.getSslContext());
        MongoTemplate mongoTemplate = factory.buildMongoTemplate((BaseMongoDbProperties)mongo);
        MongoDbConnectionFactory.createCollection((MongoOperations)mongoTemplate, (String)mongo.getCollection(), (boolean)mongo.isDropCollection());
        return mongoTemplate;
    }

    @ConditionalOnMissingBean(name={"mongoEventRepositoryFilter"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasEventRepositoryFilter mongoEventRepositoryFilter() {
        return CasEventRepositoryFilter.noOp();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasEventRepository casEventRepository(CasConfigurationProperties casProperties, @Qualifier(value="mongoEventRepositoryFilter") CasEventRepositoryFilter mongoEventRepositoryFilter, @Qualifier(value="mongoEventsTemplate") MongoTemplate mongoEventsTemplate) {
        MongoDbEventsProperties mongo = casProperties.getEvents().getMongo();
        return new MongoDbCasEventRepository(mongoEventRepositoryFilter, (MongoOperations)mongoEventsTemplate, mongo.getCollection());
    }
}

