/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apereo.cas.configuration.model.BulkNotifications;
import org.apereo.cas.configuration.model.CasServers;
import org.apereo.cas.configuration.model.DelegatedNotifications;
import org.apereo.cas.configuration.model.RegisterNotifications;
import org.apereo.cas.configuration.model.SubmissionNotifications;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.ldap.LdapAuthenticationProperties;
import org.apereo.cas.configuration.model.support.ldap.LdapAuthorizationProperties;
import org.apereo.cas.configuration.support.RequiresModule;
import org.apereo.cas.util.CollectionUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@ConfigurationProperties(value="mgmt", ignoreUnknownFields=false)
public class CasManagementConfigurationProperties
implements Serializable {
    private static final long serialVersionUID = -7686426966125636166L;
    private List<String> adminRoles = CollectionUtils.wrapList((Object[])new String[]{"ROLE_ADMIN"});
    private List<String> userRoles = CollectionUtils.wrapList((Object[])new String[]{"ROLE_USER"});
    private String serverName = "https://localhost:8443";
    private String defaultLocale = "en";
    private String authzIpRegex;
    private List<String> authzAttributes = new ArrayList<String>();
    private Ldap ldap = new Ldap();
    private LdapAuthenticationProperties ldapAuth = new LdapAuthenticationProperties();
    private boolean casSso = true;
    private transient Resource userPropertiesFile = new ClassPathResource("users.json");
    private boolean enableDiscoveryEndpointCall;
    private String discoveryEndpointPath = "/actuator/discoveryProfile";
    private VersionControl versionControl = new VersionControl();
    private Delegated delegated = new Delegated();
    private Submissions submissions = new Submissions();
    private Register register = new Register();
    private String luceneIndexDir = "/etc/cas/lucene";
    private String metadataRepoDir = "/etc/cas-mgmt/metadata";
    private String metadataDir = "/etc/cas/metadata";
    private Resource inCommonCert = new ClassPathResource("incommon.pem");
    private String inCommonCertLocation = "/etc/cas/idp/inc-md-cert-mdq.pem";
    private String inCommonMDQUrl = "https://mdq.incommon.org/entities";
    private List<CasServers> casServers = new ArrayList<CasServers>();
    private String cacheHealthIndicator = "session";
    private List<String> attributeRepositories = new ArrayList<String>();
    private Set<String> delegatedIdentityProviders = Stream.of("Twitter", "Orcid", "Dropbox", "Github", "Facebook", "Yahoo", "Wordpress", "PayPal", "Google", "WindowsLive", "Foursquare").collect(Collectors.toSet());
    private boolean attributeStoreEnabled;

    @Generated
    public List<String> getAdminRoles() {
        return this.adminRoles;
    }

    @Generated
    public List<String> getUserRoles() {
        return this.userRoles;
    }

    @Generated
    public String getServerName() {
        return this.serverName;
    }

    @Generated
    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    @Generated
    public String getAuthzIpRegex() {
        return this.authzIpRegex;
    }

    @Generated
    public List<String> getAuthzAttributes() {
        return this.authzAttributes;
    }

    @Generated
    public Ldap getLdap() {
        return this.ldap;
    }

    @Generated
    public LdapAuthenticationProperties getLdapAuth() {
        return this.ldapAuth;
    }

    @Generated
    public boolean isCasSso() {
        return this.casSso;
    }

    @Generated
    public Resource getUserPropertiesFile() {
        return this.userPropertiesFile;
    }

    @Generated
    public boolean isEnableDiscoveryEndpointCall() {
        return this.enableDiscoveryEndpointCall;
    }

    @Generated
    public String getDiscoveryEndpointPath() {
        return this.discoveryEndpointPath;
    }

    @Generated
    public VersionControl getVersionControl() {
        return this.versionControl;
    }

    @Generated
    public Delegated getDelegated() {
        return this.delegated;
    }

    @Generated
    public Submissions getSubmissions() {
        return this.submissions;
    }

    @Generated
    public Register getRegister() {
        return this.register;
    }

    @Generated
    public String getLuceneIndexDir() {
        return this.luceneIndexDir;
    }

    @Generated
    public String getMetadataRepoDir() {
        return this.metadataRepoDir;
    }

    @Generated
    public String getMetadataDir() {
        return this.metadataDir;
    }

    @Generated
    public Resource getInCommonCert() {
        return this.inCommonCert;
    }

    @Generated
    public String getInCommonCertLocation() {
        return this.inCommonCertLocation;
    }

    @Generated
    public String getInCommonMDQUrl() {
        return this.inCommonMDQUrl;
    }

    @Generated
    public List<CasServers> getCasServers() {
        return this.casServers;
    }

    @Generated
    public String getCacheHealthIndicator() {
        return this.cacheHealthIndicator;
    }

    @Generated
    public List<String> getAttributeRepositories() {
        return this.attributeRepositories;
    }

    @Generated
    public Set<String> getDelegatedIdentityProviders() {
        return this.delegatedIdentityProviders;
    }

    @Generated
    public boolean isAttributeStoreEnabled() {
        return this.attributeStoreEnabled;
    }

    @Generated
    public void setAdminRoles(List<String> adminRoles) {
        this.adminRoles = adminRoles;
    }

    @Generated
    public void setUserRoles(List<String> userRoles) {
        this.userRoles = userRoles;
    }

    @Generated
    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @Generated
    public void setDefaultLocale(String defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    @Generated
    public void setAuthzIpRegex(String authzIpRegex) {
        this.authzIpRegex = authzIpRegex;
    }

    @Generated
    public void setAuthzAttributes(List<String> authzAttributes) {
        this.authzAttributes = authzAttributes;
    }

    @Generated
    public void setLdap(Ldap ldap) {
        this.ldap = ldap;
    }

    @Generated
    public void setLdapAuth(LdapAuthenticationProperties ldapAuth) {
        this.ldapAuth = ldapAuth;
    }

    @Generated
    public void setCasSso(boolean casSso) {
        this.casSso = casSso;
    }

    @Generated
    public void setUserPropertiesFile(Resource userPropertiesFile) {
        this.userPropertiesFile = userPropertiesFile;
    }

    @Generated
    public void setEnableDiscoveryEndpointCall(boolean enableDiscoveryEndpointCall) {
        this.enableDiscoveryEndpointCall = enableDiscoveryEndpointCall;
    }

    @Generated
    public void setDiscoveryEndpointPath(String discoveryEndpointPath) {
        this.discoveryEndpointPath = discoveryEndpointPath;
    }

    @Generated
    public void setVersionControl(VersionControl versionControl) {
        this.versionControl = versionControl;
    }

    @Generated
    public void setDelegated(Delegated delegated) {
        this.delegated = delegated;
    }

    @Generated
    public void setSubmissions(Submissions submissions) {
        this.submissions = submissions;
    }

    @Generated
    public void setRegister(Register register) {
        this.register = register;
    }

    @Generated
    public void setLuceneIndexDir(String luceneIndexDir) {
        this.luceneIndexDir = luceneIndexDir;
    }

    @Generated
    public void setMetadataRepoDir(String metadataRepoDir) {
        this.metadataRepoDir = metadataRepoDir;
    }

    @Generated
    public void setMetadataDir(String metadataDir) {
        this.metadataDir = metadataDir;
    }

    @Generated
    public void setInCommonCert(Resource inCommonCert) {
        this.inCommonCert = inCommonCert;
    }

    @Generated
    public void setInCommonCertLocation(String inCommonCertLocation) {
        this.inCommonCertLocation = inCommonCertLocation;
    }

    @Generated
    public void setInCommonMDQUrl(String inCommonMDQUrl) {
        this.inCommonMDQUrl = inCommonMDQUrl;
    }

    @Generated
    public void setCasServers(List<CasServers> casServers) {
        this.casServers = casServers;
    }

    @Generated
    public void setCacheHealthIndicator(String cacheHealthIndicator) {
        this.cacheHealthIndicator = cacheHealthIndicator;
    }

    @Generated
    public void setAttributeRepositories(List<String> attributeRepositories) {
        this.attributeRepositories = attributeRepositories;
    }

    @Generated
    public void setDelegatedIdentityProviders(Set<String> delegatedIdentityProviders) {
        this.delegatedIdentityProviders = delegatedIdentityProviders;
    }

    @Generated
    public void setAttributeStoreEnabled(boolean attributeStoreEnabled) {
        this.attributeStoreEnabled = attributeStoreEnabled;
    }

    @RequiresModule(name="cas-mgmt-config-register")
    public static class Register
    implements Serializable {
        private boolean enabled;
        private RegisterNotifications notifications = new RegisterNotifications();
        private BulkNotifications bulkNotifications = new BulkNotifications();

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public RegisterNotifications getNotifications() {
            return this.notifications;
        }

        @Generated
        public BulkNotifications getBulkNotifications() {
            return this.bulkNotifications;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setNotifications(RegisterNotifications notifications) {
            this.notifications = notifications;
        }

        @Generated
        public void setBulkNotifications(BulkNotifications bulkNotifications) {
            this.bulkNotifications = bulkNotifications;
        }
    }

    @RequiresModule(name="cas-mgmt-config-submissions")
    public static class Submissions
    implements Serializable {
        private String submitDir = "/etc/cas/submitted";
        private boolean enabled;
        @NestedConfigurationProperty
        private SubmissionNotifications notifications = new SubmissionNotifications();

        @Generated
        public String getSubmitDir() {
            return this.submitDir;
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public SubmissionNotifications getNotifications() {
            return this.notifications;
        }

        @Generated
        public void setSubmitDir(String submitDir) {
            this.submitDir = submitDir;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setNotifications(SubmissionNotifications notifications) {
            this.notifications = notifications;
        }
    }

    @RequiresModule(name="cas-mgmt-config-delegated")
    public static class Delegated
    implements Serializable {
        private String userReposDir = "/etc/cas/user-repos";
        private boolean enabled;
        @NestedConfigurationProperty
        private DelegatedNotifications notifications = new DelegatedNotifications();

        @Generated
        public String getUserReposDir() {
            return this.userReposDir;
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public DelegatedNotifications getNotifications() {
            return this.notifications;
        }

        @Generated
        public void setUserReposDir(String userReposDir) {
            this.userReposDir = userReposDir;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setNotifications(DelegatedNotifications notifications) {
            this.notifications = notifications;
        }
    }

    @RequiresModule(name="cas-mgmt-config-version-control")
    public static class VersionControl
    implements Serializable {
        private String servicesRepo = "/etc/cas/services-repo";
        private String syncScript;
        private boolean enabled;

        @Generated
        public String getServicesRepo() {
            return this.servicesRepo;
        }

        @Generated
        public String getSyncScript() {
            return this.syncScript;
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public void setServicesRepo(String servicesRepo) {
            this.servicesRepo = servicesRepo;
        }

        @Generated
        public void setSyncScript(String syncScript) {
            this.syncScript = syncScript;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    @RequiresModule(name="cas-mgmt-config-ldap-authz")
    public static class Ldap
    extends AbstractLdapProperties {
        private static final long serialVersionUID = -8129280052479631538L;
        @NestedConfigurationProperty
        private LdapAuthorizationProperties ldapAuthz = new LdapAuthorizationProperties();

        @Generated
        public LdapAuthorizationProperties getLdapAuthz() {
            return this.ldapAuthz;
        }

        @Generated
        public void setLdapAuthz(LdapAuthorizationProperties ldapAuthz) {
            this.ldapAuthz = ldapAuthz;
        }
    }
}

