/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.junit;

import junit.framework.TestCase;
import org.apache.ws.jaxme.sqls.BooleanConstraint;
import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.ColumnReference;
import org.apache.ws.jaxme.sqls.CombinedConstraint;
import org.apache.ws.jaxme.sqls.DeleteStatement;
import org.apache.ws.jaxme.sqls.Function;
import org.apache.ws.jaxme.sqls.JoinReference;
import org.apache.ws.jaxme.sqls.Schema;
import org.apache.ws.jaxme.sqls.SelectStatement;
import org.apache.ws.jaxme.sqls.SelectTableReference;
import org.apache.ws.jaxme.sqls.Table;
import org.apache.ws.jaxme.sqls.TableReference;
import org.apache.ws.jaxme.sqls.impl.VirtualColumn;
import org.apache.ws.jaxme.sqls.oracle.OraColumnReference;
import org.apache.ws.jaxme.sqls.oracle.OraSQLFactory;
import org.apache.ws.jaxme.sqls.oracle.OraSQLFactoryImpl;
import org.apache.ws.jaxme.sqls.oracle.OraSQLGenerator;
import org.apache.ws.jaxme.sqls.oracle.OraSelectStatement;

public class JoinTest
extends TestCase {
    private OraSQLFactory sqlFactory;
    private OraSQLGenerator sqlGenerator;
    private Schema schema;
    private Table dbAkte;
    private Table dbBeteiligte;
    private Table dbAktenzeichen;
    private Table kettenElement;
    private Table vertreterKette;

    public JoinTest(String pName) {
        super(pName);
    }

    public void setUp() {
        this.sqlFactory = new OraSQLFactoryImpl();
        this.sqlGenerator = (OraSQLGenerator)this.sqlFactory.newSQLGenerator();
        this.sqlGenerator.setOracle8Compatibility(true);
        this.schema = this.sqlFactory.getDefaultSchema();
        this.dbAkte = this.schema.newTable("DBAkte");
        this.dbAkte.newColumn("aId", Column.Type.BIGINT);
        this.dbBeteiligte = this.schema.newTable("DBBeteiligte");
        this.dbBeteiligte.newColumn("aAktenId", Column.Type.BIGINT);
        this.dbBeteiligte.newColumn("aFilter", Column.Type.BIGINT);
        this.dbBeteiligte.newColumn("aName", Column.Type.VARCHAR);
        this.dbBeteiligte.newColumn("aVorname", Column.Type.VARCHAR);
        this.dbBeteiligte.newColumn("aId", Column.Type.BIGINT);
        this.dbAktenzeichen = this.schema.newTable("DBAktenzeichen");
        this.dbAktenzeichen.newColumn("aAktenId", Column.Type.BIGINT);
        this.dbAktenzeichen.newColumn("aFilter", Column.Type.VARCHAR);
        this.dbAktenzeichen.newColumn("aId", Column.Type.BIGINT);
        this.kettenElement = this.schema.newTable("KettenElement");
        this.kettenElement.newColumn("aId", Column.Type.BIGINT);
        this.kettenElement.newColumn("aVertreterId", Column.Type.BIGINT);
        this.kettenElement.newColumn("organisationsId", Column.Type.BIGINT);
        this.vertreterKette = this.schema.newTable("VertreterKette");
        this.vertreterKette.newColumn("wurzelElement", Column.Type.BIGINT);
    }

    private void addAktenId(CombinedConstraint pWhere, TableReference pAkteReference, TableReference pBeteiligteReference) {
        BooleanConstraint bc = pWhere.createEQ();
        bc.addPart(pBeteiligteReference.newColumnReference(this.dbBeteiligte.getColumn("aAktenId")));
        bc.addPart(pAkteReference.newColumnReference(this.dbAkte.getColumn("aId")));
    }

    private void addEQ(TableReference pTableReference, CombinedConstraint pWhere, Column pColumn, String pValue) {
        BooleanConstraint bc = pWhere.createEQ();
        bc.addPart(pTableReference.newColumnReference(pColumn));
        bc.addPart(pValue);
    }

    private ColumnReference getCountStatement(String pColumnName, String pFilter, TableReference pAkteReference, String pTableAlias) {
        SelectStatement st = this.sqlFactory.newSelectStatement();
        st.setTable(this.dbBeteiligte);
        SelectTableReference tRef = st.getSelectTableReference();
        tRef.setAlias(pTableAlias);
        this.addEQ(tRef, st.getWhere(), this.dbBeteiligte.getColumn("aFilter"), pFilter);
        this.addAktenId(st.getWhere(), pAkteReference, tRef);
        VirtualColumn vc = new VirtualColumn(pColumnName, Column.Type.INTEGER);
        vc.setValue("COUNT(*)");
        st.addResultColumn(vc);
        VirtualColumn result = new VirtualColumn(pColumnName, Column.Type.INTEGER);
        result.setValue(st);
        return result;
    }

    private JoinReference getFirstRowStatement2(String pFilter, TableReference pAkteReference, SelectTableReference pJoinReference, String pTableAlias) {
        Column aName = this.dbBeteiligte.getColumn("aName");
        Column aVorname = this.dbBeteiligte.getColumn("aVorname");
        Column aAktenId = this.dbBeteiligte.getColumn("aAktenId");
        Column aFilter = this.dbBeteiligte.getColumn("aFilter");
        SelectStatement st = this.sqlFactory.newSelectStatement();
        st.setTable(this.dbBeteiligte);
        SelectTableReference ref = st.getSelectTableReference();
        VirtualColumn num = new VirtualColumn("NUM", Column.Type.INTEGER);
        num.setValue("COUNT(*) OVER (PARTITION BY " + aAktenId.getName() + ")");
        st.addResultColumn(num);
        VirtualColumn minAName = new VirtualColumn("MINANAME", Column.Type.VARCHAR);
        minAName.setValue("MIN(UPPER(" + aName.getName() + ")) OVER (PARTITION BY " + aAktenId.getName() + ")");
        st.addResultColumn(minAName);
        VirtualColumn minAVorname = new VirtualColumn("MINAVORNAME", Column.Type.VARCHAR);
        minAVorname.setValue("MIN(UPPER(NVL(" + aVorname.getName() + ", ' '))) OVER (PARTITION BY " + aAktenId.getName() + ", UPPER(" + aName.getName() + "))");
        st.addResultColumn(minAVorname);
        st.addResultColumn(ref.newColumnReference(aName));
        st.addResultColumn(ref.newColumnReference(aVorname));
        st.addResultColumn(ref.newColumnReference(aAktenId));
        BooleanConstraint bc = st.getWhere().createEQ();
        bc.addPart(st.getTableReference().newColumnReference(aFilter));
        bc.addPart(pFilter);
        Table t = st.createView((Table.Name)null);
        SelectStatement st2 = this.sqlFactory.newSelectStatement();
        st2.setTable(t);
        SelectTableReference ref2 = st2.getSelectTableReference();
        st2.addResultColumn(ref2.newColumnReference(t.getColumn("NUM")));
        Column aName2 = t.getColumn(aName.getName());
        st2.addResultColumn(ref2.newColumnReference(aName2));
        Column aVorname2 = t.getColumn(aVorname.getName());
        st2.addResultColumn(ref2.newColumnReference(aVorname2));
        st2.addResultColumn(ref2.newColumnReference(t.getColumn(aAktenId.getName())));
        bc = st2.getWhere().createEQ();
        bc.addPart(ref2.newColumnReference(t.getColumn("MINAVORNAME")));
        Function f = st2.createFunction("MIN");
        Function f2 = st.createFunction("UPPER");
        Function f3 = st.createFunction("NVL");
        f3.addPart(ref2.newColumnReference(aVorname2));
        f3.addPart(" ");
        f2.addPart(f3);
        bc.addPart(f);
        bc = st2.getWhere().createEQ();
        bc.addPart(ref2.newColumnReference(t.getColumn("MINANAME")));
        f = st2.createFunction("MIN");
        f2 = st.createFunction("UPPER");
        f2.addPart(ref2.newColumnReference(aName2));
        f.addPart(f2);
        bc.addPart(f);
        Table t2 = st2.createView(pTableAlias);
        JoinReference result = pJoinReference.leftOuterJoin(t2);
        bc = result.getOn().createEQ();
        bc.addPart(pAkteReference.newColumnReference(this.dbAkte.getColumn("aId")));
        bc.addPart(result.newColumnReference(t2.getColumn(aAktenId.getName())));
        return result;
    }

    private JoinReference getFirstRowStatement(String pFilter, TableReference pAkteReference, SelectTableReference pJoinReference, String pTableAlias) {
        JoinReference result = pJoinReference.leftOuterJoin(this.dbBeteiligte);
        result.setAlias(pTableAlias);
        this.addAktenId(result.getOn(), pAkteReference, result);
        this.addEQ(result, result.getOn(), this.dbBeteiligte.getColumn("aFilter"), pFilter);
        BooleanConstraint bc = result.getOn().createEQ();
        Function f = pAkteReference.getStatement().createFunction("UPPER");
        f.addPart(result.newColumnReference(this.dbBeteiligte.getColumn("aName")));
        bc.addPart(f);
        SelectStatement minStatement = this.sqlFactory.newSelectStatement();
        minStatement.setTable(this.dbBeteiligte);
        SelectTableReference minTableRef = minStatement.getSelectTableReference();
        minTableRef.setAlias(pTableAlias + "min");
        BooleanConstraint bc2 = minStatement.getWhere().createEQ();
        bc2.addPart(result.newColumnReference(this.dbBeteiligte.getColumn("aAktenId")));
        bc2.addPart(minTableRef.newColumnReference(this.dbBeteiligte.getColumn("aAktenId")));
        bc2 = minStatement.getWhere().createEQ();
        bc2.addPart(minTableRef.newColumnReference(this.dbBeteiligte.getColumn("aFilter")));
        bc2.addPart(pFilter);
        f = pAkteReference.getStatement().createFunction("MIN");
        Function f2 = pAkteReference.getStatement().createFunction("UPPER");
        f.addPart(f2);
        f2.addPart(minTableRef.newColumnReference(this.dbBeteiligte.getColumn("aName")));
        VirtualColumn vc = new VirtualColumn("MIN", Column.Type.VARCHAR);
        vc.setValue(f);
        minStatement.addResultColumn(vc);
        bc.addPart(minStatement);
        return result;
    }

    private SelectStatement newStatement(boolean pUseView) {
        JoinReference be;
        SelectStatement st = this.sqlFactory.newSelectStatement();
        st.setTable(this.dbAkte);
        SelectTableReference akte = st.getSelectTableReference();
        akte.setAlias("a");
        JoinReference az = akte.join(this.dbAktenzeichen);
        az.setAlias("az");
        CombinedConstraint onClause = az.getOn();
        BooleanConstraint bc = onClause.createEQ();
        bc.addPart(akte.newColumnReference(this.dbAkte.getColumn("aId")));
        bc.addPart(az.newColumnReference(this.dbAktenzeichen.getColumn("aAktenId")));
        bc = onClause.createEQ();
        bc.addPart(az.newColumnReference(this.dbAktenzeichen.getColumn("aFilter")));
        bc.addPart("Hauptverfahren");
        if (pUseView) {
            JoinReference kl = this.getFirstRowStatement2("Klaeger", akte, az, "kl");
            be = this.getFirstRowStatement2("Beklagter", akte, kl, "be");
        } else {
            JoinReference kl = this.getFirstRowStatement("Klaeger", akte, az, "kl");
            be = this.getFirstRowStatement("Beklagter", akte, kl, "be");
            st.addResultColumn(this.getCountStatement("anzahlKlaeger", "Klaeger", akte, "klc"));
            st.addResultColumn(this.getCountStatement("anzahlBeklagte", "Beklagter", akte, "bec"));
        }
        JoinReference ber = be.leftOuterJoin(this.dbBeteiligte);
        ber.setAlias("ber");
        this.addAktenId(ber.getOn(), akte, ber);
        this.addEQ(ber, ber.getOn(), this.dbBeteiligte.getColumn("aFilter"), "Beklagter");
        return st;
    }

    public void testCreate1() {
        SelectStatement st = this.newStatement(false);
        String got = this.sqlGenerator.getQuery(st);
        String expect = "SELECT (SELECT COUNT(*) AS anzahlKlaeger FROM DBBeteiligte klc WHERE (klc.aFilter='Klaeger' AND klc.aAktenId=a.aId)) AS anzahlKlaeger, (SELECT COUNT(*) AS anzahlBeklagte FROM DBBeteiligte bec WHERE (bec.aFilter='Beklagter' AND bec.aAktenId=a.aId)) AS anzahlBeklagte FROM DBAkte a, DBAktenzeichen az, DBBeteiligte kl, DBBeteiligte be, DBBeteiligte ber WHERE (a.aId=az.aAktenId AND az.aFilter='Hauptverfahren') AND (kl.aAktenId(+)=a.aId AND kl.aFilter(+)='Klaeger' AND UPPER(kl.aName(+))=(SELECT MIN(UPPER(klmin.aName)) AS MIN FROM DBBeteiligte klmin WHERE (kl.aAktenId(+)=klmin.aAktenId AND klmin.aFilter='Klaeger'))) AND (be.aAktenId(+)=a.aId AND be.aFilter(+)='Beklagter' AND UPPER(be.aName(+))=(SELECT MIN(UPPER(bemin.aName)) AS MIN FROM DBBeteiligte bemin WHERE (be.aAktenId(+)=bemin.aAktenId AND bemin.aFilter='Beklagter'))) AND (ber.aAktenId(+)=a.aId AND ber.aFilter(+)='Beklagter')";
        JoinTest.assertEquals((String)expect, (String)got);
    }

    public void testCreate2() {
        SelectStatement st = this.newStatement(true);
        String got = this.sqlGenerator.getQuery(st);
        String expect = "SELECT * FROM DBAkte a, DBAktenzeichen az, (SELECT DBBeteiligte.NUM, DBBeteiligte.aName, DBBeteiligte.aVorname, DBBeteiligte.aAktenId FROM (SELECT COUNT(*) OVER (PARTITION BY aAktenId) AS NUM, MIN(UPPER(aName)) OVER (PARTITION BY aAktenId) AS MINANAME, MIN(UPPER(NVL(aVorname, ' '))) OVER (PARTITION BY aAktenId, UPPER(aName)) AS MINAVORNAME, DBBeteiligte0.aName, DBBeteiligte0.aVorname, DBBeteiligte0.aAktenId FROM DBBeteiligte DBBeteiligte0 WHERE DBBeteiligte0.aFilter='Klaeger') WHERE (DBBeteiligte.MINAVORNAME=MIN() AND DBBeteiligte.MINANAME=MIN(UPPER(DBBeteiligte.aName)))), (SELECT DBBeteiligte1.NUM, DBBeteiligte1.aName, DBBeteiligte1.aVorname, DBBeteiligte1.aAktenId FROM (SELECT COUNT(*) OVER (PARTITION BY aAktenId) AS NUM, MIN(UPPER(aName)) OVER (PARTITION BY aAktenId) AS MINANAME, MIN(UPPER(NVL(aVorname, ' '))) OVER (PARTITION BY aAktenId, UPPER(aName)) AS MINAVORNAME, DBBeteiligte2.aName, DBBeteiligte2.aVorname, DBBeteiligte2.aAktenId FROM DBBeteiligte DBBeteiligte2 WHERE DBBeteiligte2.aFilter='Beklagter') DBBeteiligte1 WHERE (DBBeteiligte1.MINAVORNAME=MIN() AND DBBeteiligte1.MINANAME=MIN(UPPER(DBBeteiligte1.aName)))), DBBeteiligte ber WHERE (a.aId=az.aAktenId AND az.aFilter='Hauptverfahren') AND a.aId=kl.aAktenId(+) AND a.aId=be.aAktenId(+) AND (ber.aAktenId(+)=a.aId AND ber.aFilter(+)='Beklagter')";
        JoinTest.assertEquals((String)expect, (String)got);
    }

    private void addEQ(TableReference pRef1, TableReference pRef2, CombinedConstraint pConstraint, Column pCol1, Column pCol2) {
        BooleanConstraint bc = pConstraint.createEQ();
        bc.addPart(pRef1.newColumnReference(pCol1));
        bc.addPart(pRef2.newColumnReference(pCol2));
    }

    private void addEQ(TableReference pRef1, CombinedConstraint pConstraint, Column pCol1) {
        BooleanConstraint bc = pConstraint.createEQ();
        bc.addPart(pRef1.newColumnReference(pCol1));
        bc.addPlaceholder();
    }

    private SelectStatement getSelectAidByOrganisationsId() {
        SelectStatement stmt = this.sqlFactory.newSelectStatement();
        stmt.setTable(this.kettenElement);
        SelectTableReference kettenElementRef = stmt.getSelectTableReference();
        JoinReference vertreterKetteRef = kettenElementRef.join(this.vertreterKette);
        this.addEQ(kettenElementRef, vertreterKetteRef, vertreterKetteRef.getOn(), this.kettenElement.getColumn("aId"), this.vertreterKette.getColumn("wurzelElement"));
        this.addEQ(kettenElementRef, stmt.getWhere(), this.kettenElement.getColumn("organisationsId"));
        stmt.addResultColumn(kettenElementRef.newColumnReference(this.kettenElement.getColumn("aId")));
        return stmt;
    }

    private SelectStatement getSelectAllChildsByOrganisationsId() {
        OraSelectStatement stmt = (OraSelectStatement)this.sqlFactory.newSelectStatement();
        stmt.setTable(this.kettenElement);
        TableReference tRef = stmt.getTableReference();
        BooleanConstraint in = stmt.getStartWith().createIN();
        in.addPart(tRef.newColumnReference(this.kettenElement.getColumn("aId")));
        in.addPart(this.getSelectAidByOrganisationsId());
        BooleanConstraint bc = stmt.getConnectBy().createEQ();
        OraColumnReference ref1 = (OraColumnReference)tRef.newColumnReference(this.kettenElement.getColumn("aId"));
        ref1.setPrior(true);
        bc.addPart(ref1);
        bc.addPart(tRef.newColumnReference(this.kettenElement.getColumn("aVertreterId")));
        return stmt;
    }

    private DeleteStatement getDeleteAllChildsByOrganisationsId() {
        DeleteStatement dstmt = this.sqlFactory.newDeleteStatement();
        dstmt.setTable(this.kettenElement);
        TableReference tRef = dstmt.getTableReference();
        CombinedConstraint whereClause = dstmt.getWhere();
        BooleanConstraint bc = whereClause.createIN();
        bc.addPart(tRef.newColumnReference(this.kettenElement.getColumn("aId")));
        bc.addPart(this.getSelectAllChildsByOrganisationsId());
        return dstmt;
    }

    public void testDelete1() {
        DeleteStatement ds = this.getDeleteAllChildsByOrganisationsId();
        String expect = "DELETE FROM KettenElement WHERE KettenElement.aId IN ((SELECT * FROM KettenElement KettenElement0 START WITH KettenElement0.aId IN ((SELECT KettenElement1.aId FROM KettenElement KettenElement1, VertreterKette WHERE KettenElement1.aId=wurzelElement AND KettenElement1.organisationsId=?)) CONNECT BY PRIOR KettenElement0.aId=KettenElement0.aVertreterId))";
        String got = this.sqlGenerator.getQuery(ds);
        JoinTest.assertEquals((String)expect, (String)got);
    }
}

