/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.impl;

import org.apache.ws.jaxme.sqls.Value;

public class ValueImpl
implements Value {
    private final Value.Type type;
    private final Object value;

    public ValueImpl(Value pValue) {
        this(pValue.getType(), pValue.getValue());
    }

    public ValueImpl(Value.Type pType, Object pValue) {
        if (pType == null) {
            throw new NullPointerException("The value type must not be null.");
        }
        if ((pType.equals(Value.Type.PLACEHOLDER) || pType.equals(Value.Type.NULL)) && pValue != null) {
            throw new IllegalArgumentException("The value argument must be null for the type " + pType + ".");
        }
        this.type = pType;
        this.value = pValue;
    }

    public Value.Type getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        if (this.value != null) {
            result = this.value.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Value)) {
            return false;
        }
        Value v = (Value)o;
        if (!this.type.equals(v.getType())) {
            return false;
        }
        if (this.value == null) {
            return v.getValue() == null;
        }
        return this.value.equals(v.getValue());
    }

    public static Object asValue(Object pValue) {
        if (pValue == null) {
            return new ValueImpl(Value.Type.NULL, pValue);
        }
        if (pValue instanceof String) {
            return new ValueImpl(Value.Type.STRING, pValue);
        }
        if (pValue instanceof Boolean) {
            return new ValueImpl(Value.Type.BOOLEAN, pValue);
        }
        if (pValue instanceof Byte) {
            return new ValueImpl(Value.Type.BYTE, pValue);
        }
        if (pValue instanceof Short) {
            return new ValueImpl(Value.Type.SHORT, pValue);
        }
        if (pValue instanceof Integer) {
            return new ValueImpl(Value.Type.INT, pValue);
        }
        if (pValue instanceof Long) {
            return new ValueImpl(Value.Type.LONG, pValue);
        }
        if (pValue instanceof Float) {
            return new ValueImpl(Value.Type.FLOAT, pValue);
        }
        if (pValue instanceof Double) {
            return new ValueImpl(Value.Type.DOUBLE, pValue);
        }
        return pValue;
    }
}

