/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.db2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ws.jaxme.sqls.db2.BufferPool;
import org.apache.ws.jaxme.sqls.db2.DB2SQLFactory;
import org.apache.ws.jaxme.sqls.db2.PageSize;
import org.apache.ws.jaxme.sqls.db2.TableSpace;
import org.apache.ws.jaxme.sqls.impl.SQLFactoryImpl;

public class TableSpaceImpl
implements TableSpace {
    private DB2SQLFactory sqlFactory;
    private BufferPool bufferPool;
    private TableSpace.Name name;
    private TableSpace.Type type;
    private List containers = new ArrayList();
    private Long extentSize;
    private Long prefetchSize;
    private PageSize pageSize;
    private Number overhead;
    private Number transferRate;
    private Boolean droppedTableRecovery;

    protected TableSpaceImpl(DB2SQLFactory pFactory, TableSpace.Name pName, TableSpace.Type pType) {
        this.sqlFactory = pFactory;
        this.name = pName;
        this.type = pType;
    }

    public DB2SQLFactory getSQLFactory() {
        return this.sqlFactory;
    }

    public TableSpace.Name getName() {
        return this.name;
    }

    public TableSpace.Type getType() {
        return this.type;
    }

    public PageSize getPageSize() {
        BufferPool bPool = this.getBufferPool();
        return bPool == null ? this.pageSize : bPool.getPageSize();
    }

    public void setPageSize(PageSize pSize) {
        this.pageSize = pSize;
    }

    public Long getExtentSize() {
        return this.extentSize;
    }

    public void setExtentSize(Long pSize) {
        this.extentSize = pSize;
    }

    public Long getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchSize(Long pSize) {
        this.prefetchSize = pSize;
    }

    public Number getOverhead() {
        return this.overhead;
    }

    public void setOverhead(Number pOverhead) {
        this.overhead = pOverhead;
    }

    public Number getTransferRate() {
        return this.transferRate;
    }

    public void setTransferRate(Number pTransferRate) {
        this.transferRate = pTransferRate;
    }

    public Boolean hasDroppedTableRecovery() {
        return this.droppedTableRecovery;
    }

    public void setDroppedTableRecovery(Boolean pRecoverable) {
        this.droppedTableRecovery = pRecoverable;
    }

    public boolean isPredefined() {
        return false;
    }

    public TableSpace.Container newSystemManagedContainer(String pFile) {
        SystemManagedContainerImpl container = new SystemManagedContainerImpl();
        container.setFile(pFile);
        this.containers.add(container);
        return container;
    }

    public TableSpace.Container newDatabaseManagedContainerInFile(String pFile, long pNumPages) {
        DatabaseManagedContainerImpl container = new DatabaseManagedContainerImpl();
        container.setFile(pFile);
        container.setNumOfPages(pNumPages);
        this.containers.add(container);
        return container;
    }

    public TableSpace.Container newDatabaseManagedContainerInDevice(String pDevice, long pNumPages) {
        DatabaseManagedContainerImpl container = new DatabaseManagedContainerImpl();
        container.setDevice(pDevice);
        container.setNumOfPages(pNumPages);
        this.containers.add(container);
        return container;
    }

    public Iterator getContainers() {
        return this.containers.iterator();
    }

    public void setBufferPool(BufferPool pBufferPool) {
        this.bufferPool = pBufferPool;
    }

    public BufferPool getBufferPool() {
        return this.bufferPool;
    }

    public static class DatabaseManagedContainerImpl
    implements TableSpace.DatabaseManagedContainer {
        private String file;
        private String device;
        private long numPages;

        public boolean isSystemManaged() {
            return false;
        }

        public boolean isDatabaseManaged() {
            return true;
        }

        public void setFile(String pFile) {
            this.file = pFile;
        }

        public String getFile() {
            return this.file;
        }

        public void setDevice(String pDevice) {
            this.device = pDevice;
        }

        public String getDevice() {
            return this.device;
        }

        public long getNumOfPages() {
            return this.numPages;
        }

        public void setNumOfPages(long pNumOfPages) {
            this.numPages = pNumOfPages;
        }
    }

    public static class SystemManagedContainerImpl
    implements TableSpace.SystemManagedContainer {
        private String file;

        public boolean isSystemManaged() {
            return true;
        }

        public boolean isDatabaseManaged() {
            return false;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String pFile) {
            this.file = pFile;
        }
    }

    public static class NameImpl
    extends SQLFactoryImpl.IdentImpl
    implements TableSpace.Name {
        public NameImpl(String pName) {
            super(pName);
        }
    }
}

