/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.db2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.Schema;
import org.apache.ws.jaxme.sqls.Table;
import org.apache.ws.jaxme.sqls.db2.BufferPool;
import org.apache.ws.jaxme.sqls.db2.DB2Column;
import org.apache.ws.jaxme.sqls.db2.DB2SQLGenerator;
import org.apache.ws.jaxme.sqls.db2.DB2Table;
import org.apache.ws.jaxme.sqls.db2.PageSize;
import org.apache.ws.jaxme.sqls.db2.TableSpace;
import org.apache.ws.jaxme.sqls.impl.SQLGeneratorImpl;

public class DB2SQLGeneratorImpl
extends SQLGeneratorImpl
implements DB2SQLGenerator {
    private boolean isCreatingTableSpaceReferences = true;

    protected boolean isPrimaryKeyPartOfCreateTable() {
        return true;
    }

    protected boolean isUniqueIndexPartOfCreateTable() {
        return true;
    }

    protected boolean isForeignKeyPartOfCreateTable() {
        return true;
    }

    public void setCreatingTableSpaceReferences(boolean pCreatingTableSpaceReferences) {
        this.isCreatingTableSpaceReferences = pCreatingTableSpaceReferences;
    }

    public boolean isCreatingTableSpaceReferences() {
        return this.isCreatingTableSpaceReferences;
    }

    protected String getTypeName(Column.Type pType) {
        if (pType.equals(Column.Type.BINARY) || pType.equals(Column.Type.VARBINARY)) {
            return "BLOB";
        }
        return super.getTypeName(pType);
    }

    public Collection getCreate(BufferPool pBufferPool) {
        Boolean extendedStorage;
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE BUFFERPOOL ").append(pBufferPool.getName()).append(" SIZE ");
        sb.append(pBufferPool.getNumberOfPages());
        PageSize pageSize = pBufferPool.getPageSize();
        if (pageSize != null) {
            sb.append(" PAGESIZE ").append(pageSize.getSize());
        }
        if ((extendedStorage = pBufferPool.getExtendedStorage()) != null) {
            if (extendedStorage.booleanValue()) {
                sb.append(" EXTENDED STORAGE");
            } else {
                sb.append(" NOT EXTENDED STORAGE");
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.newStatement(sb.toString()));
        return result;
    }

    public Collection getDrop(BufferPool pBufferPool) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.newStatement("DROP BUFFERPOOL " + pBufferPool.getName()));
        return result;
    }

    public Collection getCreate(TableSpace pTableSpace) {
        Boolean hasDroppedTableRecovery;
        Number transferRate;
        Number overhead;
        Long prefetchSize;
        Iterator iter;
        PageSize pageSize;
        if (pTableSpace.isPredefined()) {
            return Collections.EMPTY_SET;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE TABLESPACE ");
        TableSpace.Type type = pTableSpace.getType();
        if (type != null) {
            sb.append(type).append(" ");
        }
        sb.append(pTableSpace.getName().getName());
        BufferPool bufferPool = pTableSpace.getBufferPool();
        PageSize pageSize2 = pageSize = bufferPool == null ? pTableSpace.getPageSize() : bufferPool.getPageSize();
        if (pageSize != null) {
            sb.append(" PAGESIZE ").append(pageSize);
        }
        if (!(iter = pTableSpace.getContainers()).hasNext()) {
            throw new IllegalStateException("The TableSpace " + pTableSpace.getName() + " doesn't have any containers.");
        }
        TableSpace.Container container = (TableSpace.Container)iter.next();
        String sep = "(";
        if (container.isSystemManaged()) {
            sb.append(" MANAGED BY SYSTEM USING ");
            while (container != null) {
                if (!container.isSystemManaged()) {
                    throw new IllegalStateException("A TableSpace must not mix system and database managed containers.");
                }
                TableSpace.SystemManagedContainer systemContainer = (TableSpace.SystemManagedContainer)container;
                sb.append(sep);
                sep = ", ";
                sb.append("'").append(systemContainer.getFile()).append("'");
                container = iter.hasNext() ? (TableSpace.Container)iter.next() : null;
            }
        } else {
            sb.append(" MANAGED BY DATABASE USING (");
            while (container != null) {
                if (!container.isDatabaseManaged()) {
                    throw new IllegalStateException("A TableSpace must not mix system and database managed containers.");
                }
                TableSpace.DatabaseManagedContainer databaseContainer = (TableSpace.DatabaseManagedContainer)container;
                sb.append(sep);
                sep = ", ";
                if (databaseContainer.getFile() != null) {
                    sb.append("FILE '").append(databaseContainer.getFile()).append("'");
                } else {
                    sb.append("DEVICE '").append(databaseContainer.getDevice()).append("'");
                }
                container = iter.hasNext() ? (TableSpace.Container)iter.next() : null;
            }
        }
        sb.append(")");
        Long extentSize = pTableSpace.getExtentSize();
        if (extentSize != null) {
            sb.append(" EXTENTSIZE ").append(extentSize);
        }
        if ((prefetchSize = pTableSpace.getPrefetchSize()) != null) {
            sb.append(" PREFETCHSIZE ").append(prefetchSize);
        }
        if (bufferPool != null) {
            sb.append(" BUFFERPOOL ").append(bufferPool.getName().getName());
        }
        if ((overhead = pTableSpace.getOverhead()) != null) {
            sb.append(" OVERHEAD ").append(overhead);
        }
        if ((transferRate = pTableSpace.getTransferRate()) != null) {
            sb.append(" TRANSFERRATE ").append(transferRate);
        }
        if ((hasDroppedTableRecovery = pTableSpace.hasDroppedTableRecovery()) != null) {
            sb.append(" DROPPED TABLE RECOVERY ");
            sb.append(hasDroppedTableRecovery != false ? "ON" : "OFF");
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.newStatement(sb.toString()));
        return result;
    }

    public Collection getDrop(TableSpace pTableSpace) {
        if (pTableSpace.isPredefined()) {
            return Collections.EMPTY_SET;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.newStatement("DROP TABLESPACE " + pTableSpace.getName()));
        return result;
    }

    protected String getCreateTableHeader(Table pTable) {
        String statement = super.getCreateTableHeader(pTable);
        if (!this.isCreatingTableSpaceReferences() || !(pTable instanceof DB2Table)) {
            return statement;
        }
        StringBuffer sb = new StringBuffer(statement);
        DB2Table table = (DB2Table)pTable;
        TableSpace tableSpace = table.getTableSpace();
        if (tableSpace != null) {
            sb.append(" IN ").append(tableSpace.getName());
        }
        if ((tableSpace = table.getIndexTableSpace()) != null) {
            sb.append(" INDEX IN ").append(tableSpace.getName());
        }
        if ((tableSpace = table.getLongTableSpace()) != null) {
            sb.append(" LONG IN ").append(tableSpace.getName());
        }
        return sb.toString();
    }

    protected String getCreate(Column pColumn) {
        DB2Column db2Column;
        String result = super.getCreate(pColumn);
        if (pColumn instanceof DB2Column && (db2Column = (DB2Column)pColumn).getGeneratedAs() != null) {
            result = result + " GENERATED ALWAYS AS (" + db2Column.getGeneratedAs() + ")";
        }
        return result;
    }

    public Collection getDrop(Schema pSchema) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator iter = super.getDrop(pSchema).iterator();
        while (iter.hasNext()) {
            String s = (String)iter.next();
            if (s.startsWith("DROP SCHEMA ")) {
                s = s + " RESTRICT";
            }
            result.add(s);
        }
        return result;
    }
}

