/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.builder;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.builder.BuilderAwareReader;
import org.apache.axiom.om.impl.util.OMSerializerUtil;

public abstract class StAXBuilder
implements OMXMLParserWrapper {
    protected XMLStreamReader parser;
    protected OMFactory omfactory;
    protected OMNode lastNode;
    protected boolean done = false;
    protected boolean cache = true;
    protected boolean parserAccessed = false;
    protected OMDocument document;
    protected boolean isDataHandlerAware = false;

    protected StAXBuilder(OMFactory ombuilderFactory, XMLStreamReader parser) {
        this.parser = parser;
        this.omfactory = ombuilderFactory;
        try {
            if (parser != null && Boolean.TRUE == parser.getProperty("IsDatahandlersAwareParsing")) {
                this.isDataHandlerAware = true;
            }
        }
        catch (IllegalArgumentException e) {
            this.isDataHandlerAware = false;
        }
        if (parser instanceof BuilderAwareReader) {
            ((BuilderAwareReader)((Object)parser)).setBuilder(this);
        }
    }

    protected StAXBuilder(XMLStreamReader parser) {
        this(OMAbstractFactory.getOMFactory(), parser);
    }

    public void setOMBuilderFactory(OMFactory ombuilderFactory) {
        this.omfactory = ombuilderFactory;
    }

    protected abstract void processNamespaceData(OMElement var1);

    protected void processAttributes(OMElement node) {
        int attribCount = this.parser.getAttributeCount();
        for (int i = 0; i < attribCount; ++i) {
            String uri = this.parser.getAttributeNamespace(i);
            String prefix = this.parser.getAttributePrefix(i);
            OMNamespace namespace = null;
            if (uri != null && uri.length() > 0 && (namespace = node.findNamespace(uri, prefix)) == null) {
                if (prefix == null || "".equals(prefix)) {
                    prefix = OMSerializerUtil.getNextNSPrefix();
                }
                namespace = node.declareNamespace(uri, prefix);
            }
            node.addAttribute(this.parser.getAttributeLocalName(i), this.parser.getAttributeValue(i), namespace);
        }
    }

    protected OMNode createOMText(int textType) throws OMException {
        if (this.lastNode == null) {
            return null;
        }
        OMNode node = !this.lastNode.isComplete() ? this.createOMText((OMElement)this.lastNode, textType) : this.createOMText(this.lastNode.getParent(), textType);
        return node;
    }

    private OMNode createOMText(OMContainer omContainer, int textType) {
        try {
            if (this.isDataHandlerAware && Boolean.TRUE == this.parser.getProperty("Axiom.IsBinary")) {
                Object dataHandler = this.parser.getProperty("Axiom.DataHandler");
                OMText text = this.omfactory.createOMText(dataHandler, true);
                omContainer.addChild(text);
                return text;
            }
            return this.omfactory.createOMText(omContainer, this.parser.getText(), textType);
        }
        catch (IllegalArgumentException e) {
            return this.omfactory.createOMText(omContainer, this.parser.getText(), textType);
        }
    }

    public void reset(OMNode node) throws OMException {
        this.lastNode = null;
    }

    public void discard(OMElement el) throws OMException {
        OMNode element = null;
        if (element.isComplete() || !this.cache) {
            throw new OMException();
        }
        try {
            this.cache = false;
            while (this.parser.next() != 2 || !this.parser.getName().equals(element.getQName())) {
            }
            this.lastNode = element.getPreviousOMSibling();
            if (this.lastNode != null) {
                ((OMNodeEx)this.lastNode).setNextOMSibling(null);
            } else {
                OMElement parent = (OMElement)element.getParent();
                if (parent == null) {
                    throw new OMException();
                }
                parent.setFirstChild(null);
                this.lastNode = parent;
            }
            this.cache = true;
        }
        catch (OMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OMException(e);
        }
    }

    public String getText() throws OMException {
        return this.parser.getText();
    }

    public String getNamespace() throws OMException {
        return this.parser.getNamespaceURI();
    }

    public int getNamespaceCount() throws OMException {
        try {
            return this.parser.getNamespaceCount();
        }
        catch (Exception e) {
            throw new OMException(e);
        }
    }

    public String getNamespacePrefix(int index) throws OMException {
        try {
            return this.parser.getNamespacePrefix(index);
        }
        catch (Exception e) {
            throw new OMException(e);
        }
    }

    public String getNamespaceUri(int index) throws OMException {
        try {
            return this.parser.getNamespaceURI(index);
        }
        catch (Exception e) {
            throw new OMException(e);
        }
    }

    public void setCache(boolean b) {
        if (this.parserAccessed && b) {
            throw new UnsupportedOperationException("parser accessed. cannot set cache");
        }
        this.cache = b;
    }

    public String getName() throws OMException {
        return this.parser.getLocalName();
    }

    public String getPrefix() throws OMException {
        return this.parser.getPrefix();
    }

    public int getAttributeCount() throws OMException {
        return this.parser.getAttributeCount();
    }

    public String getAttributeNamespace(int arg) throws OMException {
        return this.parser.getAttributeNamespace(arg);
    }

    public String getAttributeName(int arg) throws OMException {
        return this.parser.getAttributeNamespace(arg);
    }

    public String getAttributePrefix(int arg) throws OMException {
        return this.parser.getAttributeNamespace(arg);
    }

    public Object getParser() {
        if (this.parserAccessed) {
            throw new IllegalStateException("Parser already accessed!");
        }
        if (!this.cache) {
            this.parserAccessed = true;
            return this.parser;
        }
        throw new IllegalStateException("cache must be switched off to access the parser");
    }

    public boolean isCompleted() {
        return this.done;
    }

    protected abstract OMNode createOMElement() throws OMException;

    public abstract int next() throws OMException;

    public short getBuilderType() {
        return 1;
    }

    public void registerExternalContentHandler(Object obj) {
        throw new UnsupportedOperationException();
    }

    public Object getRegisteredContentHandler() {
        throw new UnsupportedOperationException();
    }

    public OMDocument getDocument() {
        return this.document;
    }

    public OMNode getLastNode() {
        return this.lastNode;
    }

    public void close() {
        try {
            this.parser.close();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }
}

