/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.test.mock;

import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import org.apache.wink.test.mock.MockHttpServletRequestWrapper;
import org.springframework.mock.web.MockHttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MockRequestConstructor {
    private MockRequestConstructor() {
    }

    public static MockHttpServletRequest constructMockRequest(String method, String requestURI, MediaType mediaType) {
        return MockRequestConstructor.constructMockRequest(method, requestURI, mediaType.toString());
    }

    public static MockHttpServletRequest constructMockRequest(String method, String requestURI, String acceptHeader) {
        MockHttpServletRequestWrapper mockRequest = new MockHttpServletRequestWrapper(){

            public String getPathTranslated() {
                return null;
            }
        };
        mockRequest.setMethod(method);
        mockRequest.setRequestURI(requestURI);
        mockRequest.addHeader("Accept", acceptHeader);
        return mockRequest;
    }

    public static MockHttpServletRequest constructMockRequest(String method, String requestURI, String acceptHeader, String contentType, byte[] content) {
        MockHttpServletRequest mockRequest = MockRequestConstructor.constructMockRequest(method, requestURI, acceptHeader);
        mockRequest.setContentType(contentType);
        mockRequest.setContent(content);
        return mockRequest;
    }

    public static MockHttpServletRequest constructMockRequest(String method, String requestURI, String acceptHeader, Map<?, ?> parameters, Map<String, Object> attributes) {
        MockHttpServletRequest mockRequest = MockRequestConstructor.constructMockRequest(method, requestURI, acceptHeader);
        if (attributes != null) {
            Set<String> attributeNames = attributes.keySet();
            for (String attributeName : attributeNames) {
                Object attributeValue = attributes.get(attributeName);
                mockRequest.setAttribute(attributeName, attributeValue);
            }
        }
        mockRequest.setParameters(parameters);
        return mockRequest;
    }
}

